/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jgroups.annotations.Unsupported;
import org.jgroups.persistence.CannotPersistException;
import org.jgroups.persistence.CannotRemoveException;
import org.jgroups.persistence.CannotRetrieveException;
import org.jgroups.persistence.PersistenceManager;

@Unsupported
public class FilePersistenceManager
implements PersistenceManager {
    private final File file;

    public FilePersistenceManager(String propertiesFilename) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(propertiesFilename));
        String path = properties.getProperty("persist");
        this.file = new File(path);
        this.file.createNewFile();
    }

    @Override
    public void save(Serializable key, Serializable val) throws CannotPersistException {
        try {
            Map map = this.retrieveAll();
            map.put(key, val);
            this.saveAll(map);
        }
        catch (CannotRetrieveException e) {
            throw new CannotPersistException(e, "Unable to pre-load existing store.");
        }
    }

    @Override
    public Serializable remove(Serializable key) throws CannotRemoveException {
        Object o;
        try {
            Map map = this.retrieveAll();
            o = map.remove(key);
            this.saveAll(map);
        }
        catch (CannotRetrieveException e) {
            throw new CannotRemoveException(e, "Unable to pre-load existing store.");
        }
        catch (CannotPersistException e) {
            throw new CannotRemoveException(e, "Unable to pre-load existing store.");
        }
        return (Serializable)o;
    }

    @Override
    public void saveAll(Map map) throws CannotPersistException {
        try {
            FileOutputStream fos = new FileOutputStream(this.file);
            Properties prop = new Properties();
            for (Map.Entry entry : map.entrySet()) {
                prop.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
            prop.store(fos, null);
            fos.flush();
            ((OutputStream)fos).close();
        }
        catch (IOException e) {
            throw new CannotPersistException(e, "Cannot save to: " + this.file.getAbsolutePath());
        }
    }

    @Override
    public Map retrieveAll() throws CannotRetrieveException {
        try {
            Properties prop = new Properties();
            FileInputStream fis = new FileInputStream(this.file);
            prop.load(fis);
            fis.close();
            return this.filterLoadedValues(prop);
        }
        catch (IOException e) {
            throw new CannotRetrieveException(e, "Unable to load from file: " + this.file.getAbsolutePath());
        }
    }

    protected Map filterLoadedValues(Map in) {
        HashMap<String, Float> out = new HashMap<String, Float>();
        for (Map.Entry entry : in.entrySet()) {
            out.put(entry.getKey().toString(), Float.valueOf(entry.getValue().toString()));
        }
        return out;
    }

    @Override
    public void clear() throws CannotRemoveException {
        try {
            this.saveAll(Collections.EMPTY_MAP);
        }
        catch (CannotPersistException e) {
            throw new CannotRemoveException(e, "Unable to clear map.");
        }
    }

    @Override
    public void shutDown() {
    }
}

