/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.protocol.spec200502;

import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.serialization.RMAbstractSerializable;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spec200502.RMProviderImpl;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequence;

final class RMSequenceImpl
extends RMAbstractSerializable
implements RMSequence {
    private static final RMProvider PROVIDER = RMProviderImpl.getInstance();
    private String identifier;
    private long messageNumber;
    private boolean isLastMessage;

    RMSequenceImpl() {
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public long getMessageNumber() {
        return this.messageNumber;
    }

    @Override
    public boolean isLastMessage() {
        return this.isLastMessage;
    }

    @Override
    public void setIdentifier(String identifier) {
        if (identifier == null || identifier.trim().equals("")) {
            throw new IllegalArgumentException("Identifier cannot be null nor empty string");
        }
        if (this.identifier != null) {
            throw new UnsupportedOperationException("Value already set, cannot be overriden");
        }
        this.identifier = identifier;
    }

    @Override
    public void setLastMessage() {
        this.isLastMessage = true;
    }

    @Override
    public void setMessageNumber(long messageNumber) {
        if (messageNumber <= 0L) {
            throw new IllegalArgumentException("Value must be greater than 0");
        }
        if (this.messageNumber > 0L) {
            throw new UnsupportedOperationException("Value already set, cannot be overriden");
        }
        this.messageNumber = messageNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.isLastMessage ? 1231 : 1237);
        result = 31 * result + (int)(this.messageNumber ^ this.messageNumber >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RMSequenceImpl)) {
            return false;
        }
        RMSequenceImpl other = (RMSequenceImpl)obj;
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        if (this.isLastMessage != other.isLastMessage) {
            return false;
        }
        return this.messageNumber == other.messageNumber;
    }

    @Override
    public RMProvider getProvider() {
        return PROVIDER;
    }

    @Override
    public void validate() {
        if (this.identifier == null) {
            throw new RMException("Identifier must be set");
        }
        if (this.messageNumber == 0L) {
            throw new RMException("MessageNumber must be set");
        }
    }
}

