/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.richfaces.component.util.ComponentMessageUtil;
import org.richfaces.component.util.MessageUtil;

public abstract class UIRangedNumberInput
extends UIInput {
    private static final String MSG_MAXMIN_IS_NULL = "org.richfaces.component.UIRangedNumberInput.MaxMinIsNull";
    private static final String MSG_VALUE_IS_NULL = "org.richfaces.component.UIRangedNumberInput.ValueIsNull";
    private static final String MSG_LT_MINIMAL = "org.richfaces.component.UIRangedNumberInput.LessThatMinimal";
    private static final String MSG_GT_MAXIMAL = "org.richfaces.component.UIRangedNumberInput.GreaterThanMaximal";

    public abstract String getMaxValue();

    public abstract void setMaxValue(String var1);

    public abstract String getMinValue();

    public abstract void setMinValue(String var1);

    public abstract boolean isDisabled();

    public abstract void setDisabled(boolean var1);

    public void decode(FacesContext arg0) {
        if (this.isDisabled()) {
            return;
        }
        super.decode(arg0);
    }

    protected void validateValue(FacesContext context, Object newValue) {
        if (this.isValid() && !UIRangedNumberInput.isEmpty(newValue)) {
            String label = MessageUtil.getLabel(context, (UIComponent)this).toString();
            Double minValue = null;
            Double maxValue = null;
            Double value = null;
            try {
                minValue = this.convert(this.getMinValue());
                maxValue = this.convert(this.getMaxValue());
                value = this.convert(newValue);
            }
            catch (Exception e) {
                this.setValid(false);
                FacesMessage mess = new FacesMessage(label + ": " + e.getLocalizedMessage());
                mess.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(this.getClientId(context), mess);
            }
            if (value != null) {
                if (null == minValue || null == maxValue) {
                    this.setValid(false);
                    FacesMessage mess = ComponentMessageUtil.getMessage(context, MSG_MAXMIN_IS_NULL, new Object[]{label});
                    mess.setSeverity(FacesMessage.SEVERITY_ERROR);
                    context.addMessage(this.getClientId(context), mess);
                } else if (minValue > value) {
                    this.setValid(false);
                    FacesMessage mess = ComponentMessageUtil.getMessage(context, MSG_LT_MINIMAL, new Object[]{label});
                    mess.setSeverity(FacesMessage.SEVERITY_ERROR);
                    context.addMessage(this.getClientId(context), mess);
                } else if (maxValue < value) {
                    this.setValid(false);
                    FacesMessage mess = ComponentMessageUtil.getMessage(context, MSG_GT_MAXIMAL, new Object[]{label});
                    mess.setSeverity(FacesMessage.SEVERITY_ERROR);
                    context.addMessage(this.getClientId(context), mess);
                }
            } else {
                this.setValid(false);
                FacesMessage mess = ComponentMessageUtil.getMessage(context, MSG_VALUE_IS_NULL, new Object[]{label});
                mess.setSeverity(FacesMessage.SEVERITY_ERROR);
                context.addMessage(this.getClientId(context), mess);
            }
        }
        super.validateValue(context, newValue);
    }

    private Double convert(Object object) {
        if (object == null) {
            return null;
        }
        return new Double(object.toString());
    }

    public static boolean isEmpty(Object newValue) {
        if (newValue == null) {
            return true;
        }
        if (newValue instanceof String) {
            return ((String)newValue).length() == 0;
        }
        return false;
    }
}

