/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.IOException;
import org.jboss.remoting3.LocalRemoteRequestHandler;
import org.jboss.remoting3.LocalRequestHandlerConnector;
import org.jboss.remoting3.ServiceNotFoundException;
import org.jboss.remoting3.ServiceURI;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.LocalRequestHandler;
import org.jboss.remoting3.spi.RemoteRequestHandler;
import org.jboss.remoting3.spi.RequestHandlerConnector;
import org.jboss.xnio.Cancellable;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalConnectionHandler
implements ConnectionHandler {
    private final ConnectionHandlerContext connectionHandlerContext;
    private final OptionMap connectionOptionMap;

    public LocalConnectionHandler(ConnectionHandlerContext connectionHandlerContext, OptionMap connectionOptionMap) {
        this.connectionHandlerContext = connectionHandlerContext;
        this.connectionOptionMap = connectionOptionMap;
    }

    @Override
    public Cancellable open(String serviceType, String groupName, Result<RemoteRequestHandler> result, ClassLoader classLoader, OptionMap optionMap) {
        LocalRequestHandler handler = this.connectionHandlerContext.openService(serviceType, groupName, optionMap);
        if (handler == null) {
            result.setException((IOException)new ServiceNotFoundException(ServiceURI.create(serviceType, groupName, null)));
        } else {
            LocalRemoteRequestHandler requestHandler = new LocalRemoteRequestHandler(handler, classLoader, optionMap, this.connectionOptionMap, this.connectionHandlerContext.getConnectionProviderContext().getExecutor());
            result.setResult((Object)requestHandler);
        }
        return IoUtils.nullCancellable();
    }

    @Override
    public RequestHandlerConnector createConnector(LocalRequestHandler localHandler) {
        return new LocalRequestHandlerConnector(localHandler, this.connectionHandlerContext.getConnectionProviderContext().getExecutor());
    }

    @Override
    public void close() throws IOException {
        this.connectionHandlerContext.remoteClosed();
    }
}

