/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.AOM;
import org.jacorb.poa.POA;
import org.jacorb.poa.POAAdapter;
import org.jacorb.poa.POAMonitor;
import org.jacorb.poa.RPPoolManager;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.poa.RequestQueue;
import org.jacorb.poa.except.ApplicationError;
import org.jacorb.poa.gui.POAMonitorController;
import org.jacorb.poa.gui.POAMonitorView;
import org.jacorb.poa.gui.poa.POAFrame;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.poa.util.StringPair;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.PortableServer.Servant;
import org.slf4j.Logger;

public class POAMonitorImpl
extends POAAdapter
implements POAMonitor,
POAMonitorController,
Configurable {
    private POA poaModel;
    private AOM aomModel;
    private RequestQueue queueModel;
    private RPPoolManager pmModel;
    private POAMonitorView view;
    private String prefix;
    private int aomSize;
    private int queueSize;
    private int poolCount;
    private int poolSize;
    private boolean terminate;
    private boolean aomChanged;
    private boolean queueChanged;
    private boolean pmChanged;
    private Configuration configuration = null;
    private Logger logger;
    private int threadPoolMin = 0;
    private int threadPoolMax = 0;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.logger = this.configuration.getLogger("jacorb.poa.monitor");
        this.threadPoolMin = this.configuration.getAttributeAsInteger("jacorb.poa.thread_pool_min", 5);
        this.threadPoolMax = this.configuration.getAttributeAsInteger("jacorb.poa.thread_pool_max", 20);
    }

    public void actionCloseView() {
        this.closeMonitor();
    }

    public void actionDeactivateObject(String string) {
        if (this.poaModel != null) {
            try {
                this.poaModel.deactivate_object(string.getBytes());
            }
            catch (Throwable throwable) {
                this.printMessage("Exception occurred in deactivateObject() of POAMonitor: " + throwable);
            }
        }
    }

    public void actionRemoveRequestFromQueue(String string) {
        if (this.queueModel != null && this.poaModel != null) {
            try {
                ServerRequest serverRequest = this.queueModel.getElementAndRemove(Integer.parseInt(string));
                if (serverRequest == null) {
                    throw new ApplicationError("error: rid " + string + " is not contained in queue");
                }
                this.poaModel.getRequestController().rejectRequest(serverRequest, new OBJ_ADAPTER());
            }
            catch (Throwable throwable) {
                this.printMessage("Exception occurred in removeRequestFromQueue() of POAMonitor: " + throwable);
            }
        }
    }

    public StringPair[] actionRetrieveAOMContent() {
        if (this.aomModel != null) {
            try {
                return this.aomModel != null ? this.aomModel.deliverContent() : null;
            }
            catch (Throwable throwable) {
                this.printMessage("Exception occurred in retrieveAOMContent() of POAMonitor: " + throwable);
            }
        }
        return null;
    }

    public StringPair[] actionRetrieveQueueContent() {
        if (this.queueModel != null) {
            try {
                return this.queueModel.deliverContent();
            }
            catch (Throwable throwable) {
                this.printMessage("Exception during retrieveQueueContent() of POAMonitor: " + throwable);
            }
        }
        return null;
    }

    public synchronized void changeState(String string) {
        block3: {
            if (this.view != null) {
                try {
                    this.view._setState(string);
                }
                catch (Throwable throwable) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception during changeState() of POAMonitor" + throwable.getMessage());
                }
            }
        }
    }

    public synchronized void closeMonitor() {
        block3: {
            if (this.view != null) {
                try {
                    this.terminate = true;
                    this.poaModel._removePOAEventListener(this);
                    POAMonitor pOAMonitor = (POAMonitor)Class.forName("org.jacorb.poa.POAMonitorLightImpl").newInstance();
                    pOAMonitor.init(this.poaModel, this.aomModel, this.queueModel, this.pmModel, this.prefix);
                    pOAMonitor.configure(this.configuration);
                    this.poaModel.setMonitor(pOAMonitor);
                    POAMonitorView pOAMonitorView = this.view;
                    this.view = null;
                    pOAMonitorView._destroy();
                }
                catch (Throwable throwable) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception during closeMonitor() of POAMonitorImpl" + throwable.getMessage());
                }
            }
        }
    }

    public void init(POA pOA, AOM aOM, RequestQueue requestQueue, RPPoolManager rPPoolManager, String string) {
        this.poaModel = pOA;
        this.aomModel = aOM;
        this.queueModel = requestQueue;
        this.pmModel = rPPoolManager;
        this.prefix = string;
    }

    private void initView() {
        block3: {
            if (this.view != null) {
                try {
                    String string = this.poaModel._getQualifiedName();
                    this.view._setName(string.equals("") ? "RootPOA" : "RootPOA/" + string);
                    this.view._setState(POAUtil.convert(this.poaModel.getState()));
                    this.view._setPolicyThread(POAUtil.convert(this.poaModel.threadPolicy, 16));
                    this.view._setPolicyLifespan(POAUtil.convert(this.poaModel.lifespanPolicy, 17));
                    this.view._setPolicyIdUniqueness(POAUtil.convert(this.poaModel.idUniquenessPolicy, 18));
                    this.view._setPolicyIdAssignment(POAUtil.convert(this.poaModel.idAssignmentPolicy, 19));
                    this.view._setPolicyServantRetention(POAUtil.convert(this.poaModel.servantRetentionPolicy, 21));
                    this.view._setPolicyRequestProcessing(POAUtil.convert(this.poaModel.requestProcessingPolicy, 22));
                    this.view._setPolicyImplicitActivation(POAUtil.convert(this.poaModel.implicitActivationPolicy, 20));
                    this.view._initAOMBar(this.aomModel != null ? 10 : 0, true);
                    this.view._initQueueBar(10, true);
                    this.view._initActiveRequestsBar(this.poaModel.isSingleThreadModel() ? 1 : this.threadPoolMin, this.poaModel.isSingleThreadModel() ? 1 : this.threadPoolMax);
                    this.view._initThreadPoolBar(0);
                }
                catch (Throwable throwable) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception during initView() of POAMonitor" + throwable.getMessage());
                }
            }
        }
    }

    public void objectActivated(byte[] byArray, Servant servant, int n) {
        this.aomSize = n;
        this.aomChanged = true;
        this.refreshAOM();
    }

    public void objectDeactivated(byte[] byArray, Servant servant, int n) {
        this.aomSize = n;
        this.aomChanged = true;
        this.refreshAOM();
    }

    public synchronized void openMonitor() {
        block3: {
            if (this.view == null) {
                try {
                    this.aomSize = this.aomModel != null ? this.aomModel.size() : 0;
                    this.queueSize = this.queueModel.size();
                    this.poolCount = this.pmModel.getPoolCount();
                    this.poolSize = this.pmModel.getPoolSize();
                    this.view = new POAFrame(this);
                    this.initView();
                    this.refreshView();
                    this.poaModel._addPOAEventListener(this);
                    this.view._setVisible(true);
                }
                catch (Throwable throwable) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception occurred in openMonitor() of POAMonitor" + throwable.getMessage());
                }
            }
        }
    }

    private synchronized void printMessage(String string) {
        if (this.view != null) {
            try {
                this.view._printMessage(string);
            }
            catch (Throwable throwable) {
                System.err.println("Exception occurred in _printMessage() of POAMonitor");
            }
        }
    }

    public void processorAddedToPool(RequestProcessor requestProcessor, int n, int n2) {
        this.poolCount = n;
        this.poolSize = n2;
        this.pmChanged = true;
        this.refreshPM();
    }

    public void processorRemovedFromPool(RequestProcessor requestProcessor, int n, int n2) {
        this.poolCount = n;
        this.poolSize = n2;
        this.pmChanged = true;
        this.refreshPM();
    }

    private void refreshAOM() {
        block3: {
            if (this.view != null) {
                try {
                    this.view._setValueAOMBar(this.aomSize);
                }
                catch (Throwable throwable) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception during refreshAOM() of POAMonitor" + throwable.getMessage());
                }
            }
        }
    }

    private void refreshPM() {
        block3: {
            if (this.view != null) {
                try {
                    this.view._setValueActiveRequestsBar(this.poolSize - this.poolCount);
                    this.view._setMaxThreadPoolBar(this.poolSize);
                    this.view._setValueThreadPoolBar(this.poolCount);
                }
                catch (Throwable throwable) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception occurred in refreshPM() of POAMonitor" + throwable.getMessage());
                }
            }
        }
    }

    private void refreshQueue() {
        block3: {
            if (this.view != null) {
                try {
                    this.view._setValueQueueBar(this.queueSize);
                }
                catch (Throwable throwable) {
                    if (!this.logger.isWarnEnabled()) break block3;
                    this.logger.warn("Exception occurred in refreshQueue() of POAMonitor: " + throwable.getMessage());
                }
            }
        }
    }

    private void refreshView() {
        this.refreshAOM();
        this.refreshQueue();
        this.refreshPM();
    }

    public void requestAddedToQueue(ServerRequest serverRequest, int n) {
        this.queueSize = n;
        this.queueChanged = true;
        this.refreshQueue();
    }

    public void requestRemovedFromQueue(ServerRequest serverRequest, int n) {
        this.queueSize = n;
        this.queueChanged = true;
        this.refreshQueue();
    }
}

