/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.plugins.management.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.spi.management.ContextStateMapper;
import org.jboss.deployers.spi.management.ManagedComponentRuntimeDispatcher;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.MutableManagedComponent;
import org.jboss.managed.api.MutableManagedObject;
import org.jboss.managed.api.RunState;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.profileservice.plugins.management.util.AbstractManagementProxyFactory;
import org.jboss.profileservice.plugins.management.util.DefaultContextStateMapper;
import org.jboss.profileservice.plugins.management.util.ManagedObjectProcessor;
import org.jboss.profileservice.plugins.spi.ProfileViewProcessingContext;

public abstract class ManagedObjectRuntimeProcessor
extends ManagedObjectProcessor {
    private static final Logger log = Logger.getLogger(ManagedObjectRuntimeProcessor.class);
    private Map<String, ManagedObject> runtimeMOs = new HashMap<String, ManagedObject>();
    private static final ContextStateMapper<RunState> runStateMapper;
    private final ManagedComponentRuntimeDispatcher dispatcher;
    private final AbstractManagementProxyFactory proxyFactory;

    public ManagedObjectRuntimeProcessor(AbstractManagementProxyFactory proxyFactory) {
        if (proxyFactory == null) {
            throw new IllegalArgumentException("null proxy factory");
        }
        if (proxyFactory.getDispatcher() == null) {
            throw new IllegalArgumentException("null runtime component dispatcher");
        }
        this.proxyFactory = proxyFactory;
        this.dispatcher = proxyFactory.getDispatcher();
    }

    @Override
    protected void processManagedObject(String key, ManagedObject mo, ManagedDeployment md, ProfileViewProcessingContext context) throws Exception {
        boolean trace = log.isTraceEnabled();
        ManagementObject managementObject = this.getAnnotation(mo, ManagementObject.class);
        if (managementObject.isRuntime()) {
            ManagedComponent comp;
            boolean merged = false;
            ManagementComponent mc = managementObject.componentType();
            boolean isMC = mc.type().length() != 0 || mc.subtype().length() != 0;
            ManagedObject parentMO = this.getRegisteredManagedObject(key);
            if (parentMO == null && !isMC) {
                if (trace) {
                    log.trace((Object)("Deferring resolution of runtime ManagedObject: " + managementObject));
                }
                this.runtimeMOs.put(key, mo);
            } else {
                this.mergeRuntimeMO(parentMO, mo);
                merged = true;
                this.runtimeMOs.remove(key);
            }
            if (md != null && md.getComponents() != null && (comp = md.getComponent(mo.getName())) != null) {
                RunState state = this.updateRunState(mo, comp);
                if (trace) {
                    log.trace((Object)("Updated component: " + comp + " run state to: " + state));
                }
            }
            if (!isMC) {
                return;
            }
            if (!merged) {
                Set<ManagedOperation> runtimeOps = mo.getOperations();
                runtimeOps = this.createOperationProxies(mo, runtimeOps);
                MutableManagedObject moi = (MutableManagedObject)mo;
                moi.setOperations(runtimeOps);
            }
        } else {
            ManagedObject runtimeMO = this.runtimeMOs.get(key);
            if (runtimeMO != null) {
                ManagedComponent comp;
                this.mergeRuntimeMO(mo, runtimeMO);
                this.runtimeMOs.remove(key);
                if (md != null && md.getComponents() != null && (comp = md.getComponent(mo.getName())) != null) {
                    RunState state = this.updateRunState(runtimeMO, comp);
                    if (trace) {
                        log.trace((Object)("Updated component: " + comp + " run state to: " + state));
                    }
                }
            }
        }
        super.processManagedObject(key, mo, md, context);
    }

    protected void mergeRuntimeMO(ManagedObject mo, ManagedObject runtimeMO) throws Exception {
        boolean trace = log.isTraceEnabled();
        Map runtimeProps = runtimeMO.getProperties();
        Set<ManagedOperation> runtimeOps = runtimeMO.getOperations();
        Object componentName = runtimeMO.getComponentName();
        if (trace) {
            log.trace((Object)("Merging runtime: " + runtimeMO.getName() + ", compnent name: " + componentName));
        }
        Map moProps = null;
        Set moOps = null;
        HashMap<String, ManagedProperty> props = null;
        HashSet<ManagedOperation> ops = null;
        if (mo == null) {
            mo = runtimeMO;
            moProps = mo.getProperties();
            moOps = mo.getOperations();
            props = new HashMap();
            ops = new HashSet<ManagedOperation>();
        } else {
            moProps = mo.getProperties();
            moOps = mo.getOperations();
            props = new HashMap<String, ManagedProperty>(moProps);
            ops = new HashSet(moOps);
        }
        if (runtimeProps != null && runtimeProps.size() > 0) {
            if (trace) {
                log.trace((Object)("Properties before:" + props));
            }
            for (ManagedProperty prop : runtimeProps.values()) {
                if (prop.hasViewUse(ViewUse.STATISTIC)) {
                    String propName = prop.getMappedName();
                    try {
                        MetaValue propValue = this.dispatcher.get(componentName, prop);
                        if (propValue != null) {
                            prop.setValue(propValue);
                        }
                    }
                    catch (Throwable t) {
                        log.debug((Object)("Failed to get stat value, " + componentName + ":" + propName));
                    }
                    ManagedProperty proxiedProp = this.createPropertyProxy(prop);
                    props.put(prop.getName(), proxiedProp);
                } else {
                    props.put(prop.getName(), prop);
                }
                if (prop.getTargetManagedObject() != null) continue;
                prop.setTargetManagedObject(runtimeMO);
            }
            if (trace) {
                log.trace((Object)("Properties after:" + props));
            }
        }
        if (runtimeOps != null && runtimeOps.size() > 0) {
            if (trace) {
                log.trace((Object)("Ops before:" + ops));
            }
            runtimeOps = this.createOperationProxies(runtimeMO, runtimeOps);
            ops.addAll(runtimeOps);
            if (trace) {
                log.trace((Object)("Ops after:" + ops));
            }
        }
        MutableManagedObject moi = (MutableManagedObject)mo;
        moi.setProperties(props);
        moi.setOperations(ops);
    }

    @Override
    protected MutableManagedComponent createManagedComponentProxy(Object componentName, MutableManagedComponent component) {
        return (MutableManagedComponent)MutableManagedComponent.class.cast(this.proxyFactory.createComponentProxy((ManagedComponent)component, componentName));
    }

    protected Set<ManagedOperation> createOperationProxies(ManagedObject mo, Set<ManagedOperation> ops) throws Exception {
        if (this.proxyFactory == null) {
            throw new IllegalArgumentException("Missing RuntimeComponentDispatcher.");
        }
        Object componentName = mo.getComponentName();
        return this.createOperationProxies(ops, componentName);
    }

    protected Set<ManagedOperation> createOperationProxies(Set<ManagedOperation> ops, Object componentName) throws Exception {
        HashSet<ManagedOperation> operations = new HashSet<ManagedOperation>();
        for (ManagedOperation op : ops) {
            ManagedOperation operation = this.proxyFactory.createOperationProxy(op, componentName);
            operations.add(operation);
        }
        return operations;
    }

    private ManagedProperty createPropertyProxy(ManagedProperty prop) throws Exception {
        if (this.proxyFactory == null) {
            throw new IllegalArgumentException("Missing RuntimeComponentDispatcher.");
        }
        Object componentName = prop.getManagedObject().getComponentName();
        return this.proxyFactory.createPropertyProxy(prop, componentName);
    }

    @Override
    protected RunState updateRunState(ManagedObject runtimeMO, ManagedComponent comp) {
        RunState state = comp.getRunState();
        if (state == RunState.UNKNOWN && this.dispatcher != null) {
            Object name = comp.getComponentName();
            if (name == null && runtimeMO != null) {
                name = runtimeMO.getComponentName();
            }
            if (name != null) {
                state = this.getMappedState(name, runStateMapper);
                if (comp instanceof MutableManagedComponent) {
                    MutableManagedComponent mcomp = (MutableManagedComponent)MutableManagedComponent.class.cast(comp);
                    mcomp.setRunState(state);
                }
            }
        }
        return state;
    }

    protected <T extends Enum<?>> T getMappedState(Object name, ContextStateMapper<T> mapper) {
        Enum state = null;
        if (this.dispatcher != null) {
            try {
                state = this.dispatcher.mapControllerState(name, mapper);
            }
            catch (Exception e) {
                state = mapper.getErrorState();
            }
        }
        return (T)state;
    }

    static {
        HashMap<String, RunState> runStateMappings = new HashMap<String, RunState>();
        runStateMappings.put("**ERROR**", RunState.FAILED);
        runStateMappings.put("Not Installed", RunState.STOPPED);
        runStateMappings.put("PreInstall", RunState.STOPPED);
        runStateMappings.put("Described", RunState.STOPPED);
        runStateMappings.put("Instantiated", RunState.STOPPED);
        runStateMappings.put("Configured", RunState.STOPPED);
        runStateMappings.put("Create", RunState.STOPPED);
        runStateMappings.put("Start", RunState.STOPPED);
        runStateMappings.put("Installed", RunState.RUNNING);
        runStateMapper = new DefaultContextStateMapper<RunState>(runStateMappings, RunState.STARTING, RunState.STOPPED, RunState.FAILED, RunState.UNKNOWN);
    }
}

