/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.context;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialResponseWriter
extends ResponseWriterWrapper {
    public static final String RENDER_ALL_MARKER = "javax.faces.ViewRoot";
    public static final String VIEW_STATE_MARKER = "javax.faces.ViewState";
    private ResponseWriter _wrapped;
    private boolean hasChanges;
    private String insertType;

    public PartialResponseWriter(ResponseWriter writer) {
        this._wrapped = writer;
    }

    public void delete(String targetId) throws IOException {
        this.startChanges();
        this._wrapped.startElement("delete", null);
        this._wrapped.writeAttribute("id", targetId, null);
        this._wrapped.endElement("delete");
    }

    @Override
    public void endDocument() throws IOException {
        if (this.hasChanges) {
            this.endInsert();
            this._wrapped.endElement("changes");
            this.hasChanges = false;
        }
        this._wrapped.endElement("partial-response");
    }

    public void endError() throws IOException {
        this._wrapped.endCDATA();
        this._wrapped.endElement("error-message");
        this._wrapped.endElement("error");
    }

    public void endEval() throws IOException {
        this._wrapped.endCDATA();
        this._wrapped.endElement("eval");
    }

    public void endExtension() throws IOException {
        this._wrapped.endElement("extension");
    }

    public void endInsert() throws IOException {
        if (this.insertType == null) {
            return;
        }
        this._wrapped.endCDATA();
        this._wrapped.endElement(this.insertType);
        this._wrapped.endElement("insert");
        this.insertType = null;
    }

    public void endUpdate() throws IOException {
        this._wrapped.endCDATA();
        this._wrapped.endElement("update");
    }

    @Override
    public ResponseWriter getWrapped() {
        return this._wrapped;
    }

    public void redirect(String url) throws IOException {
        this._wrapped.startElement("redirect", null);
        this._wrapped.writeAttribute("url", url, null);
        this._wrapped.endElement("redirect");
    }

    @Override
    public void startDocument() throws IOException {
        this._wrapped.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this._wrapped.startElement("partial-response", null);
    }

    public void startError(String errorName) throws IOException {
        this._wrapped.startElement("error", null);
        this._wrapped.startElement("error-name", null);
        this._wrapped.write(errorName);
        this._wrapped.endElement("error-name");
        this._wrapped.startElement("error-message", null);
        this.startCDATA();
    }

    @Override
    public void startCDATA() throws IOException {
        this._wrapped.startCDATA();
    }

    @Override
    public void endCDATA() throws IOException {
        this._wrapped.endCDATA();
    }

    public void startEval() throws IOException {
        this.startChanges();
        this._wrapped.startElement("eval", null);
        this.startCDATA();
    }

    public void startExtension(Map<String, String> attributes) throws IOException {
        this.startChanges();
        this._wrapped.startElement("extension", null);
        for (String attrName : attributes.keySet()) {
            this._wrapped.writeAttribute(attrName, attributes.get(attrName), null);
        }
    }

    public void startInsertAfter(String targetId) throws IOException {
        this.startInsertCommon("after", targetId);
    }

    public void startInsertBefore(String targetId) throws IOException {
        this.startInsertCommon("before", targetId);
    }

    public void startUpdate(String targetId) throws IOException {
        this.startChanges();
        this._wrapped.startElement("update", null);
        this._wrapped.writeAttribute("id", targetId, null);
        this.startCDATA();
    }

    public void updateAttributes(String targetId, Map<String, String> attributes) throws IOException {
        this.startChanges();
        this._wrapped.startElement("attributes", null);
        this._wrapped.writeAttribute("id", targetId, null);
        for (String attrName : attributes.keySet()) {
            this._wrapped.startElement("attribute", null);
            this._wrapped.writeAttribute("name", attrName, null);
            this._wrapped.writeAttribute("value", attributes.get(attrName), null);
            this._wrapped.endElement("attribute");
        }
        this._wrapped.endElement("attributes");
    }

    private void startChanges() throws IOException {
        if (!this.hasChanges) {
            this._wrapped.startElement("changes", null);
            this.hasChanges = true;
        }
    }

    private void startInsertCommon(String type, String targetId) throws IOException {
        if (this.insertType != null) {
            return;
        }
        this.insertType = type;
        this.startChanges();
        this._wrapped.startElement("insert", null);
        this._wrapped.startElement(this.insertType, null);
        this._wrapped.writeAttribute("id", targetId, null);
        this.startCDATA();
    }
}

