/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.server;

import org.jboss.ws.extensions.wsrm.common.RMHelper;
import org.jboss.ws.extensions.wsrm.server.RMInvocationHandler;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.common.integration.AbstractDeploymentAspect;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.invocation.InvocationHandler;

public final class RMDeploymentAspect
extends AbstractDeploymentAspect {
    public final void start(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)ep.getAttachment(ServerEndpointMetaData.class);
            if (sepMetaData == null) {
                throw new IllegalStateException("Cannot obtain endpoint meta data");
            }
            if (sepMetaData.getConfig().getRMMetaData() == null) continue;
            InvocationHandler origInvHandler = ep.getInvocationHandler();
            RMInvocationHandler wsrmInvHandler = new RMInvocationHandler(origInvHandler, (ArchiveDeployment)dep);
            ep.setInvocationHandler((InvocationHandler)wsrmInvHandler);
            RMHelper.setupRMOperations(sepMetaData);
            this.log.info((Object)("WS-RM invocation handler associated with endpoint " + ep.getAddress()));
        }
    }

    public final void stop(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            InvocationHandler invHandler = ep.getInvocationHandler();
            if (!(invHandler instanceof RMInvocationHandler)) continue;
            RMInvocationHandler rmInvHandler = (RMInvocationHandler)invHandler;
            ep.setInvocationHandler(rmInvHandler.getDelegate());
            this.log.info((Object)("WS-RM invocation handler removed for endpoint " + ep.getAddress()));
        }
    }
}

