/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPFaultElement;
import org.jboss.logging.Logger;
import org.jboss.ws.Constants;
import org.jboss.ws.core.soap.DetailImpl;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPBodyElementDoc;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPFaultElementImpl;
import org.jboss.ws.core.utils.SAAJUtils;
import org.jboss.wsf.common.DOMWriter;
import org.jboss.xb.QNameBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SOAPFaultImpl
extends SOAPBodyElementDoc
implements SOAPFault {
    private static Logger log = Logger.getLogger(SOAPFaultImpl.class);
    private SOAPElement faultcode;
    private SOAPElement faultstring;
    private SOAPElement faultactor;
    private SOAPElement faultnode;
    private Detail detail;
    public static final Set<QName> soap11FaultCodes = new HashSet<QName>();
    public static final Set<QName> soap12FaultCodes;

    public SOAPFaultImpl() throws SOAPException {
        this("env", "http://schemas.xmlsoap.org/soap/envelope/");
    }

    public SOAPFaultImpl(String prefix, String namespace) throws SOAPException {
        super(new NameImpl("Fault", prefix, namespace));
    }

    public String getFaultCode() {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            if (this.faultcode == null) {
                this.findFaultCodeElement();
            }
            return this.faultcode.getValue();
        }
        if (this.faultcode == null) {
            this.findCodeElement();
        }
        return SOAPFaultImpl.getChildValueElement(this.faultcode).getValue();
    }

    public Name getFaultCodeAsName() {
        return new NameImpl(this.getFaultCodeAsQName());
    }

    public QName getFaultCodeAsQName() {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            if (this.faultcode == null) {
                this.findFaultCodeElement();
            }
            return QNameBuilder.buildQName((Element)this.faultcode, (String)this.faultcode.getValue());
        }
        if (this.faultcode == null) {
            this.findCodeElement();
        }
        SOAPElement valueElement = SOAPFaultImpl.getChildValueElement(this.faultcode);
        return QNameBuilder.buildQName((Element)valueElement, (String)valueElement.getValue());
    }

    private void findFaultCodeElement() {
        this.faultcode = SOAPFaultImpl.getChildElement(this, Constants.SOAP11_FAULTCODE);
        log.trace((Object)("findFaultCodeElement : " + this.faultcode));
    }

    private void findCodeElement() {
        this.faultcode = SOAPFaultImpl.getChildElement(this, Constants.SOAP12_CODE);
        log.trace((Object)("findCodeElement : " + this.faultcode));
    }

    private static SOAPElement getChildValueElement(SOAPElement codeElement) {
        return SOAPFaultImpl.getChildElement(codeElement, Constants.SOAP12_VALUE);
    }

    public void setFaultCode(String faultCode) throws SOAPException {
        QName qname = QNameBuilder.buildQName((Element)((Object)this), (String)faultCode);
        this.setFaultCode(qname);
    }

    public void setFaultCode(Name faultCode) throws SOAPException {
        this.setFaultCode(((NameImpl)faultCode).toQName());
    }

    public void setFaultCode(QName faultCode) throws SOAPException {
        boolean isSOAP11 = "http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI());
        String faultCodeNS = faultCode.getNamespaceURI();
        if (faultCodeNS.length() == 0) {
            throw new SOAPException("Fault code '" + faultCode + "' must be namespace qualified");
        }
        if (isSOAP11) {
            if (this.faultcode == null) {
                this.findFaultCodeElement();
                if (this.faultcode == null) {
                    this.faultcode = this.addUnqualifiedFaultElement("faultcode");
                }
            }
            SOAPFaultImpl.setCode(this.faultcode, faultCode);
        } else {
            if (!soap12FaultCodes.contains(faultCode)) {
                throw new SOAPException(faultCode + " is not a standard SOAP 1.2 Code value");
            }
            if (this.faultcode == null) {
                this.findCodeElement();
                if (this.faultcode == null) {
                    this.faultcode = this.addQualifiedFaultElement("Code");
                    SOAPFaultImpl.addChildValueElement(this.faultcode);
                }
            }
            SOAPFaultImpl.setCode(SOAPFaultImpl.getChildValueElement(this.faultcode), faultCode);
        }
    }

    private static void setCode(SOAPElement codeElement, QName code) throws SOAPException {
        SAAJUtils.setQualifiedElementValue(codeElement, code);
    }

    private static SOAPElement addChildValueElement(SOAPElement codeElement) throws SOAPException {
        return codeElement.addChildElement("Value", codeElement.getPrefix(), codeElement.getNamespaceURI());
    }

    public Iterator getFaultSubcodes() {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Subcode");
        }
        ArrayList<QName> subcodes = new ArrayList<QName>();
        SOAPElement baseCodeElement = this.faultcode;
        SOAPElement subcodeElement = SOAPFaultImpl.getChildSubcodeElement(baseCodeElement);
        while (subcodeElement != null) {
            SOAPElement valueElement = SOAPFaultImpl.getChildValueElement(subcodeElement);
            QName subcode = QNameBuilder.buildQName((Element)valueElement, (String)valueElement.getValue());
            subcodes.add(subcode);
            baseCodeElement = subcodeElement;
            subcodeElement = SOAPFaultImpl.getChildSubcodeElement(baseCodeElement);
        }
        return Collections.unmodifiableList(subcodes).iterator();
    }

    private static SOAPElement getChildSubcodeElement(SOAPElement element) {
        return SOAPFaultImpl.getChildElement(element, Constants.SOAP12_SUBCODE);
    }

    public void appendFaultSubcode(QName subcode) throws SOAPException {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Subcode");
        }
        String nsURI = subcode.getNamespaceURI();
        if (nsURI.length() == 0) {
            throw new SOAPException("subcode must be namespace qualified: " + subcode);
        }
        if (this.faultcode == null) {
            this.findCodeElement();
        }
        SOAPElement baseCodeElement = this.faultcode;
        SOAPElement subcodeElement = SOAPFaultImpl.getChildSubcodeElement(baseCodeElement);
        while (subcodeElement != null) {
            baseCodeElement = subcodeElement;
            subcodeElement = SOAPFaultImpl.getChildSubcodeElement(baseCodeElement);
        }
        subcodeElement = baseCodeElement.addChildElement("Subcode", baseCodeElement.getPrefix(), baseCodeElement.getNamespaceURI());
        SOAPElement valueElement = SOAPFaultImpl.addChildValueElement(subcodeElement);
        SOAPFaultImpl.setCode(valueElement, subcode);
    }

    public void removeAllFaultSubcodes() {
        SOAPElement subcodeElement;
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Subcode");
        }
        if (this.faultcode == null) {
            this.findFaultCodeElement();
        }
        if ((subcodeElement = SOAPFaultImpl.getChildSubcodeElement(this.faultcode)) != null) {
            subcodeElement.detachNode();
        }
    }

    public String getFaultString() {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            if (this.faultstring == null) {
                this.findFaultStringElement();
                if (this.faultstring == null) {
                    return null;
                }
            }
            return this.faultstring.getValue();
        }
        try {
            return (String)this.getFaultReasonTexts().next();
        }
        catch (SOAPException e) {
            return null;
        }
    }

    public Locale getFaultStringLocale() {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            if (this.faultstring == null) {
                this.findFaultStringElement();
                if (this.faultstring == null) {
                    return null;
                }
            }
            return SOAPFaultImpl.getLocale(this.faultstring);
        }
        try {
            return (Locale)this.getFaultReasonLocales().next();
        }
        catch (SOAPException e) {
            return null;
        }
    }

    private void findFaultStringElement() {
        this.faultstring = SOAPFaultImpl.getChildElement(this, Constants.SOAP11_FAULTSTRING);
        log.trace((Object)("findFaultStringElement : " + this.faultstring));
    }

    private static Locale getLocale(SOAPElement element) {
        Attr xmlLang = element.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang");
        return xmlLang != null ? SOAPFaultImpl.toLocale(xmlLang.getValue()) : null;
    }

    private static Locale toLocale(String languageTag) {
        String[] subtags = languageTag.split("-");
        return subtags.length == 1 ? new Locale(subtags[0]) : new Locale(subtags[0], subtags[1]);
    }

    public void setFaultString(String faultString) throws SOAPException {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            this.setFaultStringInternal(faultString);
            this.faultstring.removeAttributeNS("http://www.w3.org/XML/1998/namespace", "lang");
        } else {
            this.addFaultReasonText(faultString, Locale.getDefault());
        }
    }

    public void setFaultString(String faultString, Locale locale) throws SOAPException {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            this.setFaultStringInternal(faultString);
            SOAPFaultImpl.setLocale(this.faultstring, locale);
        } else {
            this.addFaultReasonText(faultString, locale);
        }
    }

    private void setFaultStringInternal(String faultString) throws SOAPException {
        if (this.faultstring == null) {
            this.findFaultStringElement();
            if (this.faultstring == null) {
                this.faultstring = this.addUnqualifiedFaultElement("faultstring");
            }
        }
        this.faultstring.setValue(faultString);
    }

    private static void setLocale(SOAPElement element, Locale locale) {
        element.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:lang", SOAPFaultImpl.toLanguageTag(locale));
    }

    private static String toLanguageTag(Locale locale) {
        String languageTag = locale.getLanguage();
        String country = locale.getCountry();
        if (country.length() != 0) {
            languageTag = languageTag + "-" + country;
        }
        return languageTag;
    }

    public Iterator getFaultReasonTexts() throws SOAPException {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Reason");
        }
        if (this.faultstring == null) {
            this.findReasonElement();
            if (this.faultstring == null) {
                return Collections.EMPTY_LIST.iterator();
            }
        }
        ArrayList<String> texts = new ArrayList<String>();
        Iterator it = this.faultstring.getChildElements(Constants.SOAP12_TEXT);
        while (it.hasNext()) {
            SOAPElement textElement = (SOAPElement)it.next();
            texts.add(textElement.getValue());
        }
        if (texts.isEmpty()) {
            throw new SOAPException("no Text elements found inside Reason");
        }
        return texts.iterator();
    }

    public Iterator getFaultReasonLocales() throws SOAPException {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Reason");
        }
        if (this.faultstring == null) {
            this.findReasonElement();
            if (this.faultstring == null) {
                return Collections.EMPTY_LIST.iterator();
            }
        }
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Iterator it = this.faultstring.getChildElements(Constants.SOAP12_TEXT);
        while (it.hasNext()) {
            SOAPElement textElement = (SOAPElement)it.next();
            Locale locale = SOAPFaultImpl.getLocale(textElement);
            if (locale == null) {
                throw new SOAPException("lang attribute not present on Text element");
            }
            locales.add(locale);
        }
        if (locales.isEmpty()) {
            throw new SOAPException("no Text elements found inside Reason");
        }
        return locales.iterator();
    }

    public String getFaultReasonText(Locale locale) throws SOAPException {
        SOAPElement textElement;
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Reason");
        }
        if (locale == null) {
            return null;
        }
        if (this.faultstring == null) {
            this.findReasonElement();
            if (this.faultstring == null) {
                return null;
            }
        }
        return (textElement = this.getTextElement(locale)) != null ? textElement.getValue() : null;
    }

    private void findReasonElement() {
        this.faultstring = SOAPFaultImpl.getChildElement(this, Constants.SOAP12_REASON);
        log.trace((Object)("findReasonElement: " + this.faultstring));
    }

    private SOAPElement getTextElement(Locale locale) {
        log.trace((Object)("getTextElement(" + locale + ")"));
        SOAPElement textElement = null;
        Iterator it = this.faultstring.getChildElements(Constants.SOAP12_TEXT);
        while (it.hasNext()) {
            SOAPElement element = (SOAPElement)it.next();
            if (!locale.equals(SOAPFaultImpl.getLocale(element))) continue;
            textElement = element;
            break;
        }
        log.trace((Object)("getTextElement : " + textElement));
        return textElement;
    }

    public void addFaultReasonText(String text, Locale locale) throws SOAPException {
        SOAPElement textElement;
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Reason");
        }
        if (locale == null) {
            throw new SOAPException("locale passed is null");
        }
        if (this.faultstring == null) {
            this.findReasonElement();
            if (this.faultstring == null) {
                this.faultstring = this.addQualifiedFaultElement("Reason");
            }
        }
        if ((textElement = this.getTextElement(locale)) == null) {
            textElement = this.faultstring.addChildElement("Text", this.getPrefix(), this.getNamespaceURI());
            SOAPFaultImpl.setLocale(textElement, locale);
        }
        textElement.setValue(text);
    }

    public String getFaultActor() {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            if (this.faultactor == null) {
                this.findFaultActorElement();
                if (this.faultactor == null) {
                    return null;
                }
            }
            return this.faultactor.getValue();
        }
        return this.getFaultRole();
    }

    private void findFaultActorElement() {
        this.faultactor = SOAPFaultImpl.getChildElement(this, Constants.SOAP11_FAULTACTOR);
        log.trace((Object)("findFaultActorElement : " + this.faultactor));
    }

    public void setFaultActor(String faultActor) throws SOAPException {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            if (this.faultactor == null) {
                this.findFaultActorElement();
                if (this.faultactor == null) {
                    this.faultactor = this.addUnqualifiedFaultElement("faultactor");
                }
            }
            this.faultactor.setValue(faultActor);
        } else {
            this.setFaultRole(faultActor);
        }
    }

    public String getFaultRole() {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Role");
        }
        if (this.faultactor == null) {
            this.findRoleElement();
            if (this.faultactor == null) {
                return null;
            }
        }
        return this.faultactor.getValue();
    }

    private void findRoleElement() {
        this.faultactor = SOAPFaultImpl.getChildElement(this, Constants.SOAP12_ROLE);
        log.trace((Object)("findRoleElement : " + this.faultactor));
    }

    public void setFaultRole(String uri) throws SOAPException {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Role");
        }
        if (this.faultactor == null) {
            this.findRoleElement();
            if (this.faultactor == null) {
                this.faultactor = this.addQualifiedFaultElement("Role");
            }
        }
        this.faultactor.setValue(uri);
    }

    public String getFaultNode() {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Node");
        }
        if (this.faultnode == null) {
            this.findNodeElement();
            if (this.faultnode == null) {
                return null;
            }
        }
        return this.faultnode.getValue();
    }

    private void findNodeElement() {
        this.faultnode = SOAPFaultImpl.getChildElement(this, Constants.SOAP12_NODE);
        log.trace((Object)("findNodeElement : " + this.faultnode));
    }

    public void setFaultNode(String uri) throws SOAPException {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            throw new UnsupportedOperationException("SOAP 1.1 Fault does not support the concept of Node");
        }
        if (this.faultnode == null) {
            this.findNodeElement();
            if (this.faultnode == null) {
                this.faultnode = this.addQualifiedFaultElement("Node");
            }
        }
        this.faultnode.setValue(uri);
    }

    public boolean hasDetail() {
        return this.getDetail() != null;
    }

    public Detail getDetail() {
        if (this.detail == null) {
            if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
                this.findSoap11DetailElement();
            } else {
                this.findSoap12DetailElement();
            }
        }
        return this.detail;
    }

    public Detail addDetail() throws SOAPException {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            if (this.detail == null) {
                this.findSoap11DetailElement();
            }
            if (this.detail != null) {
                throw new SOAPException("this fault already contains a detail element");
            }
            this.detail = new DetailImpl();
        } else {
            if (this.detail == null) {
                this.findSoap12DetailElement();
            }
            if (this.detail != null) {
                throw new SOAPException("this fault already contains a detail element");
            }
            this.detail = new DetailImpl(this.getPrefix(), this.getNamespaceURI());
        }
        this.detail = (Detail)this.addChildElement((SOAPElement)this.detail);
        return this.detail;
    }

    private void findSoap11DetailElement() {
        this.detail = (Detail)SOAPFaultImpl.getChildElement(this, Constants.SOAP11_DETAIL);
        log.trace((Object)("findSoap11DetailElement : " + this.detail));
    }

    private void findSoap12DetailElement() {
        this.detail = (Detail)SOAPFaultImpl.getChildElement(this, Constants.SOAP12_DETAIL);
        log.trace((Object)("findSoap12DetailElement : " + this.detail));
    }

    @Override
    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        if (!(child instanceof SOAPFaultElement)) {
            child = this.convertToFaultElement((SOAPElementImpl)child);
        }
        return super.addChildElement(child);
    }

    private SOAPFaultElement convertToFaultElement(SOAPElementImpl element) {
        element.detachNode();
        QName elementName = element.getElementQName();
        SOAPFaultElementImpl faultElement = ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI()) ? Constants.SOAP11_DETAIL.equals(elementName) : Constants.SOAP12_DETAIL.equals(elementName)) ? new DetailImpl(element) : new SOAPFaultElementImpl(element);
        log.trace((Object)("convertToFaultElement : " + faultElement));
        return faultElement;
    }

    QName getDefaultFaultCode() {
        return "http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI()) ? Constants.SOAP11_FAULT_CODE_SERVER : SOAPConstants.SOAP_RECEIVER_FAULT;
    }

    @Override
    public void writeElement(Writer writer) {
        new DOMWriter(writer).print((Node)((Object)this));
    }

    private static SOAPElement getChildElement(SOAPElement element, QName name) {
        Iterator it = element.getChildElements(name);
        return it.hasNext() ? (SOAPElement)it.next() : null;
    }

    private SOAPElement addUnqualifiedFaultElement(String localName) throws SOAPException {
        log.trace((Object)("addUnqualifiedFaultElement(" + localName + ")"));
        return this.addChildElement(new SOAPFaultElementImpl(localName));
    }

    private SOAPElement addQualifiedFaultElement(String localName) throws SOAPException {
        log.trace((Object)("addQualifiedFaultElement(" + localName + ")"));
        return this.addChildElement(new SOAPFaultElementImpl(localName, this.getPrefix(), this.getNamespaceURI()));
    }

    static {
        soap11FaultCodes.add(Constants.SOAP11_FAULT_CODE_CLIENT);
        soap11FaultCodes.add(Constants.SOAP11_FAULT_CODE_SERVER);
        soap11FaultCodes.add(Constants.SOAP11_FAULT_CODE_VERSION_MISMATCH);
        soap11FaultCodes.add(Constants.SOAP11_FAULT_CODE_MUST_UNDERSTAND);
        soap12FaultCodes = new HashSet<QName>();
        soap12FaultCodes.add(SOAPConstants.SOAP_VERSIONMISMATCH_FAULT);
        soap12FaultCodes.add(SOAPConstants.SOAP_MUSTUNDERSTAND_FAULT);
        soap12FaultCodes.add(SOAPConstants.SOAP_DATAENCODINGUNKNOWN_FAULT);
        soap12FaultCodes.add(SOAPConstants.SOAP_SENDER_FAULT);
        soap12FaultCodes.add(SOAPConstants.SOAP_RECEIVER_FAULT);
    }
}

