/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb.deployers.MergedJBossMetaDataDeployer;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.javaee.spec.DataSourceMetaData;
import org.jboss.metadata.javaee.spec.DataSourcesMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.web.deployers.MergedJBossWebMetaDataDeployer;

public class MergedJBossWebMetaDataHackDeployer
extends MergedJBossWebMetaDataDeployer {
    public MergedJBossWebMetaDataHackDeployer() {
        this.addInput(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME);
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        super.deploy(unit);
        JBossWebMetaData mergedJBossWebMetaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        if (mergedJBossWebMetaData == null || !this.hasDataSources(mergedJBossWebMetaData)) {
            return;
        }
        if (!this.isSharedENC(unit)) {
            return;
        }
        JBossMetaData jbossMetaData = (JBossMetaData)unit.getAttachment(MergedJBossMetaDataDeployer.EJB_MERGED_ATTACHMENT_NAME, JBossMetaData.class);
        JBossEnterpriseBeansMetaData enterpriseBeans = jbossMetaData.getEnterpriseBeans();
        if (enterpriseBeans == null || enterpriseBeans.isEmpty()) {
            return;
        }
        for (JBossEnterpriseBeanMetaData enterpriseBean : enterpriseBeans) {
            this.removeCommonDataResourceReference(mergedJBossWebMetaData, (Environment)enterpriseBean);
        }
        unit.getTransientManagedObjects().addAttachment(JBossWebMetaData.class, (Object)mergedJBossWebMetaData);
    }

    private boolean isSharedENC(DeploymentUnit unit) {
        JBossWebMetaData jbossWeb = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        if (jbossWeb == null || !jbossWeb.is30()) {
            return false;
        }
        return unit.isAttachmentPresent(JBossMetaData.class);
    }

    private void removeCommonDataResourceReference(JBossWebMetaData jbossWeb, Environment ejbJndiEnv) {
        Environment jbossWebEnv = jbossWeb.getJndiEnvironmentRefsGroup();
        if (jbossWebEnv == null || ejbJndiEnv == null) {
            return;
        }
        DataSourcesMetaData jbossWebDataSources = jbossWebEnv.getDataSources();
        DataSourcesMetaData ejbCompDataSources = ejbJndiEnv.getDataSources();
        if (jbossWebDataSources != null && ejbCompDataSources != null) {
            for (DataSourceMetaData ejbCompDataSource : ejbCompDataSources) {
                boolean removed;
                if (ejbCompDataSource == null || !(removed = jbossWebDataSources.remove((Object)ejbCompDataSource)) || !this.log.isTraceEnabled()) continue;
                this.log.trace((Object)("Removed data-source reference: " + ejbCompDataSource.getName() + " from jbossweb metadata since the same reference is present in a EJB's jndi environment"));
            }
        }
    }

    private boolean hasDataSources(JBossWebMetaData jbossWebMetaData) {
        Environment jbossWebEnv = jbossWebMetaData.getJndiEnvironmentRefsGroup();
        if (jbossWebEnv == null) {
            return false;
        }
        return jbossWebEnv.getDataSources() != null && !jbossWebEnv.getDataSources().isEmpty();
    }
}

