/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.lock;

import javax.transaction.Transaction;
import org.jboss.ejb.BeanLock;
import org.jboss.ejb.BeanLockExt;
import org.jboss.ejb.Container;
import org.jboss.invocation.Invocation;
import org.jboss.logging.Logger;
import org.jboss.util.deadlock.Resource;

public abstract class BeanLockSupport
implements Resource,
BeanLockExt {
    protected Container container = null;
    protected int refs = 0;
    protected Object id = null;
    static Logger log = Logger.getLogger(BeanLock.class);
    protected Transaction tx = null;
    protected Thread synched = null;
    protected int synchedDepth = 0;
    protected int txTimeout;

    public void setId(Object id) {
        this.id = id;
    }

    public Object getId() {
        return this.id;
    }

    public void setTimeout(int timeout) {
        this.txTimeout = timeout;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public Object getResourceHolder() {
        return this.tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean attemptSync() {
        boolean didSync = false;
        BeanLockSupport beanLockSupport = this;
        synchronized (beanLockSupport) {
            Thread thread = Thread.currentThread();
            if (this.synched == null || this.synched.equals(thread)) {
                this.synched = thread;
                ++this.synchedDepth;
                didSync = true;
            }
        }
        return didSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        boolean intr = false;
        try {
            BeanLockSupport beanLockSupport = this;
            synchronized (beanLockSupport) {
                Thread thread = Thread.currentThread();
                while (this.synched != null && !this.synched.equals(thread)) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        intr = true;
                    }
                }
                this.synched = thread;
                ++this.synchedDepth;
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSync() {
        BeanLockSupport beanLockSupport = this;
        synchronized (beanLockSupport) {
            if (--this.synchedDepth == 0) {
                this.synched = null;
            }
            this.notify();
        }
    }

    public abstract void schedule(Invocation var1) throws Exception;

    public void setTransaction(Transaction tx) {
        this.tx = tx;
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    public abstract void endTransaction(Transaction var1);

    public abstract void wontSynchronize(Transaction var1);

    public abstract void endInvocation(Invocation var1);

    public void addRef() {
        ++this.refs;
    }

    public void removeRef() {
        --this.refs;
    }

    public int getRefs() {
        return this.refs;
    }
}

