/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.ModulesMetaData;
import org.jboss.metadata.javaee.jboss.NamedModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleNameDeployer
extends AbstractDeployer {
    private final Set<Class<? extends NamedModule>> inputTypes;

    public ModuleNameDeployer(Set<Class<? extends NamedModule>> inputTypes) {
        if (inputTypes == null) {
            throw new IllegalArgumentException("inputTypes cannot be null");
        }
        this.setStage(DeploymentStages.PRE_REAL);
        this.addInput(JBossAppMetaData.class);
        this.addOutput(JBossAppMetaData.class);
        this.addOutput(NamedModule.class);
        for (Class<? extends NamedModule> type : inputTypes) {
            this.addInput(type);
            this.addOutput(type);
        }
        this.inputTypes = inputTypes;
    }

    public void deploy(DeploymentUnit unit) throws DeploymentException {
        NamedModule nm;
        ArrayList<NamedModule> metadatas = null;
        for (Class<? extends NamedModule> type : this.inputTypes) {
            nm = (NamedModule)unit.getAttachment(type);
            if (nm == null) continue;
            if (metadatas == null) {
                metadatas = new ArrayList<NamedModule>();
            }
            metadatas.add(nm);
        }
        if (metadatas == null) {
            return;
        }
        String moduleName = null;
        Iterator i$ = metadatas.iterator();
        while (i$.hasNext() && (moduleName = (nm = (NamedModule)i$.next()).getModuleName()) == null) {
        }
        JBossAppMetaData appMetaData = null;
        DeploymentUnit parent = unit.getParent();
        if (parent != null) {
            appMetaData = (JBossAppMetaData)parent.getAttachment(JBossAppMetaData.class);
        }
        if (appMetaData != null) {
            moduleName = this.establishUniqueModuleName(unit, moduleName, appMetaData);
        } else if (moduleName == null) {
            moduleName = ModuleNameDeployer.trimExtension(unit.getSimpleName());
        }
        for (NamedModule nm2 : metadatas) {
            nm2.setModuleName(moduleName);
        }
        unit.addAttachment(NamedModule.class, metadatas.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String establishUniqueModuleName(DeploymentUnit unit, String configuredName, JBossAppMetaData appMetaData) throws DeploymentException {
        String name = configuredName == null ? ModuleNameDeployer.trimExtension(unit.getRelativePath()) : configuredName;
        String modulePath = unit.getRelativePath();
        ModulesMetaData modules = appMetaData.getModules();
        if (modules == null) {
            throw new DeploymentException(unit + " has attached " + JBossAppMetaData.class.getSimpleName() + " but it has no associated " + ModulesMetaData.class.getSimpleName());
        }
        ModuleMetaData ourModule = null;
        String uniqueName = null;
        ModulesMetaData modulesMetaData = modules;
        synchronized (modulesMetaData) {
            ourModule = (ModuleMetaData)modules.get(modulePath);
            if (ourModule == null) {
                String parentUnitName = unit.getParent().getName();
                throw new DeploymentException("No module with relative path " + modulePath + " found  in set of modules for " + parentUnitName + " " + modules.keySet());
            }
            uniqueName = name;
            if (!(ModuleNameDeployer.isNameUnique(uniqueName, ourModule, modules) || !(uniqueName = ModuleNameDeployer.trimExtension(unit.getRelativePath())).equals(name) && ModuleNameDeployer.isNameUnique(uniqueName, ourModule, modules) || ModuleNameDeployer.isNameUnique(uniqueName = unit.getRelativePath(), ourModule, modules))) {
                int i = 0;
                while (!ModuleNameDeployer.isNameUnique(uniqueName = name + "-" + ++i, ourModule, modules)) {
                }
            }
            ourModule.setUniqueName(uniqueName);
        }
        if (configuredName != null && !configuredName.equals(uniqueName)) {
            this.log.warn((Object)("Module name " + configuredName + " specified in deployment descriptor for " + unit + " was not unique within the application; using module name " + uniqueName + " instead"));
        } else if (!name.equals(uniqueName)) {
            this.log.warn((Object)("Module name " + name + " derived from the modules relative path in " + unit + " was not unique within the application; using module name " + uniqueName + " instead"));
        }
        return uniqueName;
    }

    private static boolean isNameUnique(String uniqueName, ModuleMetaData ourModule, ModulesMetaData modules) {
        for (ModuleMetaData module : modules) {
            if (ourModule.equals((Object)module) || !uniqueName.equals(module.getUniqueName())) continue;
            return false;
        }
        return true;
    }

    private static String trimExtension(String path) {
        int lastDot = path.lastIndexOf(46);
        return lastDot > -1 ? path.substring(0, lastDot) : path;
    }
}

