/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.io.Serializable;
import java.util.Comparator;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.access.SoftLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadWriteCache
implements CacheConcurrencyStrategy {
    private static final Logger log = LoggerFactory.getLogger(ReadWriteCache.class);
    private Cache cache;
    private int nextLockId;

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Cache getCache() {
        return this.cache;
    }

    public String getRegionName() {
        return this.cache.getRegionName();
    }

    private int nextLockId() {
        if (this.nextLockId == Integer.MAX_VALUE) {
            this.nextLockId = Integer.MIN_VALUE;
        }
        return this.nextLockId++;
    }

    public synchronized Object get(Object key, long txTimestamp) throws CacheException {
        Lockable lockable;
        boolean gettable;
        if (log.isTraceEnabled()) {
            log.trace("Cache lookup: " + key);
        }
        boolean bl = gettable = (lockable = (Lockable)this.cache.get(key)) != null && lockable.isGettable(txTimestamp);
        if (gettable) {
            if (log.isTraceEnabled()) {
                log.trace("Cache hit: " + key);
            }
            return ((Item)lockable).getValue();
        }
        if (log.isTraceEnabled()) {
            if (lockable == null) {
                log.trace("Cache miss: " + key);
            } else {
                log.trace("Cached item was locked: " + key);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SoftLock lock(Object key, Object version) throws CacheException {
        Lock lock;
        if (log.isTraceEnabled()) {
            log.trace("Invalidating: " + key);
        }
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            long timeout = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
            Lock lock2 = lockable == null ? new Lock(timeout, this.nextLockId(), version) : lockable.lock(timeout, this.nextLockId());
            this.cache.update(key, lock2);
            lock = lock2;
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.cache.unlock(key);
            throw throwable;
        }
        this.cache.unlock(key);
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean put(Object key, Object value, long txTimestamp, Object version, Comparator versionComparator, boolean minimalPut) throws CacheException {
        Lockable lockable;
        block8: {
            boolean bl;
            if (log.isTraceEnabled()) {
                log.trace("Caching: " + key);
            }
            try {
                boolean puttable;
                this.cache.lock(key);
                lockable = (Lockable)this.cache.get(key);
                boolean bl2 = puttable = lockable == null || lockable.isPuttable(txTimestamp, version, versionComparator);
                if (!puttable) break block8;
                this.cache.put(key, new Item(value, version, this.cache.nextTimestamp()));
                if (log.isTraceEnabled()) {
                    log.trace("Cached: " + key);
                }
                bl = true;
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                this.cache.unlock(key);
                throw throwable;
            }
            this.cache.unlock(key);
            return bl;
        }
        if (log.isTraceEnabled()) {
            if (lockable.isLock()) {
                log.trace("Item was locked: " + key);
            } else {
                log.trace("Item was already cached: " + key);
            }
        }
        boolean bl = false;
        Object var12_12 = null;
        this.cache.unlock(key);
        return bl;
    }

    private void decrementLock(Object key, Lock lock) throws CacheException {
        lock.unlock(this.cache.nextTimestamp());
        this.cache.update(key, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(Object key, SoftLock clientLock) throws CacheException {
        if (log.isTraceEnabled()) {
            log.trace("Releasing: " + key);
        }
        try {
            this.cache.lock(key);
            Lockable lockable = (Lockable)this.cache.get(key);
            if (this.isUnlockable(clientLock, lockable)) {
                this.decrementLock(key, (Lock)lockable);
            } else {
                this.handleLockExpiry(key);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.cache.unlock(key);
            throw throwable;
        }
        this.cache.unlock(key);
    }

    void handleLockExpiry(Object key) throws CacheException {
        log.warn("An item was expired by the cache while it was locked (increase your cache timeout): " + key);
        long ts = this.cache.nextTimestamp() + (long)this.cache.getTimeout();
        Lock lock = new Lock(ts, this.nextLockId(), null);
        lock.unlock(ts);
        this.cache.update(key, lock);
    }

    public void clear() throws CacheException {
        this.cache.clear();
    }

    public void remove(Object key) throws CacheException {
        this.cache.remove(key);
    }

    public void destroy() {
        try {
            this.cache.destroy();
        }
        catch (Exception e) {
            log.warn("could not destroy cache", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean afterUpdate(Object key, Object value, Object version, SoftLock clientLock) throws CacheException {
        block6: {
            block7: {
                boolean bl;
                if (log.isTraceEnabled()) {
                    log.trace("Updating: " + key);
                }
                try {
                    this.cache.lock(key);
                    Lockable lockable = (Lockable)this.cache.get(key);
                    if (!this.isUnlockable(clientLock, lockable)) break block6;
                    Lock lock = (Lock)lockable;
                    if (!lock.wasLockedConcurrently()) break block7;
                    this.decrementLock(key, lock);
                    bl = false;
                    Object var9_10 = null;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    this.cache.unlock(key);
                    throw throwable;
                }
                this.cache.unlock(key);
                return bl;
            }
            this.cache.update(key, new Item(value, version, this.cache.nextTimestamp()));
            if (log.isTraceEnabled()) {
                log.trace("Updated: " + key);
            }
            boolean bl = true;
            Object var9_11 = null;
            this.cache.unlock(key);
            return bl;
        }
        this.handleLockExpiry(key);
        boolean bl = false;
        Object var9_12 = null;
        this.cache.unlock(key);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        block5: {
            boolean bl;
            if (log.isTraceEnabled()) {
                log.trace("Inserting: " + key);
            }
            try {
                this.cache.lock(key);
                Lockable lockable = (Lockable)this.cache.get(key);
                if (lockable != null) break block5;
                this.cache.update(key, new Item(value, version, this.cache.nextTimestamp()));
                if (log.isTraceEnabled()) {
                    log.trace("Inserted: " + key);
                }
                bl = true;
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.cache.unlock(key);
                throw throwable;
            }
            this.cache.unlock(key);
            return bl;
        }
        boolean bl = false;
        Object var7_8 = null;
        this.cache.unlock(key);
        return bl;
    }

    public void evict(Object key) throws CacheException {
    }

    public boolean insert(Object key, Object value, Object currentVersion) {
        return false;
    }

    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) {
        return false;
    }

    private boolean isUnlockable(SoftLock clientLock, Lockable myLock) throws CacheException {
        return myLock != null && myLock.isLock() && clientLock != null && ((Lock)clientLock).getId() == ((Lock)myLock).getId();
    }

    public String toString() {
        return this.cache + "(read-write)";
    }

    public static final class Lock
    implements Serializable,
    Lockable,
    SoftLock {
        private long unlockTimestamp = -1L;
        private int multiplicity = 1;
        private boolean concurrentLock = false;
        private long timeout;
        private final int id;
        private final Object version;

        public Lock(long timeout, int id, Object version) {
            this.timeout = timeout;
            this.id = id;
            this.version = version;
        }

        public long getUnlockTimestamp() {
            return this.unlockTimestamp;
        }

        public Lock lock(long timeout, int id) {
            this.concurrentLock = true;
            ++this.multiplicity;
            this.timeout = timeout;
            return this;
        }

        public void unlock(long currentTimestamp) {
            if (--this.multiplicity == 0) {
                this.unlockTimestamp = currentTimestamp;
            }
        }

        public boolean isPuttable(long txTimestamp, Object newVersion, Comparator comparator) {
            if (this.timeout < txTimestamp) {
                return true;
            }
            if (this.multiplicity > 0) {
                return false;
            }
            return this.version == null ? this.unlockTimestamp < txTimestamp : comparator.compare(this.version, newVersion) < 0;
        }

        public boolean wasLockedConcurrently() {
            return this.concurrentLock;
        }

        public boolean isLock() {
            return true;
        }

        public boolean isGettable(long txTimestamp) {
            return false;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "Lock{id=" + this.id + ",version=" + this.version + ",multiplicity=" + this.multiplicity + ",unlockTimestamp=" + this.unlockTimestamp;
        }
    }

    public static final class Item
    implements Serializable,
    Lockable {
        private final long freshTimestamp;
        private final Object value;
        private final Object version;

        public Item(Object value, Object version, long currentTimestamp) {
            this.value = value;
            this.version = version;
            this.freshTimestamp = currentTimestamp;
        }

        public long getFreshTimestamp() {
            return this.freshTimestamp;
        }

        public Object getValue() {
            return this.value;
        }

        public Lock lock(long timeout, int id) {
            return new Lock(timeout, id, this.version);
        }

        public boolean isLock() {
            return false;
        }

        public boolean isGettable(long txTimestamp) {
            return this.freshTimestamp < txTimestamp;
        }

        public boolean isPuttable(long txTimestamp, Object newVersion, Comparator comparator) {
            return this.version != null && comparator.compare(this.version, newVersion) < 0;
        }

        public String toString() {
            return "Item{version=" + this.version + ",freshTimestamp=" + this.freshTimestamp;
        }
    }

    public static interface Lockable {
        public Lock lock(long var1, int var3);

        public boolean isLock();

        public boolean isGettable(long var1);

        public boolean isPuttable(long var1, Object var3, Comparator var4);
    }
}

