/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.vfs.impl.vfs3.VirtualFileFilterAdapter;
import org.jboss.ejb3.vfs.impl.vfs3.VirtualFileWrapper;
import org.jboss.ejb3.vfs.spi.VirtualFile;
import org.jboss.ejb3.vfs.spi.VirtualFileFilter;
import org.jboss.vfs.VirtualFileVisitor;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.FilterVirtualFileVisitor;
import org.jboss.vfs.util.SuffixesExcludeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBoss5DeploymentUnit
implements DeploymentUnit {
    private VFSDeploymentUnit unit;
    private ClassLoader classLoader;
    private InterceptorInfoRepository interceptorInfoRepository;
    private Map defaultPersistenceProperties;

    public JBoss5DeploymentUnit(VFSDeploymentUnit unit) {
        this(unit, unit.getClassLoader());
    }

    public JBoss5DeploymentUnit(VFSDeploymentUnit unit, ClassLoader classLoader) {
        assert (unit != null) : "unit is null";
        assert (classLoader != null) : "classLoader is null";
        this.unit = unit;
        this.classLoader = classLoader;
        this.interceptorInfoRepository = new InterceptorInfoRepository(classLoader);
    }

    public Object addAttachment(String name, Object attachment) {
        return this.unit.addAttachment(name, attachment);
    }

    public Object getAttachment(String name) {
        return this.unit.getAttachment(name);
    }

    public Object removeAttachment(String name) {
        return this.unit.removeAttachment(name);
    }

    public VirtualFile getRootFile() {
        return new VirtualFileWrapper(this.unit.getFile(""));
    }

    public String getRelativePath() {
        return this.unit.getRelativePath();
    }

    public URL getRelativeURL(String jar) {
        try {
            return new URL(jar);
        }
        catch (MalformedURLException e) {
            try {
                if (this.getUrl() == null) {
                    throw new RuntimeException("relative <jar-file> not allowed when standalone deployment unit is used");
                }
                return new URL(this.getUrl(), jar);
            }
            catch (Exception e1) {
                throw new RuntimeException("could not find relative path: " + jar, e1);
            }
        }
    }

    URL extractDescriptorUrl(String resource) {
        try {
            org.jboss.vfs.VirtualFile vf = this.unit.getMetaDataFile(resource);
            if (vf == null) {
                return null;
            }
            return vf.toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public URL getPersistenceXml() {
        return this.extractDescriptorUrl("persistence.xml");
    }

    public URL getEjbJarXml() {
        return this.extractDescriptorUrl("ejb-jar.xml");
    }

    public URL getJbossXml() {
        return this.extractDescriptorUrl("jboss.xml");
    }

    public VirtualFile getMetaDataFile(String name) {
        return new VirtualFileWrapper(this.unit.getMetaDataFile(name));
    }

    public List<Class> getClasses() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getResourceLoader() {
        return this.getClassLoader();
    }

    public String getShortName() {
        return this.unit.getFile("").getName();
    }

    public URL getUrl() {
        try {
            return this.unit.getFile("").toURL();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getDefaultEntityManagerName() {
        String url = this.getUrl().toString();
        String name = url.substring(url.lastIndexOf(47) + 1, url.lastIndexOf(46));
        return name;
    }

    public Map getDefaultPersistenceProperties() {
        return this.defaultPersistenceProperties;
    }

    public void setDefaultPersistenceProperties(Map defaultPersistenceProperties) {
        this.defaultPersistenceProperties = defaultPersistenceProperties;
    }

    public Hashtable getJndiProperties() {
        return null;
    }

    public InterceptorInfoRepository getInterceptorInfoRepository() {
        return this.interceptorInfoRepository;
    }

    public List<VirtualFile> getResources(VirtualFileFilter filter) {
        List classPath = this.unit.getClassPath();
        if (classPath == null || classPath.isEmpty()) {
            return Collections.emptyList();
        }
        VisitorAttributes va = new VisitorAttributes();
        va.setLeavesOnly(true);
        SuffixesExcludeFilter noJars = new SuffixesExcludeFilter(Arrays.asList(".zip", ".ear", ".jar", ".rar", ".war", ".sar", ".har", ".aop"));
        va.setRecurseFilter((org.jboss.vfs.VirtualFileFilter)noJars);
        FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor((org.jboss.vfs.VirtualFileFilter)new VirtualFileFilterAdapter(filter), va);
        for (org.jboss.vfs.VirtualFile root : classPath) {
            try {
                if (JBoss5DeploymentUnit.isChildOf(classPath, root) || root.isLeaf()) continue;
                root.visit((VirtualFileVisitor)visitor);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        List matches = visitor.getMatched();
        ArrayList<VirtualFile> wrappedMatches = new ArrayList<VirtualFile>(matches.size());
        for (org.jboss.vfs.VirtualFile match : matches) {
            wrappedMatches.add((VirtualFile)new VirtualFileWrapper(match));
        }
        return wrappedMatches;
    }

    private static boolean isChildOf(org.jboss.vfs.VirtualFile other, org.jboss.vfs.VirtualFile file) throws IOException {
        for (org.jboss.vfs.VirtualFile child : other.getChildren()) {
            if (child.equals(file)) {
                return true;
            }
            if (!JBoss5DeploymentUnit.isChildOf(child, file)) continue;
            return true;
        }
        return false;
    }

    private static boolean isChildOf(List<org.jboss.vfs.VirtualFile> others, org.jboss.vfs.VirtualFile file) throws IOException {
        for (org.jboss.vfs.VirtualFile other : others) {
            if (file == other || !JBoss5DeploymentUnit.isChildOf(other, file)) continue;
            return true;
        }
        return false;
    }
}

