/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.legacy;

import java.io.IOException;
import java.io.InputStream;
import java.io.SyncFailedException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.profileservice.profile.MutableScanningProfile;
import org.jboss.profileservice.repository.artifact.CopyStreamArtifactTransformer;
import org.jboss.profileservice.repository.artifact.ExplodedArtifactTransformer;
import org.jboss.profileservice.repository.artifact.file.FileArtifactId;
import org.jboss.profileservice.spi.DeploymentOption;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.ModificationInfo;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentFlag;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactTransformer;
import org.jboss.profileservice.spi.repository.artifact.MutableArtifactRepository;
import org.jboss.vfs.VirtualFile;

public class LegacyDeploymentRepository
extends MutableScanningProfile
implements DeploymentRepository {
    public LegacyDeploymentRepository(ProfileKey key, VirtualDeploymentRepository deploymentRepository) {
        super(key, deploymentRepository);
    }

    public void load() throws Exception {
        super.start();
    }

    public void unload() {
        super.stop();
    }

    public void addDeployment(String name, ProfileDeployment deployment) throws Exception {
        super.addDeployment(deployment);
    }

    public String addDeploymentContent(String name, InputStream contentIS) throws IOException {
        return this.addDeploymentContent(name, contentIS, new DeploymentOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addDeploymentContent(String name, InputStream contentIS, DeploymentOption ... options) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("null deployment name");
        }
        if (contentIS == null) {
            throw new IllegalArgumentException("null content input stream");
        }
        if (options == null) {
            options = new DeploymentOption[]{};
        }
        this.lockWrite();
        try {
            MutableArtifactRepository mutable = this.getMutableArtifactRepository();
            FileArtifactId artifactId = new FileArtifactId(name);
            List<DeploymentOption> deploymentOptions = Arrays.asList(options);
            boolean failIfAlreadyExsists = deploymentOptions.contains(DeploymentOption.FailIfExists);
            if (mutable.containsArtifact((ArtifactId)artifactId) && failIfAlreadyExsists) {
                throw new SyncFailedException("Deployment content already exists: " + name);
            }
            ArtifactTransformer transformer = null;
            transformer = deploymentOptions.contains(DeploymentOption.Explode) ? ExplodedArtifactTransformer.getInstance() : CopyStreamArtifactTransformer.getInstance();
            mutable.addArtifact((ArtifactId)artifactId, contentIS, transformer);
            String repositoryName = name;
            try {
                VirtualFile original = mutable.getOriginalFile((ArtifactId)artifactId);
                repositoryName = original.asFileURI().toString();
            }
            catch (URISyntaxException ignore) {
                // empty catch block
            }
            String string = repositoryName;
            return string;
        }
        finally {
            this.unlockWrite();
        }
    }

    @Override
    public Collection<ModificationInfo> getModifiedDeployments() throws Exception {
        return Collections.emptyList();
    }

    public String[] getRepositoryNames(String ... names) throws Exception {
        HashSet<String> repositoryNames = new HashSet<String>();
        for (String name : names) {
            ProfileDeployment deployment = this.resolveDeployment(name);
            if (deployment == null) continue;
            repositoryNames.add(deployment.getName());
        }
        return repositoryNames.toArray(new String[repositoryNames.size()]);
    }

    public URI[] getRepositoryURIs() {
        return new URI[]{super.getArtifactRepository().getRepositoryURI()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProfileDeployment removeDeployment(String name) throws Exception {
        this.lockWrite();
        try {
            ProfileDeployment deployment = this.resolveDeployment(name);
            this.getMutableArtifactRepository().removeArtifact((ArtifactId)this.getArtifactMetaData(deployment));
            super.internalRemoveDeployment(deployment.getName());
            ProfileDeployment profileDeployment = deployment;
            return profileDeployment;
        }
        finally {
            this.unlockWrite();
        }
    }

    public boolean hasDeploymentContentFlags(String name, int flag) {
        return false;
    }

    public int lockDeploymentContent(String name) {
        ProfileDeployment deployment = this.resolveDeployment(name);
        deployment.getDeploymentInfo().setFlag(ProfileDeploymentFlag.LOCKED);
        return 0;
    }

    public int unlockDeploymentContent(String name) {
        ProfileDeployment deployment = this.resolveDeployment(name);
        deployment.getDeploymentInfo().clearFlag(ProfileDeploymentFlag.LOCKED);
        return 0;
    }

    public void remove() throws Exception {
        throw new UnsupportedOperationException("getDeploymentContent");
    }

    public int clearDeploymentContentFlags(String name, int flags) {
        throw new UnsupportedOperationException("clearDeploymentContentFlags");
    }

    public VirtualFile getDeploymentContent(String name) throws IOException, URISyntaxException {
        throw new UnsupportedOperationException("getDeploymentContent");
    }

    public int getDeploymentContentFlags(String name) {
        throw new UnsupportedOperationException("getDeploymentContentFlags");
    }

    public int setDeploymentContentFlags(String name, int flags) {
        throw new UnsupportedOperationException("setDeploymentContentFlags");
    }

    protected <T extends ArtifactId> MutableArtifactRepository<T> getMutableArtifactRepository() {
        if (!(this.getArtifactRepository() instanceof MutableArtifactRepository)) {
            throw new IllegalStateException("failed to add deployment content to immutable repository");
        }
        return (MutableArtifactRepository)MutableArtifactRepository.class.cast(this.getArtifactRepository());
    }
}

