/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.jndi.deployers;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.jndi.binder.EJBBinder;
import org.jboss.ejb3.jndi.binder.metadata.SessionBeanType;
import org.jboss.ejb3.jndi.binder.spi.ProxyFactory;
import org.jboss.ejb3.jndi.deployers.AbstractJavaEEComponentDeployer;
import org.jboss.ejb3.jndi.deployers.metadata.SessionBeanTypeWrapper;
import org.jboss.ejb3.jndi.deployers.proxy.LegacyProxyFactory;
import org.jboss.ejb3.jndi.deployers.resolver.DependencyBuilder;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;
import org.jboss.reloaded.naming.spi.JavaEEComponent;

public class EJBBinderDeployer
extends AbstractJavaEEComponentDeployer {
    private List<DependencyBuilder> builders = new CopyOnWriteArrayList<DependencyBuilder>();
    private ProxyFactory legacy = new LegacyProxyFactory();

    public EJBBinderDeployer(JavaEEComponentInformer informer) {
        super(informer);
        this.setInput(JBossEnterpriseBeanMetaData.class);
        this.setOutput(BeanMetaData.class);
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        JBossEnterpriseBeanMetaData beanMetaData = (JBossEnterpriseBeanMetaData)unit.getAttachment(JBossEnterpriseBeanMetaData.class);
        if (beanMetaData == null) {
            return;
        }
        if (!beanMetaData.isSession() && !beanMetaData.isService()) {
            return;
        }
        JBossSessionBeanMetaData sessionBeanMetaData = (JBossSessionBeanMetaData)beanMetaData;
        String appName = this.getApplicationName(unit);
        String moduleName = this.getModuleName(unit);
        String componentName = this.getComponentName(unit);
        String javaCompName = "jboss.naming:";
        if (appName != null) {
            javaCompName = javaCompName + "application=" + appName + ",";
        }
        javaCompName = javaCompName + "module=" + moduleName + ",component=" + componentName;
        String sessionBeanTypeName = "jboss.ejb3:";
        if (appName != null) {
            sessionBeanTypeName = sessionBeanTypeName + "application=" + appName + ",";
        }
        sessionBeanTypeName = sessionBeanTypeName + "module=" + moduleName + ",component=" + componentName + ",service=" + SessionBeanTypeWrapper.class.getSimpleName();
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)sessionBeanTypeName, (String)SessionBeanTypeWrapper.class.getName());
        builder.addConstructorParameter(JBossSessionBeanMetaData.class.getName(), (Object)sessionBeanMetaData);
        builder.addConstructorParameter(ClassLoader.class.getName(), (Object)unit.getClassLoader());
        builder.addConstructorParameter(JavaEEComponent.class.getName(), builder.createInject((Object)javaCompName));
        unit.getParent().addAttachment(sessionBeanTypeName, (Object)builder.getBeanMetaData());
        String beanInstanceName = "jboss.ejb3:";
        if (appName != null) {
            beanInstanceName = beanInstanceName + "application=" + appName + ",";
        }
        beanInstanceName = beanInstanceName + "module=" + moduleName + ",component=" + componentName + ",service=" + EJBBinder.class.getSimpleName();
        BeanMetaDataBuilder builder2 = BeanMetaDataBuilderFactory.createBuilder((String)beanInstanceName, (String)EJBBinder.class.getName());
        builder2.addConstructorParameter(SessionBeanType.class.getName(), builder2.createInject((Object)sessionBeanTypeName));
        builder2.addPropertyMetaData("globalContext", builder2.createInject((Object)"NameSpaces", "globalContext"));
        builder2.addPropertyMetaData("proxyFactory", (Object)this.legacy);
        builder2.setStart("bind");
        builder2.setStop("unbind");
        for (DependencyBuilder db : this.builders) {
            db.buildDependency(unit, builder2);
        }
        unit.getParent().addAttachment(beanInstanceName, (Object)builder2.getBeanMetaData());
    }

    public void addDependencyBuilder(DependencyBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Null builder");
        }
        this.builders.add(builder);
    }

    public void removeDependencyBuilder(DependencyBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("Null builder");
        }
        this.builders.remove(builder);
    }
}

