/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructionInvocation;
import org.jboss.ejb3.interceptors.InterceptorFactory;
import org.jboss.ejb3.interceptors.InterceptorFactoryRef;
import org.jboss.ejb3.interceptors.aop.LifecycleCallbacks;
import org.jboss.ejb3.interceptors.container.AbstractContainer;
import org.jboss.ejb3.interceptors.container.BeanContext;
import org.jboss.ejb3.interceptors.container.BeanContextFactory;
import org.jboss.ejb3.interceptors.container.DestructionInvocation;
import org.jboss.ejb3.interceptors.container.DummyBeanContext;
import org.jboss.ejb3.interceptors.container.ManagedObjectAdvisor;
import org.jboss.logging.Logger;

public class SimpleBeanContextFactory<T, C extends AbstractContainer<T, C>>
implements BeanContextFactory<T, C> {
    private static final Logger log = Logger.getLogger(SimpleBeanContextFactory.class);
    private C container;

    @Override
    public BeanContext<T> createBean() throws Exception {
        try {
            ManagedObjectAdvisor advisor = ((AbstractContainer)this.container).getAdvisor();
            InterceptorFactoryRef interceptorFactoryRef = (InterceptorFactoryRef)advisor.resolveAnnotation(InterceptorFactoryRef.class);
            if (interceptorFactoryRef == null) {
                throw new IllegalStateException("No InterceptorFactory specified on " + advisor.getName());
            }
            log.debug((Object)("interceptor factory class = " + interceptorFactoryRef.value()));
            InterceptorFactory interceptorFactory = interceptorFactoryRef.value().newInstance();
            ArrayList<Object> ejb3Interceptors = new ArrayList<Object>();
            for (Class<?> interceptorClass : ((AbstractContainer)this.container).getInterceptorRegistry().getInterceptorClasses()) {
                Object interceptor = interceptorFactory.create((Advisor)advisor, interceptorClass);
                ejb3Interceptors.add(interceptor);
            }
            Constructor constructor = advisor.getClazz().getConstructor(new Class[0]);
            int idx = advisor.getConstructorIndex(constructor);
            Object[] initargs = null;
            Object targetObject = ((AbstractContainer)this.container).getBeanClass().cast(advisor.invokeNew(initargs, idx));
            DummyBeanContext component = new DummyBeanContext(targetObject, ejb3Interceptors);
            Interceptor[] interceptors = this.createLifecycleInterceptors(component, PostConstruct.class);
            ConstructionInvocation invocation = new ConstructionInvocation(interceptors, constructor, initargs);
            invocation.setAdvisor(advisor);
            invocation.setTargetObject(targetObject);
            invocation.invokeNext();
            return component;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public void destroyBean(BeanContext<T> component) {
        try {
            ManagedObjectAdvisor advisor = ((AbstractContainer)this.container).getAdvisor();
            Interceptor[] interceptors = this.createLifecycleInterceptors(component, PreDestroy.class);
            DestructionInvocation invocation = new DestructionInvocation(interceptors);
            invocation.setAdvisor((Advisor)advisor);
            invocation.setTargetObject(component.getInstance());
            invocation.invokeNext();
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private Interceptor[] createLifecycleInterceptors(BeanContext<T> component, Class<? extends Annotation> lifecycleAnnotationType) throws Exception {
        List<Class<?>> lifecycleInterceptorClasses = ((AbstractContainer)this.container).getInterceptorRegistry().getLifecycleInterceptorClasses();
        ManagedObjectAdvisor advisor = ((AbstractContainer)this.container).getAdvisor();
        return LifecycleCallbacks.createLifecycleCallbackInterceptors(advisor, lifecycleInterceptorClasses, component, lifecycleAnnotationType);
    }

    @Override
    public void setContainer(C container) {
        this.container = container;
    }
}

