/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist.bytecode;

import java.lang.reflect.Method;
import javassist.Modifier;
import javassist.util.proxy.RuntimeSupport;
import org.jboss.reflect.plugins.javassist.JavassistMethod;
import org.jboss.reflect.plugins.javassist.JavassistMethodInfo;
import org.jboss.reflect.plugins.javassist.bytecode.ClassFileWriterContext;
import org.jboss.reflect.plugins.javassist.bytecode.JavassistBehaviorFactory;
import org.jboss.reflect.plugins.javassist.bytecode.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JavassistMethodFactory
extends JavassistBehaviorFactory {
    private static final String[] interfaceNames;
    private static final Method[] methods;
    private static final String[] methodDescriptors;
    private final String className = JavassistMethod.class.getName() + counter.incrementAndGet();

    JavassistMethodFactory(Class<?> superClass, JavassistMethodInfo method, boolean debug) {
        super(superClass, method, debug);
    }

    @Override
    String getGeneratedClassName() {
        return this.className;
    }

    @Override
    String[] getInterfaceNames() {
        return interfaceNames;
    }

    private String getReturnType() {
        String desc = this.getBehavior().getDescriptor();
        int i = desc.indexOf(41);
        return desc.substring(i + 1);
    }

    @Override
    boolean implementMethod(int index, ClassFileWriterContext<?> cfwc) {
        if (index >= methods.length) {
            return false;
        }
        Method method = methods[index];
        cfwc.beginMethod(1, method.getName(), methodDescriptors[index], THROWABLE_EXCEPTIONS);
        boolean isStatic = Modifier.isStatic((int)this.behavior.getModifiers());
        String targetClassName = ClassFileWriterContext.jvmClassName(this.getBehavior().getDeclaringClass().getName());
        if (!isStatic) {
            cfwc.addAload(1);
            cfwc.addCheckcast(targetClassName);
        }
        this.addParameters(cfwc, this.getBehavior().getSignatureKey(), 2);
        if (isStatic) {
            cfwc.addInvokeStatic(targetClassName, this.getBehavior().getName(), this.getBehavior().getDescriptor());
        } else if (this.getBehavior().getDeclaringClass().isInterface()) {
            cfwc.addInvokeInterface(targetClassName, this.getBehavior().getName(), this.getBehavior().getDescriptor(), this.countParameterStackSize(0, this.getBehavior().getSignatureKey()));
        } else {
            cfwc.addInvokeVirtual(targetClassName, this.getBehavior().getName(), this.getBehavior().getDescriptor());
        }
        if (this.getReturnType().equals("V")) {
            cfwc.addAConstNull();
            cfwc.addAReturn();
        } else {
            this.boxReturnValue(cfwc, this.getReturnType());
            cfwc.addAReturn();
        }
        cfwc.endMethod(3);
        return true;
    }

    static {
        methodDescriptors = new String[1];
        interfaceNames = new String[]{JavassistMethod.class.getName()};
        methods = new Method[1];
        try {
            JavassistMethodFactory.methods[0] = SecurityActions.getDeclaredMethod(JavassistMethod.class, "invoke", Object.class, Object[].class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        JavassistMethodFactory.methodDescriptors[0] = RuntimeSupport.makeDescriptor((Method)methods[0]);
    }
}

