/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.accessor.metrics;

import org.jboss.reflect.plugins.bytecode.accessor.FieldAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.metrics.Metrics;

class MetricsFieldAccessor
extends Metrics
implements FieldAccessor {
    private final FieldAccessor delegate;

    public MetricsFieldAccessor(FieldAccessor delegate, String sig) {
        super(sig + MetricsFieldAccessor.getDelegateType(delegate));
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object target) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            Object object = this.delegate.get(target);
            return object;
        }
        finally {
            this.recordTime(System.currentTimeMillis() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object target, Object value) throws Throwable {
        long start = System.currentTimeMillis();
        try {
            this.delegate.set(target, value);
        }
        finally {
            this.recordTime(System.currentTimeMillis() - start);
        }
    }
}

