/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Inflector {
    private List<String> uncountable = new ArrayList<String>();
    private List<Rule> singular = new ArrayList<Rule>();
    private List<Rule> plural = new ArrayList<Rule>();
    private Map<String, String> irregular = new HashMap<String, String>();

    public String singularlize(String orig) {
        if (this.uncountable.contains(orig)) {
            return orig;
        }
        for (Map.Entry<String, String> entry : this.irregular.entrySet()) {
            if (!entry.getValue().equals(orig)) continue;
            return entry.getKey();
        }
        for (Rule r : this.singular) {
            Matcher m = r.getRegex().matcher(orig);
            if (!m.find()) continue;
            return m.replaceAll(r.getReplacement());
        }
        return orig;
    }

    public String pluralize(String orig) {
        if (this.uncountable.contains(orig)) {
            return orig;
        }
        String irr = this.irregular.get(orig);
        if (irr != null) {
            return irr;
        }
        for (Rule r : this.plural) {
            Matcher m = r.getRegex().matcher(orig);
            if (!m.find()) continue;
            return m.replaceAll(r.getReplacement());
        }
        return orig;
    }

    public void addPlural(String regex, String replacement) {
        this.plural.add(0, new Rule(regex, replacement));
    }

    public void addSingular(String regex, String replacement) {
        this.singular.add(0, new Rule(regex, replacement));
    }

    public void addIrregular(String orig, String replacement) {
        this.irregular.put(orig, replacement);
    }

    public void addUncountable(String[] words) {
        this.uncountable.addAll(Arrays.asList(words));
    }

    public void addUncountable(String word) {
        this.uncountable.add(word);
    }

    static class Rule {
        private Pattern regex;
        private String replacement;

        public Rule(String regex, String replacement) {
            this.regex = Pattern.compile(regex, 2);
            this.replacement = replacement;
        }

        public Pattern getRegex() {
            return this.regex;
        }

        public String getReplacement() {
            return this.replacement;
        }
    }
}

