/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.RendererBase;
import org.richfaces.component.LayoutPosition;
import org.richfaces.component.LayoutStructure;
import org.richfaces.component.UILayoutPanel;
import org.richfaces.renderkit.html.LayoutRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutPanelRenderer
extends RendererBase {
    private static final Object[] LAYOUT_EXCLUSIONS = new Object[]{"id", "style"};

    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.startElement("div", component);
        this.getUtils().encodeCustomId(context, component);
        this.getUtils().encodePassThruWithExclusionsArray(context, component, LAYOUT_EXCLUSIONS);
        String layoutStyle = this.layoutStyle(context, (UILayoutPanel)component);
        if (null != layoutStyle) {
            writer.writeAttribute("style", (Object)layoutStyle, "style");
        }
    }

    public String layoutStyle(FacesContext context, UILayoutPanel panel) {
        LayoutStructure structure;
        StringBuilder style = new StringBuilder();
        LayoutPosition position = panel.getPosition();
        Map requestMap = context.getExternalContext().getRequestMap();
        Object parentLayout = requestMap.get(LayoutRenderer.LAYOUT_STRUCTURE_ATTRIBUTE);
        if (null != parentLayout && parentLayout instanceof LayoutStructure) {
            structure = (LayoutStructure)parentLayout;
        } else {
            structure = new LayoutStructure(panel);
            structure.calculateWidth();
        }
        Object componentStyle = panel.getAttributes().get("style");
        if (null != componentStyle) {
            style.append(componentStyle).append(";");
        }
        if (!LayoutPosition.top.equals((Object)position) && !LayoutPosition.bottom.equals((Object)position)) {
            if (LayoutPosition.right.equals((Object)position)) {
                style.append("float:right;");
            } else {
                style.append("float:left;");
            }
            float coef = 1.0f - (float)structure.getDeep() / 100.0f;
            String width = structure.getWidth(panel, coef);
            if (null != width) {
                style.append("width:").append(width).append(";");
                width = structure.getWidth(panel, coef *= 0.95f);
                style.append("*width:").append(width).append(";");
            }
        }
        return style.length() > 0 ? style.toString() : null;
    }

    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.endElement("div");
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UILayoutPanel.class;
    }
}

