/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.manager.core;

import java.util.LinkedList;
import java.util.List;
import org.jboss.injection.manager.spi.InjectionContext;
import org.jboss.injection.manager.spi.InjectionException;
import org.jboss.injection.manager.spi.Injector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultInjectionContext<T>
implements InjectionContext<T> {
    List<Injector> injectors;
    private final T instance;
    private Class<? super T> clazz;
    private int currentPosition;

    public DefaultInjectionContext(T instance, Class<? super T> clazz, List<Injector> injectors) {
        this.instance = instance;
        this.clazz = clazz;
        this.injectors = new LinkedList<Injector>(injectors);
        this.currentPosition = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proceed() throws InjectionException {
        if (this.currentPosition < this.injectors.size()) {
            try {
                this.injectors.get(this.currentPosition++).inject(this);
            }
            finally {
                --this.currentPosition;
            }
        }
    }

    @Override
    public T getInjectionTarget() {
        return this.instance;
    }

    @Override
    public Class<? super T> getInjectedType() {
        return this.clazz;
    }
}

