/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.reader;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.jboss.interceptor.reader.DefaultMethodMetadata;
import org.jboss.interceptor.spi.metadata.ClassMetadata;
import org.jboss.interceptor.spi.metadata.MethodMetadata;
import org.jboss.interceptor.util.ArrayIterator;
import org.jboss.interceptor.util.ImmutableIteratorWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveClassMetadata<T>
implements ClassMetadata<T>,
Serializable {
    private static final long serialVersionUID = -2088679292389273922L;
    private Class<T> clazz;

    private ReflectiveClassMetadata(Class<T> clazz) {
        this.clazz = clazz;
    }

    public static <T> ClassMetadata<T> of(Class<T> clazz) {
        return new ReflectiveClassMetadata<T>(clazz);
    }

    public String getClassName() {
        return this.clazz.getName();
    }

    public Iterable<MethodMetadata> getDeclaredMethods() {
        return new Iterable<MethodMetadata>(){

            @Override
            public Iterator<MethodMetadata> iterator() {
                return new ImmutableIteratorWrapper<Method>(new ArrayIterator<Method>(ReflectiveClassMetadata.this.clazz.getDeclaredMethods())){

                    @Override
                    protected MethodMetadata wrapObject(Method method) {
                        return DefaultMethodMetadata.of(method);
                    }
                };
            }
        };
    }

    public Class<T> getJavaClass() {
        return this.clazz;
    }

    public ClassMetadata<?> getSuperclass() {
        Class<T> superClass = this.clazz.getSuperclass();
        return superClass == null ? null : new ReflectiveClassMetadata<T>(superClass);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReflectiveClassMetadata other = (ReflectiveClassMetadata)obj;
        return !(this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz));
    }
}

