/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.nointerface.impl.invocationhandler;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.ejb.EJBException;
import org.jboss.ejb3.async.spi.AsyncEndpoint;
import org.jboss.ejb3.endpoint.Endpoint;
import org.jboss.ejb3.nointerface.impl.async.AsyncClientInterceptor;
import org.jboss.ejb3.nointerface.impl.invocationhandler.ObjectMethodsInterceptor;
import org.jboss.ejb3.sis.Interceptor;
import org.jboss.ejb3.sis.InterceptorAssembly;
import org.jboss.ejb3.sis.reflect.InterceptorInvocationHandler;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.spec.AsyncMethodsMetaData;

public class NoInterfaceViewInvocationHandler
implements InvocationHandler {
    private static Logger logger = Logger.getLogger(NoInterfaceViewInvocationHandler.class);
    private KernelControllerContext endpointContext;
    private Serializable session;
    private Class<?> businessInterface;
    private InvocationHandler delegate;

    public NoInterfaceViewInvocationHandler(KernelControllerContext endpointContext, Serializable session, Class<?> businessInterface, AsyncMethodsMetaData asyncMethods) {
        assert (endpointContext != null) : "Endpoint context is null for no-interface view invocation handler";
        this.endpointContext = endpointContext;
        this.session = session;
        this.businessInterface = businessInterface;
        InvocationHandler endpointInvocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return NoInterfaceViewInvocationHandler.this.invokeEndpoint(proxy, method, args);
            }
        };
        AsyncClientInterceptor asyncInterceptor = new AsyncClientInterceptor((AsyncEndpoint)endpointContext.getTarget(), asyncMethods, session);
        InterceptorAssembly chain = new InterceptorAssembly(new Interceptor[]{new ObjectMethodsInterceptor(this), asyncInterceptor});
        this.delegate = new InterceptorInvocationHandler(endpointInvocationHandler, (Interceptor)chain);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.delegate.invoke(proxy, method, args);
    }

    private Object invokeEndpoint(Object proxy, Method method, Object[] args) throws Throwable {
        if (!this.isHandled(method)) {
            throw new EJBException("Cannot invoke method " + method.getName() + " on nointerface view");
        }
        Endpoint endpoint = this.getInstalledEndpoint();
        assert (endpoint != null) : "No endpoint associated with context " + this.endpointContext + " - cannot invoke the method on bean";
        return endpoint.invoke(this.session, this.businessInterface, method, args);
    }

    public KernelControllerContext getContainerContext() {
        return this.endpointContext;
    }

    public Endpoint getInstalledEndpoint() {
        try {
            Endpoint endpoint = (Endpoint)this.endpointContext.getTarget();
            return endpoint;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error getting endpoint out of container KernelControllerContext " + this.endpointContext, t);
        }
    }

    private Endpoint getEndpoint() {
        Object endpoint = this.endpointContext.getTarget();
        assert (endpoint instanceof Endpoint) : "Unexpected type " + endpoint.getClass().getName() + " found in context " + this.endpointContext + " Expected " + Endpoint.class.getName();
        return (Endpoint)endpoint;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof NoInterfaceViewInvocationHandler)) {
            return other.equals(this);
        }
        NoInterfaceViewInvocationHandler otherNoInterfaceViewInvocationHandler = (NoInterfaceViewInvocationHandler)other;
        if (!this.getInstalledEndpoint().equals(otherNoInterfaceViewInvocationHandler.getInstalledEndpoint())) {
            return false;
        }
        return this.session.equals(otherNoInterfaceViewInvocationHandler.session);
    }

    public int hashCode() {
        int hashCode = this.endpointContext.hashCode();
        if (this.session != null) {
            hashCode += this.session.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("No-Interface view for endpoint [ " + this.endpointContext.getName() + " ]");
        if (this.session != null) {
            sb.append(" and session " + this.session);
        }
        return sb.toString();
    }

    public boolean isHandled(Method method) {
        int m = method.getModifiers();
        if (!Modifier.isPublic(m)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Method " + method + " is *not* public"));
            }
            return false;
        }
        if (Modifier.isFinal(m)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Method " + method + " is final"));
            }
            return false;
        }
        if (Modifier.isStatic(m)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Method " + method + " is static"));
            }
            return false;
        }
        if (Modifier.isNative(m)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Method " + method + " is native"));
            }
            return false;
        }
        return true;
    }
}

