/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.plugins.filter;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.classloader.plugins.filter.JavaOnlyClassFilter;
import org.jboss.classloader.spi.filter.ClassFilter;

public class PatternClassFilter
implements ClassFilter {
    private static final long serialVersionUID = -9128970113480901464L;
    private Pattern[] classPatterns;
    private Pattern[] resourcePatterns;
    private Pattern[] packagePatterns;
    private boolean includeJava = false;

    public PatternClassFilter(String[] classPatterns, String[] resourcePatterns, String[] packagePatterns) {
        int i;
        if (classPatterns == null) {
            throw new IllegalArgumentException("Null patterns");
        }
        this.classPatterns = new Pattern[classPatterns.length];
        for (i = 0; i < classPatterns.length; ++i) {
            if (classPatterns[i] == null) {
                throw new IllegalArgumentException("Null pattern in " + Arrays.asList(classPatterns));
            }
            this.classPatterns[i] = Pattern.compile(classPatterns[i]);
        }
        if (resourcePatterns == null) {
            this.resourcePatterns = this.classPatterns;
            return;
        }
        this.resourcePatterns = new Pattern[resourcePatterns.length];
        for (i = 0; i < resourcePatterns.length; ++i) {
            if (resourcePatterns[i] == null) {
                throw new IllegalArgumentException("Null pattern in " + Arrays.asList(resourcePatterns));
            }
            this.resourcePatterns[i] = Pattern.compile(resourcePatterns[i]);
        }
        if (packagePatterns == null) {
            this.packagePatterns = this.classPatterns;
            return;
        }
        this.packagePatterns = new Pattern[packagePatterns.length];
        for (i = 0; i < packagePatterns.length; ++i) {
            if (packagePatterns[i] == null) {
                throw new IllegalArgumentException("Null pattern in " + Arrays.asList(packagePatterns));
            }
            this.packagePatterns[i] = Pattern.compile(packagePatterns[i]);
        }
    }

    public boolean isIncludeJava() {
        return this.includeJava;
    }

    public void setIncludeJava(boolean includeJava) {
        this.includeJava = includeJava;
    }

    public boolean matchesClassName(String className) {
        if (className == null) {
            return false;
        }
        for (int i = 0; i < this.classPatterns.length; ++i) {
            Matcher matcher = this.classPatterns[i].matcher(className);
            if (!matcher.matches()) continue;
            return true;
        }
        if (!this.includeJava) {
            return false;
        }
        return JavaOnlyClassFilter.INSTANCE.matchesClassName(className);
    }

    public boolean matchesResourcePath(String resourcePath) {
        if (resourcePath == null) {
            return false;
        }
        for (int i = 0; i < this.resourcePatterns.length; ++i) {
            Matcher matcher = this.resourcePatterns[i].matcher(resourcePath);
            if (!matcher.matches()) continue;
            return true;
        }
        if (!this.includeJava) {
            return false;
        }
        return JavaOnlyClassFilter.INSTANCE.matchesResourcePath(resourcePath);
    }

    public boolean matchesPackageName(String packageName) {
        if (packageName == null) {
            return false;
        }
        for (int i = 0; i < this.packagePatterns.length; ++i) {
            Matcher matcher = this.packagePatterns[i].matcher(packageName);
            if (!matcher.matches()) continue;
            return true;
        }
        if (!this.includeJava) {
            return false;
        }
        return JavaOnlyClassFilter.INSTANCE.matchesPackageName(packageName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Arrays.asList(this.classPatterns));
        if (this.isIncludeJava()) {
            builder.append(" <INCLUDE_JAVA>");
        }
        return builder.toString();
    }
}

