/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_impl.renderkit.html.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.Resource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    public static final String JAVAX_FACES_LIBRARY_NAME = "javax.faces";
    public static final String JSF_JS_RESOURCE_NAME = "jsf.js";
    public static final String JSF_UNCOMPRESSED_JS_RESOURCE_NAME = "jsf-uncompressed.js";
    private static final String RENDERED_STYLESHEET_RESOURCES_SET = "org.apache.myfaces.RENDERED_STYLESHEET_RESOURCES_SET";
    private static final String RENDERED_SCRIPT_RESOURCES_SET = "org.apache.myfaces.RENDERED_SCRIPT_RESOURCES_SET";
    private static final String RENDERED_JSF_JS = "org.apache.myfaces.RENDERED_JSF_JS";
    private static final String HEAD_TARGET = "head";
    private static final String BODY_TARGET = "body";
    private static final String FORM_TARGET = "form";
    public static final String JAVAX_FACES_OUTPUT_COMPONENT_TYPE = "javax.faces.Output";
    public static final String JAVAX_FACES_TEXT_RENDERER_TYPE = "javax.faces.Text";
    public static final String DEFAULT_SCRIPT_RENDERER_TYPE = "javax.faces.resource.Script";
    public static final String DEFAULT_STYLESHEET_RENDERER_TYPE = "javax.faces.resource.Stylesheet";

    private static Map<String, Boolean> getRenderedStylesheetResources(FacesContext facesContext) {
        HashMap map = (HashMap)facesContext.getAttributes().get(RENDERED_STYLESHEET_RESOURCES_SET);
        if (map == null) {
            map = new HashMap();
            facesContext.getAttributes().put(RENDERED_STYLESHEET_RESOURCES_SET, map);
        }
        return map;
    }

    private static Map<String, Boolean> getRenderedScriptResources(FacesContext facesContext) {
        HashMap map = (HashMap)facesContext.getAttributes().get(RENDERED_SCRIPT_RESOURCES_SET);
        if (map == null) {
            map = new HashMap();
            facesContext.getAttributes().put(RENDERED_SCRIPT_RESOURCES_SET, map);
        }
        return map;
    }

    public static void markScriptAsRendered(FacesContext facesContext, String libraryName, String resourceName) {
        ResourceUtils.getRenderedScriptResources(facesContext).put(libraryName != null ? libraryName + '/' + resourceName : resourceName, Boolean.TRUE);
    }

    public static void markStylesheetAsRendered(FacesContext facesContext, String libraryName, String resourceName) {
        ResourceUtils.getRenderedStylesheetResources(facesContext).put(libraryName != null ? libraryName + '/' + resourceName : resourceName, Boolean.TRUE);
    }

    public static boolean isRenderedScript(FacesContext facesContext, String libraryName, String resourceName) {
        return ResourceUtils.getRenderedScriptResources(facesContext).containsKey(libraryName != null ? libraryName + '/' + resourceName : resourceName);
    }

    public static boolean isRenderedStylesheet(FacesContext facesContext, String libraryName, String resourceName) {
        return ResourceUtils.getRenderedStylesheetResources(facesContext).containsKey(libraryName != null ? libraryName + '/' + resourceName : resourceName);
    }

    public static void writeScriptInline(FacesContext facesContext, ResponseWriter writer, String libraryName, String resourceName) throws IOException {
        if (!ResourceUtils.isRenderedScript(facesContext, libraryName, resourceName)) {
            if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isRiImplAvailable()) {
                UIComponent outputScript = facesContext.getApplication().createComponent(facesContext, JAVAX_FACES_OUTPUT_COMPONENT_TYPE, DEFAULT_SCRIPT_RENDERER_TYPE);
                outputScript.getAttributes().put("name", resourceName);
                outputScript.getAttributes().put("library", libraryName);
                outputScript.encodeAll(facesContext);
            } else {
                Resource resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, libraryName);
                ResourceUtils.markScriptAsRendered(facesContext, libraryName, resourceName);
                writer.startElement("script", null);
                writer.writeAttribute("type", (Object)"text/javascript", null);
                writer.writeURIAttribute("src", (Object)resource.getRequestPath(), null);
                writer.endElement("script");
            }
        }
    }

    public static void renderDefaultJsfJsInlineIfNecessary(FacesContext facesContext, ResponseWriter writer) throws IOException {
        if (facesContext.getAttributes().containsKey(RENDERED_JSF_JS)) {
            return;
        }
        if (ResourceUtils.isRenderedScript(facesContext, JAVAX_FACES_LIBRARY_NAME, JSF_JS_RESOURCE_NAME)) {
            facesContext.getAttributes().put(RENDERED_JSF_JS, Boolean.TRUE);
            return;
        }
        if (MyfacesConfig.getCurrentInstance(facesContext.getExternalContext()).isRiImplAvailable()) {
            UIComponent outputScript = facesContext.getApplication().createComponent(facesContext, JAVAX_FACES_OUTPUT_COMPONENT_TYPE, DEFAULT_SCRIPT_RENDERER_TYPE);
            outputScript.getAttributes().put("name", JSF_JS_RESOURCE_NAME);
            outputScript.getAttributes().put("library", JAVAX_FACES_LIBRARY_NAME);
            outputScript.encodeAll(facesContext);
        } else {
            Resource resource = facesContext.getApplication().getResourceHandler().createResource(JSF_JS_RESOURCE_NAME, JAVAX_FACES_LIBRARY_NAME);
            ResourceUtils.markScriptAsRendered(facesContext, JAVAX_FACES_LIBRARY_NAME, JSF_JS_RESOURCE_NAME);
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeURIAttribute("src", (Object)resource.getRequestPath(), null);
            writer.endElement("script");
        }
        facesContext.getAttributes().put(RENDERED_JSF_JS, Boolean.TRUE);
    }
}

