/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import javax.management.ObjectName;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceController;
import org.jboss.system.metadata.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDeployer
extends AbstractSimpleRealDeployer<ServiceMetaData> {
    private final ServiceController controller;
    public static final ObjectName DEFAULT_CLASSLOADER_OBJECT_NAME = ObjectNameFactory.create((String)"jboss:service=defaultClassLoader");
    private ObjectName defaultClassLoader = DEFAULT_CLASSLOADER_OBJECT_NAME;

    public ServiceDeployer(ServiceController controller) {
        super(ServiceMetaData.class);
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
        this.setComponentsOnly(true);
        this.setUseUnitName(true);
    }

    public ObjectName getDefaultClassLoader() {
        return this.defaultClassLoader;
    }

    public void setDefaultClassLoader(ObjectName defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
    }

    public void deploy(DeploymentUnit unit, ServiceMetaData deployment) throws DeploymentException {
        ObjectName name = deployment.getObjectName();
        try {
            ObjectName loaderName = deployment.getClassLoaderName();
            if (loaderName == null) {
                loaderName = this.findLoaderName(unit.getClassLoader());
            }
            this.controller.install(deployment, loaderName);
            ServiceContext context = this.controller.getServiceContext(name);
            if (context == null) {
                throw new IllegalStateException("No context for " + name);
            }
            try {
                this.create(context);
                try {
                    this.start(context);
                    Throwable t = context.getProblem();
                    if (t != null) {
                        throw t;
                    }
                }
                catch (Throwable t) {
                    this.destroy(name);
                    throw t;
                }
            }
            catch (Throwable t) {
                this.remove(name);
                throw t;
            }
            ControllerContext serviceContext = this.getControllerContext(name);
            if (serviceContext != null) {
                this.putContext(serviceContext, unit.getParent());
            }
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + name), (Throwable)t);
        }
    }

    protected ControllerContext getControllerContext(ObjectName name) {
        Kernel kernel = this.controller.getKernel();
        KernelController controller = kernel.getController();
        String canonicalName = name.getCanonicalName();
        return controller.getContext((Object)canonicalName, null);
    }

    protected ObjectName findLoaderName(ClassLoader cl) {
        if (cl == null) {
            return this.defaultClassLoader;
        }
        if (cl instanceof RealClassLoader) {
            RealClassLoader rcl = (RealClassLoader)RealClassLoader.class.cast(cl);
            return rcl.getObjectName();
        }
        return this.findLoaderName(cl.getParent());
    }

    public void undeploy(DeploymentUnit unit, ServiceMetaData deployment) {
        ServiceContext context;
        ObjectName name = deployment.getObjectName();
        ControllerContext serviceContext = this.getControllerContext(name);
        if (serviceContext != null) {
            this.removeContext(serviceContext, unit.getParent());
        }
        if ((context = this.controller.getServiceContext(name)) != null) {
            this.stop(name);
            this.destroy(name);
            this.remove(name);
        }
    }

    protected void create(ServiceContext context) throws Throwable {
        this.controller.create(context.objectName);
    }

    protected void start(ServiceContext context) throws Throwable {
        this.controller.start(context.objectName);
    }

    protected void stop(ObjectName name) {
        try {
            this.controller.stop(name);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during stop for " + name), t);
        }
    }

    protected void destroy(ObjectName name) {
        try {
            this.controller.destroy(name);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during destroy for " + name), t);
        }
    }

    protected void remove(ObjectName name) {
        try {
            this.controller.remove(name);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error during destroy for " + name), t);
        }
    }
}

