/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.Any;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.IDLEntity;

public class TypeCode
extends org.omg.CORBA.TypeCode {
    private final int kind;
    private String id = null;
    private String name = null;
    private int member_count = 0;
    private String[] member_name = null;
    private org.omg.CORBA.TypeCode[] member_type = null;
    private short[] member_visibility = null;
    private Any[] member_label = null;
    private short value_modifier = 0;
    private org.omg.CORBA.TypeCode discriminator_type = null;
    private int default_index = -1;
    private int length = -1;
    private org.omg.CORBA.TypeCode content_type = null;
    private short scale;
    private short digits;
    private boolean recursive = false;
    private TypeCode actualTypecode = null;
    private boolean secondIteration = false;
    private static org.omg.CORBA.TypeCode[] primitive_tcs;
    private static Map primitive_tcs_map;

    private static void put_primitive_tcs(Class clazz, int n) {
        primitive_tcs_map.put(clazz, primitive_tcs[n]);
    }

    static org.omg.CORBA.TypeCode get_primitive_tc(int n) {
        if (primitive_tcs[n] == null) {
            throw new BAD_PARAM("No primitive TypeCode for kind " + n);
        }
        return primitive_tcs[n];
    }

    public boolean is_primitive() {
        return !this.is_recursive() && primitive_tcs[this.kind] != null;
    }

    public TypeCode(int n) {
        this.kind = n;
    }

    public TypeCode(String string) {
        this(-1);
        this.id = string;
        this.recursive = true;
    }

    public TypeCode(int n, String string, String string2, StructMember[] structMemberArray) {
        this(n);
        this.id = string;
        this.name = string2 != null ? string2.replace('.', '_') : "";
        this.member_count = structMemberArray.length;
        this.member_name = new String[this.member_count];
        this.member_type = new org.omg.CORBA.TypeCode[this.member_count];
        for (int i = 0; i < this.member_count; ++i) {
            this.member_name[i] = structMemberArray[i].name;
            this.member_type[i] = structMemberArray[i].type;
        }
    }

    public TypeCode(String string, String string2, org.omg.CORBA.TypeCode typeCode, UnionMember[] unionMemberArray) {
        this(16);
        this.id = string;
        this.name = string2 != null ? string2.replace('.', '_') : "";
        this.discriminator_type = typeCode;
        this.member_count = unionMemberArray.length;
        this.member_name = new String[this.member_count];
        this.member_label = new Any[this.member_count];
        this.member_type = new org.omg.CORBA.TypeCode[this.member_count];
        for (int i = 0; i < this.member_count; ++i) {
            this.member_name[i] = unionMemberArray[i].name;
            this.member_label[i] = (Any)unionMemberArray[i].label;
            if (this.member_label[i].kind().equals(TCKind.tk_octet) && (Byte)this.member_label[i].value() == 0) {
                this.default_index = i;
            }
            this.member_type[i] = unionMemberArray[i].type;
        }
    }

    public TypeCode(String string, String string2, String[] stringArray) {
        this(17);
        this.id = string;
        this.name = string2 != null ? string2.replace('.', '_') : "";
        this.member_count = stringArray.length;
        this.member_name = new String[this.member_count];
        System.arraycopy(stringArray, 0, this.member_name, 0, this.member_count);
    }

    public TypeCode(int n, String string, String string2, org.omg.CORBA.TypeCode typeCode) {
        this(n);
        this.id = string;
        this.name = string2 != null ? string2.replace('.', '_') : "";
        this.content_type = typeCode;
    }

    public TypeCode(int n, String string, String string2) {
        this(n);
        this.id = string;
        this.name = string2 != null ? string2.replace('.', '_') : "";
    }

    public TypeCode(int n, int n2) {
        this(n);
        this.length = n2;
    }

    public TypeCode(int n, int n2, org.omg.CORBA.TypeCode typeCode) {
        this(n);
        this.length = n2;
        this.content_type = typeCode;
        if (this.content_type == null) {
            throw new BAD_PARAM("TypeCode.ctor, content_type null");
        }
    }

    public TypeCode(short s, short s2) {
        this(28);
        this.digits = s;
        this.scale = s2;
    }

    public TypeCode(String string, String string2, short s, org.omg.CORBA.TypeCode typeCode, ValueMember[] valueMemberArray) {
        this(29);
        this.id = string;
        this.name = string2 != null ? string2.replace('.', '_') : "";
        this.value_modifier = s;
        this.content_type = typeCode;
        this.setValueMembers(valueMemberArray);
        this.resolveRecursion(this);
    }

    private void setValueMembers(ValueMember[] valueMemberArray) {
        this.member_count = valueMemberArray != null ? valueMemberArray.length : 0;
        this.member_name = new String[this.member_count];
        this.member_type = new org.omg.CORBA.TypeCode[this.member_count];
        this.member_visibility = new short[this.member_count];
        for (int i = 0; i < this.member_count; ++i) {
            this.member_name[i] = valueMemberArray[i].name;
            this.member_type[i] = valueMemberArray[i].type;
            this.member_visibility[i] = valueMemberArray[i].access;
        }
    }

    public boolean equal(org.omg.CORBA.TypeCode typeCode) {
        try {
            if (this.is_recursive()) {
                this.checkActualTC();
                if (typeCode instanceof TypeCode && ((TypeCode)typeCode).is_recursive()) {
                    TypeCode typeCode2 = (TypeCode)typeCode;
                    typeCode2.checkActualTC();
                    if (this.secondIteration) {
                        return true;
                    }
                    this.secondIteration = true;
                    boolean bl = this.actualTypecode.equal(typeCode2.actualTypecode);
                    this.secondIteration = false;
                    return bl;
                }
                return typeCode.equal(this.actualTypecode);
            }
            if (typeCode instanceof TypeCode && ((TypeCode)typeCode).is_recursive()) {
                TypeCode typeCode3 = (TypeCode)typeCode;
                typeCode3.checkActualTC();
                return this.equal(typeCode3.actualTypecode);
            }
            if (this.kind().value() != typeCode.kind().value()) {
                return false;
            }
            if (!(this.kind != 14 && this.kind != 15 && this.kind != 16 && this.kind != 17 && this.kind != 21 && this.kind != 22 && this.kind != 29 && this.kind != 30 && this.kind != 31 && this.kind != 32 && this.kind != 33 || this.id().equals(typeCode.id()) && this.name().equals(typeCode.name()))) {
                return false;
            }
            if (this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 29 || this.kind == 22) {
                if (this.member_count() != typeCode.member_count()) {
                    return false;
                }
                for (int i = 0; i < this.member_count(); ++i) {
                    if (!this.member_name(i).equals(typeCode.member_name(i))) {
                        return false;
                    }
                    if (this.kind != 17 && !this.member_type(i).equal(typeCode.member_type(i))) {
                        return false;
                    }
                    if (this.kind == 16 && !this.member_label(i).equal(typeCode.member_label(i))) {
                        return false;
                    }
                    if (this.kind != 29 || this.member_visibility(i) == typeCode.member_visibility(i)) continue;
                    return false;
                }
            }
            if (!(this.kind != 16 || this.discriminator_type().equal(typeCode.discriminator_type()) && this.default_index() == typeCode.default_index())) {
                return false;
            }
            if ((this.kind == 18 || this.kind == 27 || this.kind == 20 || this.kind == 19) && this.length() != typeCode.length()) {
                return false;
            }
            if (!(this.kind != 20 && this.kind != 19 && this.kind != 21 && this.kind != 30 || this.content_type().equal(typeCode.content_type()))) {
                return false;
            }
            if (this.kind == 28 && (this.fixed_digits() != typeCode.fixed_digits() || this.fixed_scale() != typeCode.fixed_scale())) {
                return false;
            }
            if (this.kind == 29) {
                if (this.type_modifier() != typeCode.type_modifier()) {
                    return false;
                }
                if (this.concrete_base_type() != null || typeCode.concrete_base_type() != null) {
                    if (this.concrete_base_type() == null || typeCode.concrete_base_type() == null) {
                        return false;
                    }
                    if (!this.concrete_base_type().equal(typeCode.concrete_base_type())) {
                        return false;
                    }
                }
            }
        }
        catch (Bounds bounds) {
            return false;
        }
        catch (BadKind badKind) {
            return false;
        }
        return true;
    }

    public TCKind kind() {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.kind();
        }
        return TCKind.from_int(this.kind);
    }

    public int _kind() {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode._kind();
        }
        return this.kind;
    }

    public String id() throws BadKind {
        if (this.is_recursive()) {
            return this.id;
        }
        switch (this.kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return this.id;
            }
            case 18: 
            case 19: 
            case 20: {
                throw new BadKind();
            }
            case 21: 
            case 22: {
                return this.id;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                throw new BadKind();
            }
            case 29: 
            case 30: {
                return this.id;
            }
            case 31: {
                throw new BadKind();
            }
            case 32: 
            case 33: {
                return this.id;
            }
        }
        throw new BadKind();
    }

    public String name() throws BadKind {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.name();
        }
        switch (this.kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return this.name;
            }
        }
        throw new BadKind();
    }

    public int member_count() throws BadKind {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.member_count();
        }
        switch (this.kind) {
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 29: {
                return this.member_count;
            }
        }
        throw new BadKind();
    }

    public String member_name(int n) throws BadKind, Bounds {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.member_name(n);
        }
        switch (this.kind) {
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 29: {
                if (n >= 0 && n < this.member_count) {
                    return this.member_name[n];
                }
                throw new Bounds();
            }
        }
        throw new BadKind();
    }

    public org.omg.CORBA.TypeCode member_type(int n) throws BadKind, Bounds {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.member_type(n);
        }
        switch (this.kind) {
            case 15: 
            case 16: 
            case 22: 
            case 29: {
                if (n >= 0 && n < this.member_count) {
                    return this.member_type[n];
                }
                throw new Bounds();
            }
        }
        throw new BadKind();
    }

    public org.omg.CORBA.Any member_label(int n) throws BadKind, Bounds {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.member_label(n);
        }
        if (this.kind != 16) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count) {
            throw new Bounds();
        }
        return this.member_label[n];
    }

    public org.omg.CORBA.TypeCode discriminator_type() throws BadKind {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.discriminator_type();
        }
        if (this.kind != 16) {
            throw new BadKind();
        }
        return this.discriminator_type;
    }

    public int default_index() throws BadKind {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.default_index();
        }
        if (this.kind != 16) {
            throw new BadKind();
        }
        return this.default_index;
    }

    public int length() throws BadKind {
        switch (this.kind) {
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                return this.length;
            }
        }
        throw new BadKind();
    }

    public org.omg.CORBA.TypeCode content_type() throws BadKind {
        switch (this.kind) {
            case 19: 
            case 20: 
            case 21: 
            case 30: {
                return this.content_type;
            }
        }
        throw new BadKind();
    }

    public short fixed_digits() throws BadKind {
        if (this.kind != 28) {
            throw new BadKind();
        }
        return this.digits;
    }

    public short fixed_scale() throws BadKind {
        if (this.kind != 28) {
            throw new BadKind();
        }
        return this.scale;
    }

    public org.omg.CORBA.TypeCode get_compact_typecode() {
        int n;
        TypeCode typeCode = new TypeCode(this.kind, this.id, "");
        typeCode.member_count = this.member_count;
        if (this.member_name != null) {
            typeCode.member_name = new String[this.member_name.length];
            for (n = 0; n < typeCode.member_name.length; ++n) {
                typeCode.member_name[n] = "";
            }
        } else {
            typeCode.member_name = this.member_name;
        }
        if (this.member_type != null) {
            typeCode.member_type = new TypeCode[this.member_type.length];
            for (n = 0; n < typeCode.member_type.length; ++n) {
                typeCode.member_type[n] = this.member_type[n].get_compact_typecode();
            }
        }
        typeCode.member_visibility = this.member_visibility;
        typeCode.member_label = this.member_label;
        typeCode.value_modifier = this.value_modifier;
        typeCode.discriminator_type = this.discriminator_type;
        typeCode.default_index = this.default_index;
        typeCode.length = this.length;
        typeCode.content_type = this.content_type;
        typeCode.scale = this.scale;
        typeCode.digits = this.digits;
        typeCode.recursive = this.recursive;
        typeCode.actualTypecode = this.actualTypecode;
        typeCode.secondIteration = this.secondIteration;
        typeCode.resolveRecursion();
        return typeCode;
    }

    public short member_visibility(int n) throws BadKind, Bounds {
        if (this.kind != 29) {
            throw new BadKind();
        }
        if (n < 0 || n >= this.member_count) {
            throw new Bounds();
        }
        return this.member_visibility[n];
    }

    public short type_modifier() throws BadKind {
        if (this.kind != 29) {
            throw new BadKind();
        }
        return this.value_modifier;
    }

    public org.omg.CORBA.TypeCode concrete_base_type() throws BadKind {
        if (this.kind != 29) {
            throw new BadKind();
        }
        return this.content_type;
    }

    public boolean equivalent(org.omg.CORBA.TypeCode typeCode) {
        try {
            if (this.is_recursive()) {
                this.checkActualTC();
                if (typeCode instanceof TypeCode && ((TypeCode)typeCode).is_recursive()) {
                    TypeCode typeCode2 = (TypeCode)typeCode;
                    typeCode2.checkActualTC();
                    if (this.secondIteration) {
                        return true;
                    }
                    this.secondIteration = true;
                    boolean bl = this.actualTypecode.equivalent(typeCode2.actualTypecode);
                    this.secondIteration = false;
                    return bl;
                }
                return typeCode.equivalent(this.actualTypecode);
            }
            if (typeCode instanceof TypeCode && ((TypeCode)typeCode).is_recursive()) {
                TypeCode typeCode3 = (TypeCode)typeCode;
                typeCode3.checkActualTC();
                return this.equivalent(typeCode3.actualTypecode);
            }
            if (this.kind().value() == 21) {
                return this.content_type().equivalent(typeCode);
            }
            if (typeCode.kind().value() == 21) {
                return this.equivalent(typeCode.content_type());
            }
            if (this.kind().value() != typeCode.kind().value()) {
                return false;
            }
            if ((this.kind == 14 || this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 21 || this.kind == 22 || this.kind == 29 || this.kind == 30 || this.kind == 31 || this.kind == 32 || this.kind == 33) && this.id().length() > 0 && typeCode.id().length() > 0) {
                return this.id().equals(typeCode.id());
            }
            if (this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 29 || this.kind == 22) {
                if (this.member_count() != typeCode.member_count()) {
                    return false;
                }
                for (int i = 0; i < this.member_count(); ++i) {
                    if (this.kind != 17 && !this.member_type(i).equivalent(typeCode.member_type(i))) {
                        return false;
                    }
                    if (this.kind == 16 && !this.member_label(i).equal(typeCode.member_label(i))) {
                        return false;
                    }
                    if (this.kind != 29 || this.member_visibility(i) == typeCode.member_visibility(i)) continue;
                    return false;
                }
            }
            if (!(this.kind != 16 || this.discriminator_type().equivalent(typeCode.discriminator_type()) && this.default_index() == typeCode.default_index())) {
                return false;
            }
            if ((this.kind == 18 || this.kind == 27 || this.kind == 20 || this.kind == 19) && this.length() != typeCode.length()) {
                return false;
            }
            if (!(this.kind != 20 && this.kind != 19 && this.kind != 21 && this.kind != 30 || this.content_type().equivalent(typeCode.content_type()))) {
                return false;
            }
            if (this.kind == 28 && (this.fixed_digits() != typeCode.fixed_digits() || this.fixed_scale() != typeCode.fixed_scale())) {
                return false;
            }
            if (!(this.kind != 29 || this.type_modifier() == typeCode.type_modifier() && this.concrete_base_type().equivalent(typeCode.concrete_base_type()))) {
                return false;
            }
        }
        catch (Bounds bounds) {
            return false;
        }
        catch (BadKind badKind) {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.idlTypeName();
    }

    public boolean is_recursive() {
        return this.recursive;
    }

    public static boolean isRecursive(org.omg.CORBA.TypeCode typeCode) {
        return typeCode instanceof TypeCode ? ((TypeCode)typeCode).is_recursive() : false;
    }

    public static String idlTypeName(org.omg.CORBA.TypeCode typeCode) {
        return typeCode instanceof TypeCode ? ((TypeCode)typeCode).idlTypeName() : "(foreign typecode)";
    }

    public String idlTypeName() {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.idlTypeName();
        }
        switch (this.kind().value()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 33: {
                try {
                    return TypeCode.idToIDL(this.id());
                }
                catch (BadKind badKind) {
                    throw new INTERNAL("should never happen");
                }
            }
            case 1: {
                return "void";
            }
            case 18: {
                return "string";
            }
            case 27: {
                return "wstring";
            }
            case 20: {
                try {
                    return TypeCode.idlTypeName(this.content_type()) + "[]";
                }
                catch (BadKind badKind) {
                    throw new INTERNAL("should never happen");
                }
            }
            case 3: {
                return "long";
            }
            case 5: {
                return "ulong";
            }
            case 23: {
                return "long long";
            }
            case 24: {
                return "ulong long";
            }
            case 4: {
                return "ushort";
            }
            case 2: {
                return "short";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 28: {
                try {
                    return "fixed <" + this.fixed_digits() + "," + this.fixed_scale() + ">";
                }
                catch (BadKind badKind) {
                    throw new INTERNAL("should never happen");
                }
            }
            case 8: {
                return "boolean";
            }
            case 10: {
                return "octet";
            }
            case 9: {
                return "char";
            }
            case 26: {
                return "wchar";
            }
            case 11: {
                return "any";
            }
            case 19: {
                try {
                    return "sequence <" + TypeCode.idlTypeName(this.content_type()) + ">";
                }
                catch (BadKind badKind) {
                    throw new INTERNAL("should never happen");
                }
            }
        }
        return "* no typeName for TK " + this.kind().value() + " *";
    }

    private static String idToIDL(String string) {
        if (string.length() > 4) {
            string = string.startsWith("IDL:") ? string.substring(4, string.lastIndexOf(":")) : string.replace('.', '/') + ":1.0";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) != '/') continue;
            stringBuffer.setCharAt(i, ':');
            stringBuffer.insert(i, ':');
        }
        return stringBuffer.toString();
    }

    public static final org.omg.CORBA.TypeCode originalType(org.omg.CORBA.TypeCode typeCode) {
        if (TypeCode.isRecursive(typeCode)) {
            return typeCode;
        }
        try {
            while (typeCode.kind() == TCKind.tk_alias || typeCode.kind() == TCKind.tk_value_box) {
                typeCode = typeCode.content_type();
            }
        }
        catch (BadKind badKind) {
            throw new INTERNAL("should never happen");
        }
        return typeCode;
    }

    public static TypeCode create_tc(Class clazz) {
        return TypeCode.create_tc(clazz, new HashMap());
    }

    private static TypeCode create_tc(Class clazz, Map map) {
        if (clazz.isPrimitive()) {
            return (TypeCode)primitive_tcs_map.get(clazz);
        }
        if (map.containsKey(clazz)) {
            TypeCode typeCode = new TypeCode(RepositoryID.repId(clazz));
            typeCode.setActualTC((TypeCode)map.get(clazz));
            return typeCode;
        }
        if (clazz.isArray()) {
            TypeCode typeCode = new TypeCode(30, RepositoryID.repId(clazz), "Java_array", new TypeCode(19, 0, TypeCode.create_tc(clazz.getComponentType(), map)));
            map.put(clazz, typeCode);
            return typeCode;
        }
        if (Remote.class.isAssignableFrom(clazz)) {
            return new TypeCode(14, RepositoryID.repId(clazz), clazz.getName());
        }
        if (IDLEntity.class.isAssignableFrom(clazz)) {
            String string = clazz.getName() + "Helper";
            try {
                ClassLoader classLoader = clazz.getClassLoader();
                Class<?> clazz2 = classLoader == null ? ObjectUtil.classForName(string) : classLoader.loadClass(string);
                Method method = clazz2.getMethod("type", null);
                TypeCode typeCode = (TypeCode)method.invoke(null, (Object[])null);
                map.put(clazz, typeCode);
                return typeCode;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Cannot create TypeCode for class " + clazz + "\nReason: Error loading helper class " + string + "\n" + classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("Cannot create TypeCode for class: " + clazz + "\nReason: no type() method in helper class " + string + "\n" + noSuchMethodException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException("Cannot create TypeCode for class: " + clazz + "\n" + illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalArgumentException("Cannot create TypeCode for class: " + clazz + "\nReason: exception in type() method\n " + invocationTargetException.getTargetException());
            }
        }
        if (clazz == Serializable.class || clazz == Externalizable.class || clazz == Object.class) {
            return (TypeCode)TypeCode.get_primitive_tc(11);
        }
        if (TypeCode.isMappedToAnAbstractInterface(clazz)) {
            TypeCode typeCode = new TypeCode(32, RepositoryID.repId(clazz), clazz.getName());
            map.put(clazz, typeCode);
            return typeCode;
        }
        Class clazz3 = clazz.getSuperclass();
        TypeCode typeCode = null;
        if (clazz3 != null && clazz3 != Object.class) {
            typeCode = TypeCode.create_tc(clazz3, map);
        }
        TypeCode typeCode2 = new TypeCode(RepositoryID.repId(clazz), clazz.getName(), 0, typeCode, new ValueMember[0]);
        map.put(clazz, typeCode2);
        typeCode2.setValueMembers(TypeCode.getValueMembers(clazz, map));
        return typeCode2;
    }

    private static boolean isMappedToAnAbstractInterface(Class clazz) {
        if (!clazz.isInterface()) {
            return false;
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            int n;
            Class<?>[] classArray = methodArray[i].getExceptionTypes();
            for (n = 0; n < classArray.length && !classArray[n].isAssignableFrom(RemoteException.class); ++n) {
            }
            if (n != classArray.length) continue;
            return false;
        }
        return true;
    }

    private static ValueMember[] getValueMembers(Class clazz, Map map) {
        ArrayList<ValueMember> arrayList = new ArrayList<ValueMember>();
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            if ((fieldArray[i].getModifiers() & 0x98) != 0) continue;
            arrayList.add(TypeCode.createValueMember(fieldArray[i], map));
        }
        return arrayList.toArray(new ValueMember[arrayList.size()]);
    }

    private static ValueMember createValueMember(Field field, Map map) {
        Class<?> clazz = field.getType();
        String string = RepositoryID.repId(clazz);
        TypeCode typeCode = TypeCode.create_tc(clazz, map);
        short s = (field.getModifiers() & 1) != 0 ? (short)1 : 0;
        return new ValueMember(field.getName(), string, "", "1.0", typeCode, null, s);
    }

    void resolveRecursion() {
        if (this.kind == 15 || this.kind == 16) {
            this.resolveRecursion(this);
        }
    }

    private void resolveRecursion(TypeCode typeCode) {
        if (this.member_type == null) {
            return;
        }
        block5: for (int i = 0; i < this.member_type.length; ++i) {
            org.omg.CORBA.TypeCode typeCode2 = TypeCode.originalType(this.member_type[i]);
            if (!(typeCode2 instanceof TypeCode)) continue;
            TypeCode typeCode3 = (TypeCode)typeCode2;
            switch (typeCode3.kind) {
                case 15: 
                case 16: 
                case 29: {
                    typeCode3.resolveRecursion(typeCode);
                    continue block5;
                }
                case 19: {
                    typeCode2 = TypeCode.originalType(typeCode3.content_type);
                    if (!(typeCode2 instanceof TypeCode)) continue block5;
                    typeCode3 = (TypeCode)typeCode2;
                    if (typeCode3.is_recursive() && typeCode3.id.equals(typeCode.id)) {
                        typeCode3.setActualTC(typeCode);
                        continue block5;
                    }
                    typeCode3.resolveRecursion(typeCode);
                    continue block5;
                }
                case -1: {
                    if (!typeCode3.id.equals(typeCode.id)) continue block5;
                    typeCode3.setActualTC(typeCode);
                }
            }
        }
    }

    private void setActualTC(TypeCode typeCode) {
        if (this.is_recursive()) {
            this.actualTypecode = typeCode;
        }
    }

    private void checkActualTC() {
        if (this.is_recursive() && this.actualTypecode == null) {
            throw new BAD_INV_ORDER();
        }
    }

    static {
        int n;
        primitive_tcs = new TypeCode[34];
        primitive_tcs_map = new HashMap();
        for (n = 0; n <= 13; ++n) {
            TypeCode.primitive_tcs[n] = new TypeCode(n);
        }
        for (n = 23; n <= 26; ++n) {
            TypeCode.primitive_tcs[n] = new TypeCode(n);
        }
        TypeCode.primitive_tcs[18] = new TypeCode(18, 0);
        TypeCode.primitive_tcs[27] = new TypeCode(27, 0);
        TypeCode.primitive_tcs[28] = new TypeCode(1, 0);
        TypeCode.primitive_tcs[14] = new TypeCode(14, "IDL:omg.org/CORBA/Object:1.0", "Object");
        TypeCode.primitive_tcs[29] = new TypeCode("IDL:omg.org/CORBA/portable/ValueBase:1.0", "ValueBase", 0, null, new ValueMember[0]);
        TypeCode.put_primitive_tcs(Boolean.TYPE, 8);
        TypeCode.put_primitive_tcs(Character.TYPE, 26);
        TypeCode.put_primitive_tcs(Byte.TYPE, 10);
        TypeCode.put_primitive_tcs(Short.TYPE, 2);
        TypeCode.put_primitive_tcs(Integer.TYPE, 3);
        TypeCode.put_primitive_tcs(Long.TYPE, 23);
        TypeCode.put_primitive_tcs(Float.TYPE, 6);
        TypeCode.put_primitive_tcs(Double.TYPE, 7);
    }
}

