/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.collection;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.access.SoftLock;
import org.hibernate.cache.infinispan.access.TransactionalAccessDelegate;
import org.hibernate.cache.infinispan.collection.CollectionRegionImpl;

class TransactionalAccess
implements CollectionRegionAccessStrategy {
    private final CollectionRegionImpl region;
    private final TransactionalAccessDelegate delegate;

    TransactionalAccess(CollectionRegionImpl region) {
        this.region = region;
        this.delegate = new TransactionalAccessDelegate(region, region.getPutFromLoadValidator());
    }

    public void evict(Object key) throws CacheException {
        this.delegate.evict(key);
    }

    public void evictAll() throws CacheException {
        this.delegate.evictAll();
    }

    public Object get(Object key, long txTimestamp) throws CacheException {
        return this.delegate.get(key, txTimestamp);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        return this.delegate.putFromLoad(key, value, txTimestamp, version);
    }

    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        return this.delegate.putFromLoad(key, value, txTimestamp, version, minimalPutOverride);
    }

    public void remove(Object key) throws CacheException {
        this.delegate.remove(key);
    }

    public void removeAll() throws CacheException {
        this.delegate.removeAll();
    }

    public CollectionRegion getRegion() {
        return this.region;
    }

    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    public void unlockItem(Object key, SoftLock lock) throws CacheException {
    }

    public void unlockRegion(SoftLock lock) throws CacheException {
    }
}

