/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.util;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.jboss.security.xacml.util.SecurityActions;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class JBossXACMLEntityResolver
implements LSResourceResolver {
    private static Map<String, LSInput> lsmap = new HashMap<String, LSInput>();
    private static Map<String, String> schemaLocationMap = new HashMap<String, String>();

    public LSInput resolveResource(String type, String namespaceURI, final String publicId, final String systemId, final String baseURI) {
        LSInput lsi = lsmap.get(systemId);
        if (lsi == null) {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            String loc = schemaLocationMap.get(systemId);
            if (loc == null) {
                return null;
            }
            final InputStream is = tcl.getResourceAsStream(loc);
            if (is == null) {
                System.out.println("inputstream is null for " + loc);
            }
            lsi = new LSInput(){

                public String getBaseURI() {
                    return baseURI;
                }

                public InputStream getByteStream() {
                    return is;
                }

                public boolean getCertifiedText() {
                    return false;
                }

                public Reader getCharacterStream() {
                    return null;
                }

                public String getEncoding() {
                    return null;
                }

                public String getPublicId() {
                    return publicId;
                }

                public String getStringData() {
                    return null;
                }

                public String getSystemId() {
                    return systemId;
                }

                public void setBaseURI(String baseURI2) {
                }

                public void setByteStream(InputStream byteStream) {
                }

                public void setCertifiedText(boolean certifiedText) {
                }

                public void setCharacterStream(Reader characterStream) {
                }

                public void setEncoding(String encoding) {
                }

                public void setPublicId(String publicId2) {
                }

                public void setStringData(String stringData) {
                }

                public void setSystemId(String systemId2) {
                }
            };
            lsmap.put(systemId, lsi);
        }
        return lsi;
    }

    static {
        schemaLocationMap.put("urn:oasis:names:tc:xacml:2.0:policy:schema:os", "schema/access_control-xacml-2.0-policy-schema-os.xsd");
        schemaLocationMap.put("urn:oasis:names:tc:xacml:2.0:context:schema:os", "schema/access_control-xacml-2.0-context-schema-os.xsd");
        schemaLocationMap.put("http://www.w3.org/TR/2002/REC-xmlenc-core-20021210/xenc-schema.xsd", "schema/w3c/xmlenc/xenc-schema.xsd");
        schemaLocationMap.put("datatypes.dtd", "schema/w3c/xmlschema/datatypes.dtd");
        schemaLocationMap.put("http://www.w3.org/2001/XMLSchema.dtd", "schema/w3c/xmlschema/XMLSchema.dtd");
    }
}

