/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.attachments.helpers;

import java.util.Map;
import org.jboss.deployers.spi.attachments.MutableAttachments;
import org.jboss.deployers.spi.attachments.helpers.AbstractAttachments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMutableAttachments
extends AbstractAttachments
implements MutableAttachments {
    private static final long serialVersionUID = -1692116584854666016L;

    @Override
    public <T> T addAttachment(String name, T attachment, Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.addAttachment(name, attachment);
        if (result == null) {
            return null;
        }
        if (!expectedType.isInstance(result)) {
            throw new IllegalArgumentException("Previous attachment not of the same type: expected=" + expectedType + ", previous=" + result);
        }
        return expectedType.cast(result);
    }

    @Override
    public void setAttachments(Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("Null map");
        }
        this.clear();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.addAttachment(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <T> T addAttachment(Class<T> type, T attachment) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return this.addAttachment(type.getName(), attachment, type);
    }

    @Override
    public <T> T removeAttachment(String name, Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.removeAttachment(name);
        if (result == null) {
            return null;
        }
        if (!expectedType.isInstance(result)) {
            throw new IllegalArgumentException("Removed attachment not of the same type: expected=" + expectedType + ", removed=" + result);
        }
        return expectedType.cast(result);
    }

    @Override
    public <T> T removeAttachment(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return this.removeAttachment(type.getName(), type);
    }
}

