/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptor;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.jboss.metadata.ejb.spec.InterceptorMetaData;

@Deprecated
public class InterceptorInfo {
    Class<?> clazz;
    InterceptorMetaData xml;
    protected Method aroundInvoke;
    protected Method postConstruct;
    protected Method postActivate;
    protected Method preDestroy;
    protected Method prePassivate;
    protected Method[] aroundInvokeHierarchy;
    protected Method[] postConstructHierarchy;
    protected Method[] postActivateHierarchy;
    protected Method[] preDestroyHierarchy;
    protected Method[] prePassivateHierarchy;
    boolean haveCalculatedHierarchy;

    protected InterceptorInfo() {
    }

    public InterceptorInfo(Class<?> clazz) {
        this.clazz = clazz;
    }

    public InterceptorInfo(InterceptorInfo interceptorInfo) {
        this.clazz = interceptorInfo.clazz;
        this.aroundInvoke = interceptorInfo.aroundInvoke;
        this.postConstruct = interceptorInfo.postConstruct;
        this.postActivate = interceptorInfo.postActivate;
        this.preDestroy = interceptorInfo.preDestroy;
        this.prePassivate = interceptorInfo.prePassivate;
        this.aroundInvokeHierarchy = interceptorInfo.aroundInvokeHierarchy;
        this.postConstructHierarchy = interceptorInfo.postConstructHierarchy;
        this.postActivateHierarchy = interceptorInfo.postActivateHierarchy;
        this.preDestroyHierarchy = interceptorInfo.preDestroyHierarchy;
        this.prePassivateHierarchy = interceptorInfo.prePassivateHierarchy;
    }

    protected void setXml(InterceptorMetaData xml) {
        this.xml = xml;
    }

    public InterceptorMetaData getXml() {
        return this.xml;
    }

    public Method getAroundInvoke() {
        return this.aroundInvoke;
    }

    protected void setAroundInvoke(Method aroundInvoke) {
        if (aroundInvoke == null) {
            return;
        }
        if (this.aroundInvoke != null && !this.aroundInvoke.equals(aroundInvoke)) {
            throw new RuntimeException("Interceptors can only have one around-invoke/@AroundInvoke method - " + this.clazz.getName());
        }
        this.aroundInvoke = this.makeAccessible(aroundInvoke);
    }

    public Class getClazz() {
        return this.clazz;
    }

    public boolean haveCalculatedHierarchy() {
        return this.haveCalculatedHierarchy;
    }

    public Method getPostActivate() {
        return this.postActivate;
    }

    protected void setPostActivate(Method postActivate) {
        if (postActivate == null) {
            return;
        }
        if (this.postActivate != null && !this.postActivate.equals(postActivate)) {
            throw new RuntimeException("Interceptors can only have one post-activate/@PostActivate method - " + this.clazz.getName());
        }
        this.postActivate = this.makeAccessible(postActivate);
    }

    public Method getPostConstruct() {
        return this.postConstruct;
    }

    protected void setPostConstruct(Method postConstruct) {
        if (postConstruct == null) {
            return;
        }
        if (this.postConstruct != null && !this.postConstruct.equals(postConstruct)) {
            throw new RuntimeException("Interceptors can only have one post-construct/@PostConstruct method - " + this.clazz.getName());
        }
        this.postConstruct = this.makeAccessible(postConstruct);
    }

    public Method getPreDestroy() {
        return this.preDestroy;
    }

    protected void setPreDestroy(Method preDestroy) {
        if (preDestroy == null) {
            return;
        }
        if (this.preDestroy != null && !this.preDestroy.equals(preDestroy)) {
            throw new RuntimeException("Interceptors can only have one pre-destroy/@PreDestroy method - " + this.clazz.getName());
        }
        this.preDestroy = this.makeAccessible(preDestroy);
    }

    public Method getPrePassivate() {
        return this.prePassivate;
    }

    protected void setPrePassivate(Method prePassivate) {
        if (prePassivate == null) {
            return;
        }
        if (this.prePassivate != null && !this.prePassivate.equals(prePassivate)) {
            throw new RuntimeException("Interceptors can only have one pre-passivate/@PrePassivate method - " + this.clazz.getName());
        }
        this.prePassivate = this.makeAccessible(prePassivate);
    }

    public Method[] getAroundInvokes() {
        return this.aroundInvokeHierarchy;
    }

    public Method[] getPostActivates() {
        return this.postActivateHierarchy;
    }

    public Method[] getPostConstructs() {
        return this.postConstructHierarchy;
    }

    public Method[] getPreDestroys() {
        return this.preDestroyHierarchy;
    }

    public Method[] getPrePassivates() {
        return this.prePassivateHierarchy;
    }

    private Method makeAccessible(final Method method) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    method.setAccessible(true);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getException());
        }
        return method;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("InterceptorInfo{class=" + this.clazz);
        this.appendMethods(sb);
        sb.append("}");
        return sb.toString();
    }

    protected void appendMethods(StringBuffer sb) {
        this.appendMethodString(sb, "aroundInvoke", this.aroundInvoke);
        this.appendMethodString(sb, "postConstruct", this.postConstruct);
        this.appendMethodString(sb, "postActivate", this.postActivate);
        this.appendMethodString(sb, "prePassivate", this.prePassivate);
        this.appendMethodString(sb, "preDestroy", this.preDestroy);
    }

    protected void appendMethodString(StringBuffer buf, String methodType, Method m) {
        if (m != null) {
            buf.append(", " + methodType + "=" + m.getName());
        }
    }

    public void calculateHierarchy(InterceptorInfo superInfo) {
        if (this.haveCalculatedHierarchy) {
            return;
        }
        this.postConstructHierarchy = this.initaliseMethods(superInfo != null ? superInfo.postConstructHierarchy : null, this.postConstruct);
        this.postActivateHierarchy = this.initaliseMethods(superInfo != null ? superInfo.postActivateHierarchy : null, this.postActivate);
        this.aroundInvokeHierarchy = this.initaliseMethods(superInfo != null ? superInfo.aroundInvokeHierarchy : null, this.aroundInvoke);
        this.prePassivateHierarchy = this.initaliseMethods(superInfo != null ? superInfo.prePassivateHierarchy : null, this.prePassivate);
        this.preDestroyHierarchy = this.initaliseMethods(superInfo != null ? superInfo.preDestroyHierarchy : null, this.preDestroy);
        this.haveCalculatedHierarchy = true;
    }

    private Method[] initaliseMethods(Method[] superMethods, Method myMethod) {
        if (superMethods == null && myMethod == null) {
            return null;
        }
        ArrayList<Method> hierarchy = new ArrayList<Method>();
        if (superMethods != null) {
            for (int i = 0; i < superMethods.length; ++i) {
                if (this.haveMethod(superMethods[i])) continue;
                hierarchy.add(superMethods[i]);
            }
        }
        if (myMethod != null) {
            hierarchy.add(myMethod);
        }
        return hierarchy.toArray(new Method[hierarchy.size()]);
    }

    private boolean haveMethod(Method method) {
        try {
            this.clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof InterceptorInfo) {
            return this.clazz.equals(((InterceptorInfo)obj).getClazz());
        }
        return false;
    }

    public int hashCode() {
        return this.clazz.getName().hashCode();
    }
}

