/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javassist.bytecode.ClassFile;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.persistence.Entity;
import javax.security.jacc.PolicyConfiguration;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.ejb3.ClassFileFilter;
import org.jboss.ejb3.ClientDescriptorFileFilter;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3DeploymentMBean;
import org.jboss.ejb3.Ejb3DescriptorHandler;
import org.jboss.ejb3.Ejb3Handler;
import org.jboss.ejb3.Ejb3HandlerFactory;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.async.spi.AttachmentNames;
import org.jboss.ejb3.cache.CacheFactoryRegistry;
import org.jboss.ejb3.cache.persistence.PersistenceManagerFactoryRegistry;
import org.jboss.ejb3.common.lang.ClassHelper;
import org.jboss.ejb3.common.resolvers.spi.EjbReferenceResolver;
import org.jboss.ejb3.ejbref.resolver.spi.EjbReference;
import org.jboss.ejb3.javaee.JavaEEApplication;
import org.jboss.ejb3.javaee.JavaEEComponent;
import org.jboss.ejb3.javaee.JavaEEComponentHelper;
import org.jboss.ejb3.javaee.JavaEEModule;
import org.jboss.ejb3.metadata.JBossSessionGenericWrapper;
import org.jboss.ejb3.pool.PoolFactoryRegistry;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.resolvers.DefaultMessageDestinationReferenceResolver;
import org.jboss.ejb3.resolvers.MessageDestinationReferenceResolver;
import org.jboss.ejb3.vfs.spi.VirtualFile;
import org.jboss.injection.InjectionHandler;
import org.jboss.jpa.resolvers.PersistenceUnitDependencyResolver;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossGenericBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanGenericWrapper;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.system.ServiceMBeanSupport;

public abstract class Ejb3Deployment
extends ServiceMBeanSupport
implements JavaEEModule,
Ejb3DeploymentMBean {
    private static final Logger log = Logger.getLogger(Ejb3Deployment.class);
    public static final String ACTUAL_ENTITY_MANAGER_FACTORY_CONTEXT = "java:/ActualEntityManagerFactories";
    public static final String MANAGED_ENTITY_FACTORY_CONTEXT = "java:/managedEntityFactories";
    private JBossMetaData metaData;
    protected DeploymentUnit unit;
    protected LinkedHashMap<ObjectName, Container> ejbContainers = new LinkedHashMap();
    protected boolean hasEntities;
    protected List<String> explicitEntityClasses = new ArrayList<String>();
    protected String defaultSLSBDomain = "Stateless Bean";
    protected String defaultSFSBDomain = "Stateful Bean";
    protected String defaultMDBDomain = "Message Driven Bean";
    protected String defaultConsumerDomain = "Consumer Bean";
    protected String defaultServiceDomain = "Service Bean";
    protected InitialContext initialContext;
    protected KernelAbstraction kernelAbstraction;
    protected MBeanServer mbeanServer;
    protected DeploymentScope deploymentScope;
    private MessageDestinationReferenceResolver messageDestinationReferenceResolver = new DefaultMessageDestinationReferenceResolver();
    protected CacheFactoryRegistry cacheFactoryRegistry;
    protected PersistenceManagerFactoryRegistry persistenceManagerFactoryRegistry;
    protected PoolFactoryRegistry poolFactoryRegistry;
    protected ObjectName objectName;
    protected boolean reinitialize = false;
    private org.jboss.deployers.structure.spi.DeploymentUnit deploymentUnit;
    @Deprecated
    private EjbReferenceResolver deprecatedEjbRefResolver;
    private org.jboss.ejb3.ejbref.resolver.spi.EjbReferenceResolver ejbReferenceResolver;
    private PersistenceUnitDependencyResolver persistenceUnitDependencyResolver;
    private final ExecutorService asynchronousProcessor;
    private final String appName;

    public Ejb3Deployment(org.jboss.deployers.structure.spi.DeploymentUnit deploymentUnit, DeploymentUnit unit, DeploymentScope deploymentScope, JBossMetaData metaData) {
        assert (unit != null) : "unit is null";
        assert (deploymentUnit != null) : "deploymentUnit is null";
        this.unit = unit;
        this.deploymentScope = deploymentScope;
        this.metaData = metaData;
        try {
            this.initialContext = InitialContextFactory.getInitialContext(unit.getJndiProperties());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        MessageDestinationsMetaData destinations = null;
        if (metaData != null && metaData.getAssemblyDescriptor() != null) {
            destinations = metaData.getAssemblyDescriptor().getMessageDestinations();
        }
        this.deploymentUnit = deploymentUnit;
        String asyncInvocationProcessorName = AttachmentNames.ASYNC_INVOCATION_PROCESSOR;
        ExecutorService es = (ExecutorService)unit.getAttachment(asyncInvocationProcessorName);
        if (es == null) {
            throw new IllegalStateException(unit + " must contain an attachment of name " + asyncInvocationProcessorName);
        }
        this.asynchronousProcessor = es;
        org.jboss.deployers.structure.spi.DeploymentUnit parent = deploymentUnit.getParent();
        this.appName = parent != null ? parent.getName() : null;
    }

    public String getAppName() {
        return this.appName;
    }

    @Deprecated
    public boolean canResolveEJB() {
        return this.ejbReferenceResolver != null;
    }

    @Override
    public JavaEEApplication getApplication() {
        return this.deploymentScope;
    }

    public DeploymentScope getEar() {
        return this.deploymentScope;
    }

    public KernelAbstraction getKernelAbstraction() {
        return this.kernelAbstraction;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.unit;
    }

    public String getDefaultSLSBDomain() {
        return this.defaultSLSBDomain;
    }

    public CacheFactoryRegistry getCacheFactoryRegistry() {
        return this.cacheFactoryRegistry;
    }

    public void setCacheFactoryRegistry(CacheFactoryRegistry registry) {
        this.cacheFactoryRegistry = registry;
    }

    public PersistenceManagerFactoryRegistry getPersistenceManagerFactoryRegistry() {
        return this.persistenceManagerFactoryRegistry;
    }

    public void setEJBReferenceResolver(EjbReferenceResolver resolver) {
        log.debug((Object)("setEJBReferenceResolver(" + EjbReferenceResolver.class + ") is deprecated"));
        this.deprecatedEjbRefResolver = resolver;
    }

    @Inject
    public void setEJBReferenceResolver(org.jboss.ejb3.ejbref.resolver.spi.EjbReferenceResolver resolver) {
        this.ejbReferenceResolver = resolver;
    }

    public ExecutorService getAsynchronousProcessor() {
        return this.asynchronousProcessor;
    }

    @Inject
    public void setMessageDestinationReferenceResolver(MessageDestinationReferenceResolver resolver) {
        this.messageDestinationReferenceResolver = resolver;
    }

    public void setPersistenceManagerFactoryRegistry(PersistenceManagerFactoryRegistry registry) {
        this.persistenceManagerFactoryRegistry = registry;
    }

    @Inject
    public void setPersistenceUnitDependencyResolver(PersistenceUnitDependencyResolver resolver) {
        this.persistenceUnitDependencyResolver = resolver;
    }

    public PoolFactoryRegistry getPoolFactoryRegistry() {
        return this.poolFactoryRegistry;
    }

    public void setPoolFactoryRegistry(PoolFactoryRegistry poolFactoryRegistry) {
        this.poolFactoryRegistry = poolFactoryRegistry;
    }

    @Deprecated
    public void setProcessPersistenceUnits(boolean b) {
        if (b) {
            log.warn((Object)"EJBTHREE-1508: Processing persistence units is no longer supported");
        }
    }

    private String getScopeKernelName() {
        String scopedKernelName = "";
        if (this.deploymentScope != null) {
            scopedKernelName = scopedKernelName + ",ear=" + this.deploymentScope.getShortName();
        }
        scopedKernelName = scopedKernelName + ",jar=" + this.unit.getShortName();
        return scopedKernelName;
    }

    public void setDefaultSLSBDomain(String defaultSLSBDomain) {
        this.defaultSLSBDomain = defaultSLSBDomain;
    }

    public String getDefaultSFSBDomain() {
        return this.defaultSFSBDomain;
    }

    public String getDefaultConsumerDomain() {
        return this.defaultConsumerDomain;
    }

    public void setDefaultSFSBDomain(String defaultSFSBDomain) {
        this.defaultSFSBDomain = defaultSFSBDomain;
    }

    public String getDefaultMDBDomain() {
        return this.defaultMDBDomain;
    }

    public void setDefaultMDBDomain(String defaultMDBDomain) {
        this.defaultMDBDomain = defaultMDBDomain;
    }

    public String getDefaultServiceDomain() {
        return this.defaultServiceDomain;
    }

    public void setDefaultServiceDomain(String defaultServiceDomain) {
        this.defaultServiceDomain = defaultServiceDomain;
    }

    protected String getJaccContextId() {
        return this.unit.getShortName();
    }

    public EJBContainer getEjbContainerForEjbName(String ejbName) {
        ObjectName ejbON;
        String ejbObjectName = JavaEEComponentHelper.createObjectName(this, ejbName);
        EJBContainer container = null;
        try {
            ejbON = new ObjectName(ejbObjectName);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to ", e);
        }
        container = (EJBContainer)this.ejbContainers.get(ejbON);
        return container;
    }

    @Override
    public Container getContainer(ObjectName name) {
        return this.ejbContainers.get(name);
    }

    public Map getEjbContainers() {
        return this.ejbContainers;
    }

    @Deprecated
    public List<?> getPersistenceUnitDeployments() {
        log.warn((Object)"EJBTHREE-1508: Quering Ejb3Deployment for persistence unit deployments is no longer supported");
        return Collections.EMPTY_LIST;
    }

    public EJBContainer getEjbContainer(String ejbLink, Class businessIntf) {
        String relativePath = this.unit.getRelativePath();
        EJBContainer container = this.deploymentScope.getEjbContainer(ejbLink, businessIntf, relativePath);
        return container;
    }

    public String getEjbJndiName(String ejbLink, Class businessIntf) {
        EJBContainer container = this.getEjbContainer(ejbLink, businessIntf);
        String jndiName = ProxyFactoryHelper.getJndiName(container, businessIntf);
        return jndiName;
    }

    public String getEjbJndiName(Class businessIntf) throws NameNotFoundException {
        EJBContainer container = this.getEjbContainer(businessIntf);
        String jndiName = ProxyFactoryHelper.getJndiName(container, businessIntf);
        return jndiName;
    }

    public EJBContainer getEjbContainer(Class businessIntf) throws NameNotFoundException {
        String relativePath = this.unit.getRelativePath();
        return this.deploymentScope.getEjbContainer(businessIntf, relativePath);
    }

    protected void processEJBContainerMetadata(Container container) throws Exception {
        log.trace((Object)("Process EJB container metadata " + container));
        ObjectName on = container.getObjectName();
        this.ejbContainers.put(on, container);
        container.processMetadata();
    }

    protected void registerDeployment() throws Exception {
        String jmxName;
        String on = "jboss.j2ee:service=EJB3" + this.getScopeKernelName();
        if (this.metaData != null && this.metaData.getEnterpriseBeans() != null && this.metaData.getEnterpriseBeans().getEjbJarMetaData() != null && (jmxName = this.metaData.getEnterpriseBeans().getEjbJarMetaData().getJmxName()) != null && jmxName.trim().length() > 0) {
            on = jmxName;
        }
        this.objectName = new ObjectName(on);
        this.mbeanServer.registerMBean(this, this.objectName);
    }

    protected void unregisterDeployment() {
        try {
            this.mbeanServer.unregisterMBean(this.objectName);
        }
        catch (Exception e) {
            log.debug((Object)("error trying to stop ejb deployment: " + this.objectName), (Throwable)e);
        }
    }

    protected void registerEJBContainer(Container container) throws Exception {
        ObjectName on = container.getObjectName();
        String name = on.getCanonicalName();
        DependencyPolicy dependsPolicy = container.getDependencyPolicy();
        dependsPolicy.addDependency("jboss.ejb:service=EJBTimerService");
        this.kernelAbstraction.install(name, dependsPolicy, this.unit, container);
        this.mbeanServer.registerMBean(container.getMBean(), on);
        log.debug((Object)("Bound ejb3 container " + name));
    }

    protected abstract PolicyConfiguration createPolicyConfiguration() throws Exception;

    protected abstract void putJaccInService(PolicyConfiguration var1, DeploymentUnit var2);

    protected Collection<InjectionHandler<Environment>> getHandlers() {
        return null;
    }

    public void create() throws Exception {
        try {
            long start = System.currentTimeMillis();
            this.deploy();
            this.registerDeployment();
            Iterator<Container> i$ = this.ejbContainers.values().iterator();
            while (i$.hasNext()) {
                Container o;
                Container con = o = i$.next();
                try {
                    this.processEJBContainerMetadata(con);
                }
                catch (Exception e) {
                    String message = "Exception while processing container metadata for EJB: " + con.getEjbName() + " in unit: " + this.getDeploymentUnit().getShortName();
                    throw new Exception(message, e);
                }
            }
            log.debug((Object)("EJB3 deployment time took: " + (System.currentTimeMillis() - start)));
        }
        catch (Exception e) {
            try {
                this.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    protected void reinitialize() throws Exception {
        this.reinitialize = false;
    }

    public void start() throws Exception {
        if (this.reinitialize) {
            this.reinitialize();
        }
        Iterator<Container> i$ = this.ejbContainers.values().iterator();
        while (i$.hasNext()) {
            Container o;
            Container con = o = i$.next();
            try {
                this.registerEJBContainer(con);
            }
            catch (Exception e) {
                String message = "Exception while registering EJB container for EJB: " + con.getEjbName() + " in unit: " + this.getDeploymentUnit().getShortName();
                log.error((Object)message);
                try {
                    this.stop();
                    this.destroy();
                }
                catch (Exception ignoredException) {
                    // empty catch block
                }
                throw new Exception(message, e);
            }
        }
    }

    public void stop() {
        for (ObjectName on : this.ejbContainers.keySet()) {
            try {
                this.mbeanServer.unregisterMBean(on);
                this.kernelAbstraction.uninstall(on.getCanonicalName());
            }
            catch (Exception e) {
                log.debug((Object)("error trying to stop ejb container: " + on), (Throwable)e);
            }
        }
        this.reinitialize = true;
    }

    protected void deploy() throws Exception {
        if (this.metaData == null || !this.metaData.isMetadataComplete()) {
            Ejb3HandlerFactory factory = Ejb3HandlerFactory.getInstance(this);
            if (this.unit.getUrl() != null) {
                this.deployUrl(factory);
            }
            if (this.unit.getClasses() != null) {
                for (Class explicit : this.unit.getClasses()) {
                    if (explicit.isAnnotationPresent(Entity.class)) continue;
                    String name = explicit.getName().replace('.', '/') + ".class";
                    InputStream stream = explicit.getClassLoader().getResourceAsStream(name);
                    this.deployElement(stream, factory, this.initialContext);
                }
            }
        }
        this.deployBeansFromLib(this.initialContext);
    }

    protected void deployUrl(Ejb3HandlerFactory factory) throws Exception {
        List<VirtualFile> clientDescriptors = this.unit.getResources(new ClientDescriptorFileFilter());
        if (clientDescriptors.size() > 0) {
            return;
        }
        InitialContext ctx = this.initialContext;
        List<VirtualFile> classes = this.unit.getResources(new ClassFileFilter());
        for (VirtualFile classFile : classes) {
            InputStream stream = classFile.openStream();
            this.deployElement(stream, factory, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployElement(InputStream stream, Ejb3HandlerFactory factory, InitialContext ctx) throws Exception {
        DataInputStream dstream = new DataInputStream(new BufferedInputStream(stream));
        ClassFile cf = null;
        try {
            cf = new ClassFile(dstream);
        }
        finally {
            dstream.close();
            stream.close();
        }
        this.deployElement(factory, cf, ctx);
    }

    protected void deployBeansFromLib(InitialContext ctx) throws Exception {
        JBossMetaData dd = this.getMetaData();
        if (dd != null) {
            Ejb3DescriptorHandler handler = new Ejb3DescriptorHandler(this, dd);
            handler.setCtxProperties(this.unit.getJndiProperties());
            HashMap<String, Container> localContainers = new HashMap<String, Container>();
            for (Container container : this.ejbContainers.values()) {
                localContainers.put(container.getEjbName(), container);
            }
            List<Container> containers = handler.getContainers(this, localContainers);
            for (Container con : containers) {
                try {
                    ((EJBContainer)con).instantiated();
                    this.ejbContainers.put(con.getObjectName(), con);
                    Ejb3Registry.register(con);
                }
                catch (Throwable t) {
                    throw new DeploymentException("Error creating ejb container " + con.getEjbName() + ": " + t.getMessage(), t);
                }
            }
        }
    }

    protected void deployElement(Ejb3HandlerFactory factory, ClassFile cf, InitialContext ctx) throws Exception {
        Ejb3Handler handler = factory.createHandler(cf);
        handler.setCtxProperties(this.unit.getJndiProperties());
        if (handler.isEjb() || handler.isJBossBeanType()) {
            List<Container> containers = handler.getContainers(cf, this);
            for (Container con : containers) {
                try {
                    ((EJBContainer)con).instantiated();
                    this.ejbContainers.put(con.getObjectName(), con);
                    Ejb3Registry.register(con);
                }
                catch (Throwable t) {
                    throw new DeploymentException("Error creating ejb container " + con.getEjbName() + ": " + t.getMessage(), t);
                }
            }
        }
    }

    public abstract DependencyPolicy createDependencyPolicy(JavaEEComponent var1);

    public void destroy() {
        try {
            this.undeploy();
            this.unregisterDeployment();
        }
        catch (Exception e) {
            log.debug((Object)"error trying to destroy ejb deployment", (Throwable)e);
        }
    }

    private void undeploy() {
        for (Container container : this.ejbContainers.values()) {
            Ejb3Registry.unregister(container);
        }
    }

    public String resolveEJB(String link, Class<?> beanInterface, String mappedName) {
        EjbReference reference = new EjbReference(link, beanInterface.getName(), mappedName);
        return this.ejbReferenceResolver.resolveEjb(this.deploymentUnit, reference);
    }

    public String resolveMessageDestination(String link) {
        return this.messageDestinationReferenceResolver.resolveMessageDestinationJndiName(this.deploymentUnit, link);
    }

    protected String resolvePersistenceUnitSupplier(String persistenceUnitName) {
        return this.persistenceUnitDependencyResolver.resolvePersistenceUnitSupplier(this.deploymentUnit, persistenceUnitName);
    }

    protected <B extends JBossEnterpriseBeanMetaData> B getEnterpriseBeanMetaData(String ejbName, Class<B> enterpriseBeanMetaDataClass) {
        if (this.metaData == null) {
            return null;
        }
        Object result = this.metaData.getEnterpriseBean(ejbName);
        if (result instanceof JBossGenericBeanMetaData) {
            log.warn((Object)("FIXME: EJBTHREE-1227: JBossGenericBeanMetaData found for '" + ejbName + "' instead of " + enterpriseBeanMetaDataClass));
            if (enterpriseBeanMetaDataClass.equals(JBossSessionBeanMetaData.class)) {
                result = new JBossSessionGenericWrapper((JBossGenericBeanMetaData)result);
            } else if (enterpriseBeanMetaDataClass.equals(JBossMessageDrivenBeanMetaData.class)) {
                result = new JBossMessageDrivenBeanGenericWrapper((JBossGenericBeanMetaData)result);
            } else {
                throw new IllegalStateException("Can't find a generic bean meta data wrapper for " + enterpriseBeanMetaDataClass);
            }
        }
        return (B)((JBossEnterpriseBeanMetaData)ClassHelper.cast(enterpriseBeanMetaDataClass, (Object)result));
    }

    public JBossMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public String getName() {
        return this.unit.getShortName();
    }
}

