/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.managed.plugins.factory;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;

public class ManagedObjectFactoryBuilder {
    private static final ManagedObjectFactory singleton = AccessController.doPrivileged(new PrivilegedAction<ManagedObjectFactory>(){

        @Override
        public ManagedObjectFactory run() {
            ManagedObjectFactory mof = null;
            String defaultMOF = AbstractManagedObjectFactory.class.getName();
            String className = System.getProperty(ManagedObjectFactory.class.getName(), defaultMOF);
            try {
                Class<?> clazz;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    try {
                        clazz = this.getClass().getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException ignored) {
                        throw e;
                    }
                }
                Object result = clazz.newInstance();
                mof = (ManagedObjectFactory)ManagedObjectFactory.class.cast(result);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error("Unexpected error loading ManagedObjectFactory " + className, e);
            }
            return mof;
        }
    });

    public static ManagedObjectFactory create() {
        return singleton;
    }
}

