/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnection;
import org.jboss.resource.adapter.jdbc.JBossWrapper;
import org.jboss.resource.adapter.jdbc.WrappedCallableStatement;
import org.jboss.resource.adapter.jdbc.WrappedPreparedStatement;
import org.jboss.resource.adapter.jdbc.WrappedStatement;
import org.jboss.resource.adapter.jdbc.WrapperDataSource;
import org.jboss.util.NestedSQLException;

public abstract class WrappedConnection
extends JBossWrapper
implements Connection {
    private static final Logger log = Logger.getLogger(WrappedConnection.class);
    private volatile BaseWrapperManagedConnection mc;
    private BaseWrapperManagedConnection lockedMC;
    private int lockCount;
    private WrapperDataSource dataSource;
    private HashMap<WrappedStatement, Throwable> statements;
    private boolean closed = false;
    private int trackStatements;

    public WrappedConnection(BaseWrapperManagedConnection mc) {
        this.mc = mc;
        if (mc != null) {
            this.trackStatements = mc.getTrackStatements();
        }
    }

    void setManagedConnection(BaseWrapperManagedConnection mc) {
        this.mc = mc;
        if (mc != null) {
            this.trackStatements = mc.getTrackStatements();
        }
    }

    protected void lock() throws SQLException {
        BaseWrapperManagedConnection mc = this.mc;
        if (mc != null) {
            mc.tryLock();
            if (this.lockedMC == null) {
                this.lockedMC = mc;
            }
            ++this.lockCount;
        } else {
            throw new SQLException("Connection is not associated with a managed connection." + this);
        }
    }

    protected void unlock() {
        BaseWrapperManagedConnection mc = this.lockedMC;
        if (--this.lockCount == 0) {
            this.lockedMC = null;
        }
        if (mc != null) {
            mc.unlock();
        }
    }

    public WrapperDataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(WrapperDataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.lock();
        try {
            this.checkStatus();
            this.mc.setJdbcReadOnly(readOnly);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkStatus();
        return this.mc.isJdbcReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        this.closed = true;
        if (this.mc != null) {
            if (this.trackStatements != 0) {
                WrappedConnection wrappedConnection = this;
                synchronized (wrappedConnection) {
                    if (this.statements != null) {
                        for (Map.Entry<WrappedStatement, Throwable> entry : this.statements.entrySet()) {
                            WrappedStatement ws = entry.getKey();
                            if (this.trackStatements == 1) {
                                Throwable stackTrace = entry.getValue();
                                log.warn((Object)"Closing a statement you left open, please do your own housekeeping", stackTrace);
                            }
                            try {
                                ws.internalClose();
                            }
                            catch (Throwable t) {
                                log.warn((Object)"Exception trying to close statement:", t);
                            }
                        }
                    }
                }
            }
            this.mc.closeHandle(this);
        }
        this.mc = null;
        this.dataSource = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    protected abstract WrappedStatement wrapStatement(Statement var1);

    @Override
    public Statement createStatement() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                WrappedStatement wrappedStatement = this.wrapStatement(this.mc.getConnection().createStatement());
                return wrappedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                WrappedStatement wrappedStatement = this.wrapStatement(this.mc.getConnection().createStatement(resultSetType, resultSetConcurrency));
                return wrappedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                WrappedStatement wrappedStatement = this.wrapStatement(this.mc.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
                return wrappedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    protected abstract WrappedPreparedStatement wrapPreparedStatement(PreparedStatement var1);

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(this.mc.prepareStatement(sql, 1003, 1007));
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(this.mc.prepareStatement(sql, resultSetType, resultSetConcurrency));
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(this.mc.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(this.mc.getConnection().prepareStatement(sql, autoGeneratedKeys));
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(this.mc.getConnection().prepareStatement(sql, columnIndexes));
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(this.mc.getConnection().prepareStatement(sql, columnNames));
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    protected abstract WrappedCallableStatement wrapCallableStatement(CallableStatement var1);

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                WrappedCallableStatement wrappedCallableStatement = this.wrapCallableStatement(this.mc.prepareCall(sql, 1003, 1007));
                return wrappedCallableStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                WrappedCallableStatement wrappedCallableStatement = this.wrapCallableStatement(this.mc.prepareCall(sql, resultSetType, resultSetConcurrency));
                return wrappedCallableStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                WrappedCallableStatement wrappedCallableStatement = this.wrapCallableStatement(this.mc.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
                return wrappedCallableStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                String string = this.mc.getConnection().nativeSQL(sql);
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean autocommit) throws SQLException {
        this.lock();
        try {
            this.checkStatus();
            this.mc.setJdbcAutoCommit(autocommit);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoCommit() throws SQLException {
        this.lock();
        try {
            this.checkStatus();
            boolean bl = this.mc.isJdbcAutoCommit();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            this.mc.jdbcCommit();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            this.mc.jdbcRollback();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            this.mc.jdbcRollback(savepoint);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                DatabaseMetaData databaseMetaData = this.mc.getConnection().getMetaData();
                return databaseMetaData;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.mc.getConnection().setCatalog(catalog);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                String string = this.mc.getConnection().getCatalog();
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int isolationLevel) throws SQLException {
        this.lock();
        try {
            this.checkStatus();
            this.mc.setJdbcTransactionIsolation(isolationLevel);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() throws SQLException {
        this.lock();
        try {
            this.checkStatus();
            int n = this.mc.getJdbcTransactionIsolation();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                SQLWarning sQLWarning = this.mc.getConnection().getWarnings();
                return sQLWarning;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.mc.getConnection().clearWarnings();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    public Map getTypeMap() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                Map<String, Class<?>> map = this.mc.getConnection().getTypeMap();
                return map;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeMap(Map typeMap) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.mc.getConnection().setTypeMap(typeMap);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.mc.getConnection().setHoldability(holdability);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                int n = this.mc.getConnection().getHoldability();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                Savepoint savepoint = this.mc.getConnection().setSavepoint();
                return savepoint;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                Savepoint savepoint = this.mc.getConnection().setSavepoint(name);
                return savepoint;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                this.mc.getConnection().releaseSavepoint(savepoint);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getUnderlyingConnection() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            Connection connection = this.mc.getConnection();
            return connection;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    protected Connection getWrappedObject() throws SQLException {
        return this.getUnderlyingConnection();
    }

    protected void checkTransaction() throws SQLException {
        this.checkStatus();
        this.mc.checkTransaction();
    }

    void checkTransactionActive() throws SQLException {
        if (this.dataSource == null) {
            return;
        }
        this.dataSource.checkTransactionActive();
    }

    protected void checkStatus() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection handle has been closed and is unusable");
        }
        if (this.mc == null) {
            throw new SQLException("Connection handle is not currently associated with a ManagedConnection");
        }
        this.checkTransactionActive();
    }

    protected SQLException checkException(Throwable t) throws SQLException {
        Throwable result = null;
        if (t instanceof AbstractMethodError) {
            t = new SQLFeatureNotSupportedException("Method is not implemented by JDBC driver", t);
        }
        if (this.mc != null) {
            result = this.mc.connectionError(t);
        }
        if (result instanceof SQLException) {
            throw (SQLException)result;
        }
        throw new NestedSQLException("Error", result);
    }

    int getTrackStatements() {
        return this.trackStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerStatement(WrappedStatement ws) {
        if (this.trackStatements == 0) {
            return;
        }
        WrappedConnection wrappedConnection = this;
        synchronized (wrappedConnection) {
            if (this.statements == null) {
                this.statements = new HashMap();
            }
            if (this.trackStatements == 1) {
                this.statements.put(ws, new Throwable("STACKTRACE"));
            } else {
                this.statements.put(ws, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterStatement(WrappedStatement ws) {
        if (this.trackStatements == 0) {
            return;
        }
        WrappedConnection wrappedConnection = this;
        synchronized (wrappedConnection) {
            if (this.statements != null) {
                this.statements.remove(ws);
            }
        }
    }

    void checkConfiguredQueryTimeout(WrappedStatement ws) throws SQLException {
        if (this.mc == null || this.dataSource == null) {
            return;
        }
        int timeout = 0;
        if (this.mc.isTransactionQueryTimeout()) {
            timeout = this.dataSource.getTimeLeftBeforeTransactionTimeout();
        }
        if (timeout <= 0) {
            timeout = this.mc.getQueryTimeout();
        }
        if (timeout > 0) {
            ws.setQueryTimeout(timeout);
        }
    }

    Logger getLogger() {
        return log;
    }
}

