/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;
import org.hornetq.utils.XidCodecSupport;

public class SessionXACommitMessage
extends PacketImpl {
    private boolean onePhase;
    private Xid xid;

    public SessionXACommitMessage(Xid xid, boolean onePhase) {
        super((byte)53);
        this.xid = xid;
        this.onePhase = onePhase;
    }

    public SessionXACommitMessage() {
        super((byte)53);
    }

    public Xid getXid() {
        return this.xid;
    }

    public boolean isOnePhase() {
        return this.onePhase;
    }

    @Override
    public boolean isAsyncExec() {
        return true;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        XidCodecSupport.encodeXid(this.xid, buffer);
        buffer.writeBoolean(this.onePhase);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.xid = XidCodecSupport.decodeXid(buffer);
        this.onePhase = buffer.readBoolean();
    }

    @Override
    public String toString() {
        return this.getParentString() + ", xid=" + this.xid + ", onePhase=" + this.onePhase + "]";
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof SessionXACommitMessage)) {
            return false;
        }
        SessionXACommitMessage r = (SessionXACommitMessage)other;
        return super.equals(other) && this.xid.equals(r.xid) && this.onePhase == r.onePhase;
    }
}

