/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.renderer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.xmind.cathy.internal.renderer.XStackRenderer;

public class XSashLayout
extends Layout {
    int suggestedSizeForViewStack = 310;
    int suggestedDownDistanceForViewStack = 22;
    int marginLeft = 0;
    int marginRight = 0;
    int marginTop = 0;
    int marginBottom = 0;
    int sashWidth = 0;
    MUIElement root;

    public XSashLayout(MUIElement root) {
        this.root = root;
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (this.root == null) {
            return;
        }
        Rectangle bounds = composite.getBounds();
        if (composite instanceof Shell) {
            bounds = ((Shell)composite).getClientArea();
        } else {
            bounds.x = 0;
            bounds.y = 0;
        }
        bounds.width -= this.marginLeft + this.marginRight;
        bounds.height -= this.marginTop + this.marginBottom;
        bounds.x += this.marginLeft;
        bounds.y += this.marginTop;
        this.tileSubNodes(bounds, this.root);
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        return new Point(600, 400);
    }

    private int totalScalableSectionWeight(MGenericTile<?> node) {
        int total = 0;
        for (MUIElement subNode : node.getChildren()) {
            Object renderer;
            if (!subNode.isToBeRendered() || !subNode.isVisible() || (renderer = subNode.getRenderer()) == null || renderer.getClass() == XStackRenderer.class) continue;
            total += XSashLayout.getWeight(subNode);
        }
        return total;
    }

    private void tileSubNodes(Rectangle bounds, MUIElement node) {
        if (node != this.root) {
            this.setRectangle(node, bounds);
        }
        if (!(node instanceof MGenericTile)) {
            return;
        }
        MGenericTile sashContainer = (MGenericTile)node;
        List<MUIElement> visibleChildren = this.getVisibleChildren(sashContainer);
        int childCount = visibleChildren.size();
        int availableWidth = sashContainer.isHorizontal() ? bounds.width : bounds.height;
        int availableScalableSectionWidth = availableWidth -= (childCount - 1) * this.sashWidth;
        double totalScalableSectionWeight = this.totalScalableSectionWeight(sashContainer);
        for (MUIElement subNode : visibleChildren) {
            Object renderer = subNode.getRenderer();
            if (renderer == null || renderer.getClass() != XStackRenderer.class) continue;
            availableScalableSectionWidth -= this.suggestedSizeForViewStack;
        }
        int tilePos = sashContainer.isHorizontal() ? bounds.x : bounds.y;
        MUIElement prev = null;
        for (MUIElement subNode : visibleChildren) {
            if (prev != null) {
                tilePos += this.sashWidth;
            }
            int weight = XSashLayout.getWeight(subNode);
            double ratio = (double)weight / totalScalableSectionWeight;
            int newSize = (int)((double)availableScalableSectionWidth * ratio + 0.5);
            Object renderer = subNode.getRenderer();
            int y = bounds.y;
            int height = bounds.height;
            if (renderer != null && renderer.getClass() == XStackRenderer.class) {
                newSize = this.suggestedSizeForViewStack;
                y += this.suggestedDownDistanceForViewStack;
                height = height - this.suggestedDownDistanceForViewStack - 1;
            }
            Rectangle subBounds = sashContainer.isHorizontal() ? new Rectangle(tilePos, y, newSize, height) : new Rectangle(bounds.x, tilePos, bounds.width, newSize);
            tilePos += newSize;
            this.tileSubNodes(subBounds, subNode);
            prev = subNode;
        }
    }

    private void setRectangle(MUIElement node, Rectangle bounds) {
        if (node.getWidget() instanceof Control) {
            Control ctrl = (Control)node.getWidget();
            ctrl.setBounds(bounds);
        } else if (node.getWidget() instanceof Rectangle) {
            Rectangle theRect = (Rectangle)node.getWidget();
            theRect.x = bounds.x;
            theRect.y = bounds.y;
            theRect.width = bounds.width;
            theRect.height = bounds.height;
        }
    }

    private List<MUIElement> getVisibleChildren(MGenericTile<?> sashContainer) {
        ArrayList<MUIElement> visKids = new ArrayList<MUIElement>();
        for (MUIElement child : sashContainer.getChildren()) {
            if (!child.isToBeRendered() || !child.isVisible()) continue;
            visKids.add(child);
        }
        return visKids;
    }

    private static int getWeight(MUIElement element) {
        String info = element.getContainerData();
        if (info == null || info.length() == 0) {
            return 0;
        }
        try {
            int value = Integer.parseInt(info);
            return value;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    class SashRect {
        Rectangle rect;
        MGenericTile<?> container;
        MUIElement left;
        MUIElement right;

        public SashRect(Rectangle rect, MGenericTile<?> container, MUIElement left, MUIElement right) {
            this.container = container;
            this.rect = rect;
            this.left = left;
            this.right = right;
        }
    }
}

