/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.decoration;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.decoration.AbstractLineDecoration;
import org.xmind.gef.draw2d.decoration.IConnectionDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;

public abstract class AbstractConnectionDecoration
extends AbstractLineDecoration
implements IConnectionDecoration {
    private IAnchor sourceAnchor = null;
    private IAnchor targetAnchor = null;
    private PrecisionPoint sourcePos = null;
    private PrecisionPoint targetPos = null;

    protected AbstractConnectionDecoration() {
    }

    protected AbstractConnectionDecoration(String id) {
        super(id);
    }

    public IAnchor getSourceAnchor() {
        return this.sourceAnchor;
    }

    public IAnchor getTargetAnchor() {
        return this.targetAnchor;
    }

    public void setSourceAnchor(IFigure figure, IAnchor anchor) {
        if (anchor == this.sourceAnchor) {
            return;
        }
        this.sourceAnchor = anchor;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
    }

    public void setTargetAnchor(IFigure figure, IAnchor anchor) {
        if (anchor == this.targetAnchor) {
            return;
        }
        this.targetAnchor = anchor;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
    }

    public PrecisionPoint getSourcePosition(IFigure figure) {
        this.checkValidation(figure);
        return this.sourcePos;
    }

    public PrecisionPoint getTargetPosition(IFigure figure) {
        this.checkValidation(figure);
        return this.targetPos;
    }

    public void reroute(IFigure figure) {
        this.reroute(figure, false);
    }

    protected void reroute(IFigure figure, boolean validating) {
        PrecisionPoint oldSourcePos = this.sourcePos;
        PrecisionPoint oldTargetPos = this.targetPos;
        PrecisionPoint newSourcePos = new PrecisionPoint();
        PrecisionPoint newTargetPos = new PrecisionPoint();
        this.reroute(figure, newSourcePos, newTargetPos, validating);
        this.sourcePos = newSourcePos;
        this.targetPos = newTargetPos;
        if (!(validating || figure == null || newSourcePos.equals(oldSourcePos) && newTargetPos.equals(oldTargetPos))) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    protected void reroute(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos, boolean validating) {
        IAnchor sa = this.getSourceAnchor();
        IAnchor ta = this.getTargetAnchor();
        if (sa == null || ta == null) {
            if (sa != null) {
                sourcePos.setLocation(sa.getReferencePoint());
            }
            if (ta != null) {
                targetPos.setLocation(ta.getReferencePoint());
            }
            return;
        }
        targetPos.setLocation(ta.getLocation(sa.getReferencePoint(), 0.0));
        sourcePos.setLocation(sa.getLocation(ta.getReferencePoint(), 0.0));
    }

    public void validate(IFigure figure) {
        super.validate(figure);
        if (!this.isPositionValid()) {
            this.reroute(figure, true);
        }
    }

    protected boolean isPositionValid() {
        return this.sourcePos != null && this.targetPos != null;
    }
}

