/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.workbench.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.regex.Pattern;
import net.xmind.workbench.internal.Messages;
import net.xmind.workbench.internal.XMindNetWorkbench;
import net.xmind.workbench.ui.internal.NewsletterSubscriptionDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.core.net.FieldSet;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.net.http.HttpRequest;
import org.xmind.core.net.util.LinkUtils;

public class NewsletterSubscriptionReminder {
    private static final String SETTINGS_SECTION = "newsletterSubscription";
    private static final String KEY_LAUNCH_COUNT = "launchCount";
    private static final String KEY_NEVER_REMIND = "neverRemind";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^([a-zA-Z0-9_\\-\\.\\+]+)@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.)|(([a-zA-Z0-9\\-]+\\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\\]?)$");
    private IWorkbench workbench;

    public NewsletterSubscriptionReminder(IWorkbench workbench) {
        this.workbench = workbench;
    }

    public void start() {
        IDialogSettings settings = NewsletterSubscriptionReminder.getSettings();
        int launchCount = NewsletterSubscriptionReminder.getInt(settings, KEY_LAUNCH_COUNT, 0);
        if (launchCount >= NewsletterSubscriptionReminder.getSysInt("net.xmind.workbench.newsletter.reminder.silenceCount", 4) && !settings.getBoolean(KEY_NEVER_REMIND)) {
            this.show();
            NewsletterSubscriptionReminder.neverRemind();
        }
        if (launchCount < Integer.MAX_VALUE) {
            settings.put(KEY_LAUNCH_COUNT, ++launchCount);
        }
    }

    private void show() {
        if (this.workbench == null) {
            return;
        }
        Display display = this.workbench.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public void run() {
                    NewsletterSubscriptionReminder.this.doShow();
                }
            });
        }
    }

    private void doShow() {
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        Shell shell = window.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        NewsletterSubscriptionReminder.askToSubscribe(shell);
    }

    public static void askToSubscribe(Shell parentShell) {
        NewsletterSubscriptionDialog dialog = new NewsletterSubscriptionDialog(parentShell, new IInputValidator(){

            public String isValid(String newText) {
                if (newText == null || "".equals(newText) || !EMAIL_PATTERN.matcher(newText).matches()) {
                    return "";
                }
                return null;
            }
        });
        if (dialog.open() != 0) {
            return;
        }
        final String email = dialog.getValue();
        XMindNetWorkbench.getDefault().getUsageDataCollector().increase("SubscribeCount");
        Job job = XMindNetWorkbench.getDefault().createJob(Messages.NewsletterSubscriptionReminder_SubscribeToNewsletter_jobName, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                HttpRequest request = new HttpRequest(true, LinkUtils.getHostByLanguage((boolean)false, (boolean)false), -1, "/_res/newsletter/subscribe", new FieldSet().add("email", (Object)email).add("source", (Object)String.format("xmind_%s", System.getProperty("org.xmind.product.buildid", XMindNetWorkbench.getDefault().getBundle().getVersion().toString()))), null, "POST", null, null, null, null);
                try {
                    request.execute(monitor);
                }
                catch (HttpException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
        job.setSystem(true);
        job.schedule();
    }

    private static int getSysInt(String key, int defaultValue) {
        String value = System.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value, 10);
            }
            catch (Throwable throwable) {}
        }
        return defaultValue;
    }

    private static int getInt(IDialogSettings settings, String key, int defaultValue) {
        try {
            return settings.getInt(key);
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    private static IDialogSettings getSettings() {
        return XMindNetWorkbench.getDefault().getDialogSettingsSection(SETTINGS_SECTION);
    }

    public static void neverRemind() {
        NewsletterSubscriptionReminder.getSettings().put(KEY_NEVER_REMIND, true);
    }
}

