/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.outline.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.editor.MindMapEditor;
import org.xmind.ui.internal.exports.outline.Messages;
import org.xmind.ui.internal.exports.outline.OutlinePlugin;
import org.xmind.ui.internal.exports.outline.print.TextData;
import org.xmind.ui.internal.print.PrintConstants;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.UnitConvertor;
import org.xmind.ui.viewers.SWTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlinePrintSetupDialog
extends TitleAreaDialog {
    private static final String SECTION_ID = "org.xmind.ui.outline.print";
    private static final int VIEWER_WIDTH = 445;
    private static final int VIEWER_HEIGHT = 315;
    private static final int PORTRAIT_VIEWER_WIDTH = 315;
    private static final int PORTRAIT_VIEWER_HEIGHT = 445;
    private static final int PAGE_MARGIN = 10;
    private IEditorPart editor;
    private IDialogSettings settings;
    private Button currentMapRadio;
    private Button wholeWorkbookRadio;
    private Button pageNumberCheck;
    private Button borderCheck;
    private Button landscapeRadio;
    private Button portraitRadio;
    private Map<String, Text> inputControls;
    private Combo unitChooser;
    private Map<String, IAction[]> actions;
    private org.eclipse.draw2d.GridLayout pageLayout;
    private FigureCanvas previewCanvas;
    private IFigure previewFigure;
    private List<IFigure> pages;
    private List<IFigure> borders;
    private List<ITextFigure> headers;
    private List<ITextFigure> footers;
    private boolean updating = false;
    private boolean modifyingText = false;
    private List<TextData> datas = null;
    private Listener eventHandler = new Listener(){

        public void handleEvent(Event event) {
            OutlinePrintSetupDialog.this.handleWidgetEvent(event);
        }
    };

    public OutlinePrintSetupDialog(Shell parentShell, IEditorPart editor) {
        super(parentShell);
        this.editor = editor;
        this.settings = OutlinePlugin.getDialogSettings(SECTION_ID);
        this.init();
    }

    private void init() {
        this.initContent();
    }

    private void initContent() {
        if (this.getBoolean("contentWholeWorkbook")) {
            this.init((IWorkbook)this.editor.getAdapter(IWorkbook.class));
        } else {
            Object selectedPage;
            ISheet sheet;
            IPageChangeProvider pageProvider = (IPageChangeProvider)MindMapUIPlugin.getAdapter((Object)this.editor, IPageChangeProvider.class);
            if (pageProvider != null && (sheet = (ISheet)MindMapUIPlugin.getAdapter((Object)(selectedPage = pageProvider.getSelectedPage()), ISheet.class)) != null) {
                this.init(sheet);
            }
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.PageSetupDialog_windowTitle);
    }

    public void create() {
        super.create();
        this.update(null);
        this.setTitle(Messages.PageSetupDialog_title);
        this.setMessage(Messages.PageSetupDialog_description);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getSettings();
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }

    public IEditorPart getMindmapEditor() {
        return this.editor;
    }

    public void setMindmapEditor(MindMapEditor editor) {
        this.editor = editor;
    }

    public IDialogSettings getSettings() {
        return this.settings;
    }

    public List<TextData> getDatas() {
        return this.datas;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = IDialogConstants.NEXT_LABEL;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createSettingsPart(container);
        this.createPreviewPart(container);
        return composite;
    }

    private void createSettingsPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.widthHint = 210;
        layoutData.minimumWidth = 180;
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.creatContentSection(composite);
        this.createPageSetupSection(composite);
        this.createOrientationSection(composite);
        this.createMarginsSection(composite);
        this.createHeaderFooterSection(composite);
    }

    private void creatContentSection(Composite parent) {
        Composite section = this.createSection(parent, DialogMessages.PageSetupDialog_Content);
        this.currentMapRadio = new Button(section, 16);
        this.currentMapRadio.setText(DialogMessages.PageSetupDialog_CurrentMap);
        this.currentMapRadio.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.currentMapRadio, 13);
        this.wholeWorkbookRadio = new Button(section, 16);
        this.wholeWorkbookRadio.setText(DialogMessages.PageSetupDialog_WholeWorkbook);
        this.wholeWorkbookRadio.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.wholeWorkbookRadio, 13);
    }

    private void createPageSetupSection(Composite parent) {
        Composite section = this.createSection(parent, DialogMessages.PageSetupDialog_PageSetup);
        this.pageNumberCheck = new Button(section, 32);
        this.pageNumberCheck.setText(Messages.PageSetupDialog_PageNumber);
        this.pageNumberCheck.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.pageNumberCheck, 13);
        this.borderCheck = new Button(section, 32);
        this.borderCheck.setText(DialogMessages.PageSetupDialog_Border);
        this.borderCheck.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.borderCheck, 13);
    }

    private void createOrientationSection(Composite parent) {
        Composite section = this.createSection(parent, DialogMessages.PageSetupDialog_Orientation);
        Composite container = new Composite(section, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        this.landscapeRadio = new Button(container, 16);
        this.landscapeRadio.setData((Object)2);
        this.landscapeRadio.setText(DialogMessages.PageSetupDialog_Landscape);
        this.landscapeRadio.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.landscapeRadio, 13);
        this.portraitRadio = new Button(container, 16);
        this.portraitRadio.setData((Object)1);
        this.portraitRadio.setText(DialogMessages.PageSetupDialog_Portrait);
        this.portraitRadio.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.portraitRadio, 13);
    }

    private void createMarginsSection(Composite parent) {
        Composite section = this.createSection(parent, DialogMessages.PageSetupDialog_Margins);
        Composite container = new Composite(section, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createMarginInput(container, "leftMargin", DialogMessages.PageSetupDialog_Left);
        this.createMarginInput(container, "rightMargin", DialogMessages.PageSetupDialog_Right);
        this.createMarginInput(container, "topMargin", DialogMessages.PageSetupDialog_Top);
        this.createMarginInput(container, "bottomMargin", DialogMessages.PageSetupDialog_Bottom);
        this.unitChooser = new Combo(section, 2060);
        this.unitChooser.add(DialogMessages.PageSetupDialog_Inch);
        this.unitChooser.add(DialogMessages.PageSetupDialog_Millimeter);
        GridData unitLayoutData = new GridData(0x1000008, 4, true, false);
        this.unitChooser.setLayoutData((Object)unitLayoutData);
        this.hookWidget((Widget)this.unitChooser, 13);
    }

    private void createMarginInput(Composite parent, String key, String name) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        container.setLayout((Layout)layout);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(name);
        nameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Text input = this.createInputControl(container, key, true);
        GridData gd = new GridData(0x1000008, 4, false, false);
        gd.widthHint = 45;
        input.setLayoutData((Object)gd);
    }

    private Text createInputControl(Composite parent, final String key, boolean numeric) {
        Text input = new Text(parent, 2052);
        input.setData((Object)key);
        if (numeric) {
            SWTUtils.makeNumeralInput((Control)input, (boolean)false, (boolean)true);
        }
        this.hookWidget((Widget)input, 24);
        this.hookWidget((Widget)input, 14);
        this.hookWidget((Widget)input, 15);
        if (numeric) {
            this.hookWidget((Widget)input, 1);
        }
        if (this.inputControls == null) {
            this.inputControls = new HashMap<String, Text>();
        }
        this.inputControls.put(key, input);
        input.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (OutlinePrintSetupDialog.this.inputControls != null) {
                    OutlinePrintSetupDialog.this.inputControls.remove(key);
                }
            }
        });
        return input;
    }

    private void createHeaderFooterSection(Composite parent) {
        Composite section = this.createSection(parent, DialogMessages.PageSetupDialog_HeaderFooter);
        this.createHeaderSection(section);
        this.createFooterSection(section);
    }

    private void createHeaderSection(Composite parent) {
        this.createHFSection(parent, DialogMessages.PageSetupDialog_Header, "headerAlign", "headerFont", "headerText");
    }

    private void createFooterSection(Composite parent) {
        this.createHFSection(parent, DialogMessages.PageSetupDialog_Footer, "footerAlign", "footerFont", "footerText");
    }

    private void createHFSection(Composite parent, String name, final String alignKey, String fontKey, String textKey) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        AlignAction leftAction = new AlignAction(alignKey, "left");
        AlignAction centerAction = new AlignAction(alignKey, "center");
        AlignAction rightAction = new AlignAction(alignKey, "right");
        ToolBarManager alignBar = new ToolBarManager(0x800000);
        alignBar.add((IAction)leftAction);
        alignBar.add((IAction)centerAction);
        alignBar.add((IAction)rightAction);
        alignBar.createControl(container);
        alignBar.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
        this.addActions(alignKey, new IAction[]{leftAction, centerAction, rightAction});
        alignBar.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                OutlinePrintSetupDialog.this.removeActions(alignKey);
            }
        });
        ToolBarManager fontBar = new ToolBarManager(0x800000);
        FontAction fontAction = new FontAction(fontKey);
        fontBar.add((IAction)fontAction);
        fontBar.createControl(container);
        fontBar.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
        Text input = this.createInputControl(container, textKey, false);
        GridData inputLayoutData = new GridData(4, 4, true, false);
        inputLayoutData.horizontalSpan = 3;
        input.setLayoutData((Object)inputLayoutData);
    }

    private void addActions(String key, IAction ... actions) {
        if (this.actions == null) {
            this.actions = new HashMap<String, IAction[]>();
        }
        this.actions.put(key, actions);
    }

    private void removeActions(String key) {
        if (this.actions != null) {
            this.actions.remove(key);
        }
    }

    private IAction[] getActions(String key) {
        return this.actions == null ? null : this.actions.get(key);
    }

    private void hookWidget(Widget widget, int eventType) {
        widget.addListener(eventType, this.eventHandler);
    }

    private Composite createSection(Composite parent, String title) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createSectionTitle(composite, title);
        Composite container = new Composite(composite, 0);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 5;
        layout2.marginLeft = 5;
        container.setLayout((Layout)layout2);
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        return container;
    }

    private void createSectionTitle(Composite parent, String title) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Label titleLabel = new Label(composite, 0);
        titleLabel.setText(title);
        titleLabel.setFont(FontUtils.getBold((String)"org.eclipse.jface.defaultfont"));
        titleLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Label line = new Label(composite, 258);
        line.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createPreviewPart(Composite parent) {
        Composite container = this.createPreviewContainer(parent);
        Composite blackContainer = this.createBlackContainer(container);
        FigureCanvas canvas = this.createCanvas(blackContainer);
        IFigure figure = this.createPreviewFigure();
        canvas.setContents(figure);
        Label forReferenceLabel = new Label(container, 16384);
        forReferenceLabel.setText(DialogMessages.PageSetupDialog_JustForReference);
        forReferenceLabel.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)(Util.isMac() ? 9 : 7)));
        forReferenceLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private Composite createPreviewContainer(Composite parent) {
        Group container = new Group(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        return container;
    }

    private Composite createBlackContainer(Composite parent) {
        Composite container = new Composite(parent, 262144);
        container.setLayout((Layout)new FillLayout());
        container.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setBackground(e.display.getSystemColor(2));
                org.eclipse.swt.graphics.Rectangle r = ((Control)e.widget).getBounds();
                e.gc.fillRectangle(0, 0, r.width, r.height);
            }
        });
        return container;
    }

    private FigureCanvas createCanvas(Composite parent) {
        this.previewCanvas = new FigureCanvas(parent, 512);
        LightweightSystem lws = this.previewCanvas.getLightweightSystem();
        lws.getRootFigure().setPreferredSize(new Dimension(465, 465));
        return this.previewCanvas;
    }

    private IFigure createPreviewFigure() {
        this.previewFigure = new Figure();
        this.pageLayout = new org.eclipse.draw2d.GridLayout(1, true);
        this.pageLayout.verticalSpacing = 10;
        this.previewFigure.setLayoutManager((LayoutManager)this.pageLayout);
        return this.previewFigure;
    }

    private List<IFigure> createPages() {
        int lm = this.getControlMargin("leftMargin");
        int rm = this.getControlMargin("rightMargin");
        int tm = this.getControlMargin("topMargin");
        int bm = this.getControlMargin("bottomMargin");
        Figure page = new Figure();
        XYLayout layout = new XYLayout();
        page.setOpaque(true);
        page.setBackgroundColor(Display.getCurrent().getSystemColor(1));
        page.setLayoutManager((LayoutManager)layout);
        this.previewFigure.add((IFigure)page);
        int pageWidth = this.getPageWidth();
        int pageHeight = this.getPageHeight();
        page.setPreferredSize(pageWidth, pageHeight);
        this.previewFigure.add((IFigure)page);
        int innerWidth = pageWidth - lm - rm;
        int innerHeight = pageHeight - tm - bm;
        page.add(this.createBorder(), (Object)new Rectangle(lm, tm, innerWidth, innerHeight));
        ITextFigure header = this.createHeader(innerWidth);
        int headerHeight = 0;
        if (header != null) {
            headerHeight = header.getPreferredSize().height;
            page.add((IFigure)header, (Object)new Rectangle(lm, tm, innerWidth, headerHeight));
        }
        ITextFigure pageNumber = this.createPageNumber(1);
        int pageNumberHeight = 0;
        if (pageNumber != null) {
            pageNumberHeight = pageNumber.getPreferredSize().height;
            page.add((IFigure)pageNumber, (Object)new Rectangle(lm, tm + innerHeight - pageNumberHeight, innerWidth, pageNumberHeight));
        }
        ITextFigure footer = this.createFooter(innerWidth);
        int footerHeight = 0;
        if (footer != null) {
            footerHeight = footer.getPreferredSize().height;
            page.add((IFigure)footer, (Object)new Rectangle(lm, tm + innerHeight - pageNumberHeight - footerHeight, innerWidth, footerHeight));
        }
        if (this.pages == null) {
            this.pages = new ArrayList<IFigure>();
        }
        this.pages.add((IFigure)page);
        int x = lm;
        int h = tm + headerHeight;
        int bottom = pageHeight - bm - pageNumberHeight - footerHeight;
        int index = 2;
        for (TextData data : this.datas) {
            String text = data.getText();
            int level = data.getLevel();
            Font font = this.getContentFont(data);
            RotatableWrapLabel label = new RotatableWrapLabel(text);
            label.setFont(font);
            label.setTextAlignment(1);
            x = level * 5 + lm;
            label.setPrefWidth(pageWidth - x - rm);
            int labelHeight = label.getPreferredSize().height;
            if (h + labelHeight > bottom) {
                page = new Figure();
                page.setLayoutManager((LayoutManager)layout);
                page.setOpaque(true);
                page.setBackgroundColor(Display.getCurrent().getSystemColor(1));
                page.setPreferredSize(pageWidth, pageHeight);
                this.previewFigure.add((IFigure)page);
                page.add(this.createBorder(), (Object)new Rectangle(lm, tm, innerWidth, innerHeight));
                header = this.createHeader(innerWidth);
                if (header != null) {
                    headerHeight = header.getPreferredSize().height;
                    page.add((IFigure)header, (Object)new Rectangle(lm, tm, innerWidth, headerHeight));
                }
                if ((pageNumber = this.createPageNumber(index++)) != null) {
                    pageNumberHeight = pageNumber.getPreferredSize().height;
                    page.add((IFigure)pageNumber, (Object)new Rectangle(lm, tm + innerHeight - pageNumberHeight, innerWidth, pageNumberHeight));
                }
                if ((footer = this.createFooter(innerWidth)) != null) {
                    footerHeight = footer.getPreferredSize().height;
                    page.add((IFigure)footer, (Object)new Rectangle(lm, tm + innerHeight - pageNumberHeight - footerHeight, innerWidth, footerHeight));
                }
                this.pages.add((IFigure)page);
                h = tm + headerHeight;
            }
            page.add((IFigure)label, (Object)new Rectangle(x, h, pageWidth - x - rm, labelHeight));
            h += labelHeight;
        }
        return this.pages;
    }

    private Font getContentFont(TextData data) {
        String type = data.getType();
        if ("root".equals(type)) {
            return FontUtils.getFont((String)"Calibri Light", (int)14, (boolean)false, (boolean)false);
        }
        if ("attached".equals(type)) {
            switch (data.getLevel()) {
                case 1: {
                    return FontUtils.getFont((String)"Calibri", (int)8, (boolean)false, (boolean)false);
                }
                case 2: {
                    return FontUtils.getFont((String)"Calibri", (int)6, (boolean)true, (boolean)false);
                }
            }
        } else if ("summary".equals(type) || "callout".equals(type)) {
            return FontUtils.getFont((String)"Calibri", (int)6, (boolean)false, (boolean)true);
        }
        return FontUtils.getFont((String)"Calibri", (int)6, (boolean)false, (boolean)false);
    }

    private IFigure createBorder() {
        Figure border = new Figure();
        border.setVisible(this.borderCheck.getSelection());
        border.setBorder((Border)new LineBorder(Display.getCurrent().getSystemColor(2), 1));
        if (this.borders == null) {
            this.borders = new ArrayList<IFigure>();
        }
        this.borders.add((IFigure)border);
        return border;
    }

    private ITextFigure createPageNumber(int index) {
        if (this.getBoolean("noPageNumber")) {
            return null;
        }
        RotatableWrapLabel label = new RotatableWrapLabel();
        label.setTextAlignment(4);
        label.setFont(Display.getCurrent().getSystemFont());
        label.setText(String.valueOf(Messages.PageSetupDialog_PageNumber_title) + index);
        return label;
    }

    private ITextFigure createHeader(int width) {
        ITextFigure header = this.createHFSection("headerText", "", "headerAlign", "center", 2, "headerFont", width);
        if (header != null) {
            if (this.headers == null) {
                this.headers = new ArrayList<ITextFigure>();
            }
            this.headers.add(header);
        }
        return header;
    }

    private ITextFigure createFooter(int width) {
        ITextFigure footer = this.createHFSection("footerText", "", "footerAlign", "right", 4, "footerFont", width);
        if (footer != null) {
            if (this.footers == null) {
                this.footers = new ArrayList<ITextFigure>();
            }
            this.footers.add(footer);
        }
        return footer;
    }

    private ITextFigure createHFSection(String textKey, String defaultText, String alignKey, String defaultAlign, int defaultDraw2DAlign, String fontKey, int width) {
        Text input;
        String text = this.getString(textKey, defaultText);
        if (text.equals("")) {
            return null;
        }
        String alignValue = this.getString(alignKey, defaultAlign);
        IAction[] alignActions = this.getActions(alignKey);
        if (alignActions != null) {
            IAction[] iActionArray = alignActions;
            int n = alignActions.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action = iActionArray[n2];
                action.setChecked(((AlignAction)action).value.equals(alignValue));
                ++n2;
            }
        }
        if (!this.modifyingText && this.inputControls != null && (input = this.inputControls.get(textKey)) != null && !input.isDisposed()) {
            input.setText(text);
        }
        RotatableWrapLabel textFigure = new RotatableWrapLabel();
        textFigure.setPrefWidth(width);
        textFigure.setText(text);
        textFigure.setTextAlignment(PrintConstants.toDraw2DAlignment((String)alignValue, (int)defaultDraw2DAlign));
        String fontValue = this.getString(fontKey, null);
        Font font = null;
        if (fontValue != null) {
            font = FontUtils.getFont((String)fontValue);
        }
        if (font == null) {
            font = Display.getCurrent().getSystemFont();
        }
        textFigure.setFont(font);
        return textFigure;
    }

    private void clearPages() {
        if (this.pages != null && !this.pages.isEmpty()) {
            for (IFigure page : this.pages) {
                this.previewFigure.remove(page);
            }
            this.pages.clear();
        }
        if (this.borders != null && !this.borders.isEmpty()) {
            this.borders.clear();
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            this.headers.clear();
        }
        if (this.footers != null && !this.footers.isEmpty()) {
            this.footers.clear();
        }
    }

    protected void setProperty(String key, String value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    protected void setProperty(String key, int value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    protected void setProperty(String key, double value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    protected void setProperty(String key, boolean value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    private void update(String key) {
        if (this.updating) {
            return;
        }
        boolean numberChanged = key == null || "noPageNumber".equals(key);
        boolean borderChanged = key == null || "border".equals(key);
        boolean unitChanged = key == null || "marginUnit".equals(key);
        boolean marginChanged = key == null || unitChanged || "leftMargin".equals(key) || "rightMargin".equals(key) || "topMargin".endsWith(key) || "bottomMargin".equals(key);
        boolean headerAlignChanged = key == null || "headerAlign".equals(key);
        boolean headerChanged = key == null || "headerFont".equals(key) || "headerText".equals(key);
        boolean footerAlignChanged = key == null || "footerAlign".equals(key);
        boolean footerChanged = key == null || "footerFont".equals(key) || "footerText".equals(key);
        boolean orientationChanged = key == null || "orientation".equals(key);
        boolean contentChanged = key == null || "contentWholeWorkbook".equals(key);
        this.updating = true;
        if (contentChanged) {
            this.currentMapRadio.setSelection(!this.getBoolean("contentWholeWorkbook"));
            this.wholeWorkbookRadio.setSelection(this.getBoolean("contentWholeWorkbook"));
            this.initContent();
            this.refreshPages();
        }
        if (numberChanged) {
            boolean showNumber;
            boolean bl = showNumber = !this.getBoolean("noPageNumber");
            if (this.pageNumberCheck != null && !this.pageNumberCheck.isDisposed()) {
                this.pageNumberCheck.setSelection(showNumber);
            }
            this.refreshPages();
        }
        if (borderChanged) {
            boolean showBorder = this.getBoolean("border");
            if (this.borders != null && !this.borders.isEmpty()) {
                for (IFigure border : this.borders) {
                    border.setVisible(showBorder);
                }
            }
            if (this.borderCheck != null && !this.borderCheck.isDisposed()) {
                this.borderCheck.setSelection(showBorder);
            }
        }
        if (marginChanged) {
            if (key == null || unitChanged) {
                this.updateMargins("leftMargin", "rightMargin", "topMargin", "bottomMargin");
            } else {
                this.updateMargins(key);
            }
        }
        if (unitChanged && this.unitChooser != null && !this.unitChooser.isDisposed()) {
            int index = PrintConstants.UNITS.indexOf(this.getString("marginUnit", "inch"));
            if (index < 0 || index >= this.unitChooser.getItemCount()) {
                index = 0;
            }
            this.unitChooser.select(index);
        }
        if (headerAlignChanged) {
            this.updateHFSectionAlign("headerAlign", "center", 2);
        }
        if (headerChanged) {
            this.refreshPages();
        }
        if (footerAlignChanged) {
            this.updateHFSectionAlign("footerAlign", "right", 4);
        }
        if (footerChanged) {
            this.refreshPages();
        }
        if (orientationChanged) {
            this.updateOrientation();
        }
        this.updating = false;
    }

    private void updateHFSectionAlign(String alignKey, String defaultAlign, int defaultDraw2DAlign) {
        String alignValue = this.getString(alignKey, defaultAlign);
        IAction[] alignActions = this.getActions(alignKey);
        if (alignActions != null) {
            IAction[] iActionArray = alignActions;
            int n = alignActions.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action = iActionArray[n2];
                action.setChecked(((AlignAction)action).value.equals(alignValue));
                ++n2;
            }
        }
        if ("headerAlign".equals(alignKey) && this.headers != null && !this.headers.isEmpty()) {
            for (ITextFigure header : this.headers) {
                header.setTextAlignment(PrintConstants.toDraw2DAlignment((String)alignValue, (int)defaultDraw2DAlign));
            }
        }
        if ("footerAlign".equals(alignKey) && this.footers != null && !this.footers.isEmpty()) {
            for (ITextFigure footer : this.footers) {
                footer.setTextAlignment(PrintConstants.toDraw2DAlignment((String)alignValue, (int)defaultDraw2DAlign));
            }
        }
    }

    private void updateMargins(String ... keys) {
        if (!this.modifyingText && this.inputControls != null) {
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                Text text = this.inputControls.get(key);
                if (text != null && !text.isDisposed()) {
                    text.setText(this.getMarginText(key));
                }
                ++n2;
            }
        }
        this.refreshPages();
    }

    private void updateOrientation() {
        int orientation = this.getInteger("orientation", 1);
        boolean landscape = orientation != 1;
        this.landscapeRadio.setSelection(landscape);
        this.portraitRadio.setSelection(!landscape);
        org.eclipse.draw2d.GridLayout layout = (org.eclipse.draw2d.GridLayout)this.previewFigure.getLayoutManager();
        layout.marginWidth = orientation == 2 ? 5 : 70;
        this.refreshPages();
    }

    private void refreshPages() {
        this.clearPages();
        this.createPages();
    }

    private void init(IWorkbook workbook) {
        if (this.datas != null && !this.datas.isEmpty()) {
            this.datas.clear();
        }
        for (ISheet s : workbook.getSheets()) {
            this.appendTopicTitle(s.getRootTopic(), 0, "root");
            this.append(new TextData("", 0, "root"));
        }
    }

    private void init(ISheet sheet) {
        if (this.datas != null && !this.datas.isEmpty()) {
            this.datas.clear();
        }
        this.appendTopicTitle(sheet.getRootTopic(), 0, "root");
    }

    private void appendTopicTitle(ITopic topic, int level, String type) {
        int tl = "summary".equals(type) ? level - 1 : level;
        this.append(new TextData(this.trimTitle(topic.getTitleText()), tl, type));
        List attacheds = topic.getChildren("attached");
        for (ITopic attached : attacheds) {
            this.appendTopicTitle(attached, level + 1, "attached");
        }
        List detacheds = topic.getChildren("detached");
        for (ITopic detached : detacheds) {
            this.appendTopicTitle(detached, level + 1, "detached");
        }
        List summaries = topic.getChildren("summary");
        for (ITopic summary : summaries) {
            this.appendTopicTitle(summary, level + 1, "summary");
        }
        List callouts = topic.getChildren("callout");
        for (ITopic callout : callouts) {
            this.appendTopicTitle(callout, level + 1, "callout");
        }
    }

    private String trimTitle(String title) {
        return title.replaceAll("\r\n|\r|\n|\t", " ");
    }

    private void append(TextData data) {
        if (this.datas == null) {
            this.datas = new ArrayList<TextData>();
        }
        this.datas.add(data);
    }

    private int getControlMargin(String key) {
        double value = this.getDouble(key, 0.2);
        value = "leftMargin".equals(key) || "rightMargin".equals(key) ? (value *= (double)UnitConvertor.getScreenDpi().x) : (value *= (double)UnitConvertor.getScreenDpi().y);
        return (int)value;
    }

    private int getPageWidth() {
        int orientation = this.getInteger("orientation", 1);
        if (orientation == 1) {
            return 315;
        }
        return 445;
    }

    private int getPageHeight() {
        int orientation = this.getInteger("orientation", 1);
        if (orientation == 1) {
            return 445;
        }
        return 315;
    }

    private String getMarginText(String key) {
        double value = this.getDouble(key, 0.2);
        if ("milliter".equals(this.getString("marginUnit", "inch"))) {
            value = UnitConvertor.inch2mm((double)value);
        }
        return String.valueOf(value);
    }

    private String getString(String key, String defaultValue) {
        String value = this.getSettings().get(key);
        return value == null ? defaultValue : value;
    }

    private boolean getBoolean(String key) {
        return this.getSettings().getBoolean(key);
    }

    private double getDouble(String key, double defaultValue) {
        try {
            return this.getSettings().getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private int getInteger(String key, int defaultValue) {
        try {
            return this.getSettings().getInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private void handleWidgetEvent(Event event) {
        if (event.widget == this.currentMapRadio) {
            this.setProperty("contentWholeWorkbook", !this.currentMapRadio.getSelection());
        } else if (event.widget == this.wholeWorkbookRadio) {
            this.setProperty("contentWholeWorkbook", this.wholeWorkbookRadio.getSelection());
        } else if (event.widget == this.pageNumberCheck) {
            this.setProperty("noPageNumber", !this.pageNumberCheck.getSelection());
        } else if (event.widget == this.borderCheck) {
            this.setProperty("border", this.borderCheck.getSelection());
        } else if (event.widget == this.unitChooser) {
            int index = this.unitChooser.getSelectionIndex();
            if (index < 0 || index >= PrintConstants.UNITS.size()) {
                index = 0;
            }
            this.setProperty("marginUnit", (String)PrintConstants.UNITS.get(index));
        } else if (event.widget == this.landscapeRadio || event.widget == this.portraitRadio) {
            this.setProperty("orientation", (Integer)event.widget.getData());
        } else if (event.widget instanceof Text && this.inputControls != null && this.inputControls.containsValue(event.widget)) {
            Text input = (Text)event.widget;
            if (event.type == 15) {
                input.selectAll();
            } else if (event.type == 1) {
                if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000001)) {
                    this.stepValue(input, 1);
                } else if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000002)) {
                    this.stepValue(input, -1);
                }
            } else if (event.type == 14 || event.type == 24) {
                if (this.updating) {
                    return;
                }
                int caretPosition = input.getCaretPosition();
                this.modifyingText = true;
                String key = (String)event.widget.getData();
                if (key.equals("headerText") || key.equals("footerText")) {
                    this.setProperty(key, input.getText());
                } else {
                    try {
                        double value = Double.parseDouble(input.getText());
                        this.setMargin(key, value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                this.modifyingText = false;
                caretPosition = Math.min(caretPosition, input.getText().length());
                input.setSelection(caretPosition);
            }
        }
    }

    private void stepValue(Text input, int stepFactor) {
        double value;
        try {
            value = Double.parseDouble(input.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        String[] parts = OutlinePrintSetupDialog.split1000(value);
        int integer = Integer.parseInt(parts[0], 10);
        if ((integer += this.getStep() * stepFactor) < 100) {
            integer = 100;
        }
        value = OutlinePrintSetupDialog.join1000(String.valueOf(integer), parts[1]);
        this.setMargin((String)input.getData(), value);
    }

    public int getStep() {
        if ("milliter".equals(this.getString("marginUnit", "inch"))) {
            return 500;
        }
        return 100;
    }

    private static String[] split1000(double value) {
        String repr = String.valueOf(String.valueOf(value)) + "000";
        int dotIndex = repr.indexOf(".");
        if (dotIndex < 0) {
            return new String[]{repr, ""};
        }
        return new String[]{String.valueOf(repr.substring(0, dotIndex)) + repr.substring(dotIndex + 1, dotIndex + 4), repr.substring(dotIndex + 4)};
    }

    private static double join1000(String prefix, String suffix) {
        prefix = "000" + prefix;
        String mid = prefix.substring(prefix.length() - 3);
        prefix = prefix.substring(0, prefix.length() - 3);
        return Double.parseDouble(String.valueOf(prefix) + "." + mid + suffix);
    }

    private void setMargin(String key, double value) {
        if ("milliter".equals(this.getString("marginUnit", "inch"))) {
            value = UnitConvertor.mm2inch((double)value);
        }
        this.setProperty(key, value);
    }

    private class AlignAction
    extends Action {
        private String key;
        private String value;

        public AlignAction(String key, String value) {
            super(null, 2);
            this.key = key;
            this.value = value;
            if ("left".equals(value)) {
                this.setText(DialogMessages.PageSetupDialog_AlignLeft_text);
                this.setToolTipText(DialogMessages.PageSetupDialog_AlignLeft_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("align_left.png", true));
            } else if ("center".equals(value)) {
                this.setText(DialogMessages.PageSetupDialog_AlignCenter_text);
                this.setToolTipText(DialogMessages.PageSetupDialog_AlignCenter_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("align_center.png", true));
            } else {
                this.setText(DialogMessages.PageSetupDialog_AlignRight_text);
                this.setToolTipText(DialogMessages.PageSetupDialog_AlignRight_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("align_right.png", true));
            }
        }

        public void run() {
            OutlinePrintSetupDialog.this.setProperty(this.key, this.value);
        }
    }

    private class FontAction
    extends Action {
        private String key;

        public FontAction(String key) {
            this.key = key;
            this.setText(DialogMessages.PageSetupDialog_Font_text);
            this.setToolTipText(DialogMessages.PageSetupDialog_Font_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("text_font.png", true));
        }

        public void run() {
            FontDialog dialog = new FontDialog(OutlinePrintSetupDialog.this.getShell());
            String string = OutlinePrintSetupDialog.this.getString(this.key, null);
            if (string == null) {
                dialog.setFontList(JFaceResources.getDefaultFontDescriptor().getFontData());
            } else {
                dialog.setFontList(FontUtils.toFontData((String)string));
            }
            FontData open = dialog.open();
            if (open == null) {
                return;
            }
            OutlinePrintSetupDialog.this.setProperty(this.key, FontUtils.toString((FontData[])dialog.getFontList()));
        }
    }
}

