/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4handlers;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.xmind.core.style.IStyle;
import org.xmind.ui.internal.e4models.IContextRunnable;
import org.xmind.ui.internal.e4models.IModelPartContext;
import org.xmind.ui.internal.e4models.ThemesPart;
import org.xmind.ui.internal.resourcemanager.ResourceManagerDialogPart;
import org.xmind.ui.internal.resourcemanager.ThemeResourceManagerViewer;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.internal.views.CategorizedThemeViewer;
import org.xmind.ui.mindmap.MindMapUI;

public class SetDefaultThemeHandler {
    private IStyle styleToSetDefault;

    @Execute
    public void execute(IEclipseContext context) {
        if (this.styleToSetDefault != null) {
            IEclipseContext parentContext;
            MindMapUI.getResourceManager().setDefaultTheme(this.styleToSetDefault.getId());
            IContextRunnable refreshRunnable = E4Utils.getContextRunnable(context, "org.xmind.ui.modelPart.refreshPage");
            if (refreshRunnable != null) {
                refreshRunnable.run();
            }
            if ((parentContext = context.getParent()) != null) {
                ThemesPart themesPart;
                ResourceManagerDialogPart dialogPart;
                ISelectionProvider selectionProvider;
                IModelPartContext modelContext = (IModelPartContext)parentContext.get(IModelPartContext.class);
                if (modelContext instanceof ResourceManagerDialogPart && (selectionProvider = (ISelectionProvider)(dialogPart = (ResourceManagerDialogPart)modelContext).getAdapter(ISelectionProvider.class)) instanceof ThemeResourceManagerViewer) {
                    ((ThemeResourceManagerViewer)selectionProvider).selectDefault();
                }
                if (modelContext instanceof ThemesPart && (selectionProvider = (ISelectionProvider)(themesPart = (ThemesPart)modelContext).getAdapter(ISelectionProvider.class)) instanceof CategorizedThemeViewer) {
                    ((CategorizedThemeViewer)selectionProvider).selectDefault();
                }
            }
            this.styleToSetDefault = null;
        }
    }

    @CanExecute
    public boolean canExecute(IEclipseContext context) {
        Object selection = context.get("org.eclipse.ui.selection");
        if (!(selection instanceof IStructuredSelection) || ((IStructuredSelection)selection).size() != 1) {
            return false;
        }
        Object ele = ((IStructuredSelection)selection).getFirstElement();
        if (!(ele instanceof IStyle)) {
            return false;
        }
        IStyle style = (IStyle)ele;
        if (!"theme".equals(style.getType())) {
            return false;
        }
        this.styleToSetDefault = style;
        return true;
    }
}

