/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.filters.ImageFilter;

public class Transparency
implements ImageFilter {
    private final AlphaComposite composite;

    public Transparency(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("The alpha must be between 0.0f and 1.0f, inclusive.");
        }
        this.composite = AlphaComposite.getInstance(3, alpha);
    }

    public Transparency(double alpha) {
        this((float)alpha);
    }

    public BufferedImage apply(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImage finalImage = new BufferedImage(width, height, 2);
        Graphics2D g = finalImage.createGraphics();
        g.setComposite(this.composite);
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return finalImage;
    }

    public float getAlpha() {
        return this.composite.getAlpha();
    }
}

