/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.table;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public abstract class GenericEditor
extends DefaultCellEditor {
    Class[] argTypes = new Class[]{String.class};
    Constructor constructor;
    Object value;

    public GenericEditor() {
        super(new JTextField());
        this.getComponent().setName("Table.editor");
    }

    public abstract boolean validate(Object var1);

    public abstract boolean isEmptyAllowed();

    @Override
    public boolean stopCellEditing() {
        String s = (String)super.getCellEditorValue();
        if ("".equals(s)) {
            if (this.isEmptyAllowed()) {
                if (this.constructor.getDeclaringClass() == String.class) {
                    this.value = s;
                }
                super.stopCellEditing();
            } else {
                ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                return false;
            }
        }
        try {
            this.value = this.constructor.newInstance(s);
        }
        catch (Exception e) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            return false;
        }
        if (!this.validate(this.value)) {
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = null;
        ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
        try {
            Class<Object> type = table.getColumnClass(column);
            if (type == Object.class) {
                type = String.class;
            }
            this.constructor = type.getConstructor(this.argTypes);
        }
        catch (Exception e) {
            return null;
        }
        return super.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }
}

