/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jortho;

import com.inet.jortho.Suggestion;
import com.inet.jortho.Suggestions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DictionaryBase {
    protected char[] tree;
    protected int size;
    protected int idx;
    protected static final char LAST_CHAR = '\uffff';

    DictionaryBase(char[] cArray) {
        this.tree = cArray;
        this.size = cArray.length;
    }

    protected DictionaryBase() {
    }

    public boolean exist(String string) {
        this.idx = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            while (this.idx < this.size && this.tree[this.idx] < c) {
                this.idx += 3;
            }
            if (this.idx >= this.size || this.tree[this.idx] != c) {
                return false;
            }
            if (i == string.length() - 1 && this.isWordMatch()) {
                return true;
            }
            this.idx = this.readIndex();
            if (this.idx > 0) continue;
            return false;
        }
        return false;
    }

    public List<Suggestion> searchSuggestions(String string) {
        if (string.length() == 0 || this.exist(string)) {
            return new ArrayList<Suggestion>();
        }
        Suggestions suggestions = new Suggestions(Math.min(20, 4 + string.length()));
        this.idx = 0;
        this.searchSuggestions(suggestions, string, 0, 0, 0);
        List<Suggestion> list = suggestions.getlist();
        Collections.sort(list);
        return list;
    }

    private void searchSuggestions(Suggestions suggestions, CharSequence charSequence, int n, int n2, int n3) {
        StringBuilder stringBuilder;
        CharSequence charSequence2;
        int n4;
        if (n3 > suggestions.getMaxDissimilarity()) {
            return;
        }
        this.idx = n2;
        char c = charSequence.charAt(n);
        if (this.searchChar(c)) {
            if (this.isWordMatch()) {
                if (n + 1 == charSequence.length()) {
                    suggestions.add(new Suggestion(charSequence, n3));
                } else {
                    n4 = n + 1;
                    charSequence2 = charSequence.subSequence(0, n4);
                    suggestions.add(new Suggestion(charSequence2, n3 + (charSequence.length() - n4) * 5));
                }
            }
            this.idx = this.readIndex();
            if (this.idx > 0) {
                if (n + 1 == charSequence.length()) {
                    this.searchSuggestionsLonger(suggestions, charSequence, this.idx, n3 + 5);
                } else {
                    this.searchSuggestions(suggestions, charSequence, n + 1, this.idx, n3);
                }
            }
        }
        if (n + 1 < charSequence.length()) {
            this.idx = n2;
            c = charSequence.charAt(n + 1);
            if (this.searchChar(c)) {
                n4 = this.idx;
                this.idx = this.readIndex();
                if (this.idx > 0) {
                    charSequence2 = new StringBuilder(charSequence);
                    ((StringBuilder)charSequence2).setCharAt(n + 1, charSequence.charAt(n));
                    ((StringBuilder)charSequence2).setCharAt(n, c);
                    this.searchSuggestions(suggestions, charSequence2, n + 1, this.idx, n3 + 3);
                }
                this.idx = n4;
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append(charSequence, 0, n);
                ((StringBuilder)charSequence2).append(charSequence, n + 1, charSequence.length());
                this.searchSuggestions(suggestions, charSequence2, n, n2, n3 + 5);
            }
        }
        n4 = this.idx = n2;
        while (this.idx < this.size && this.tree[this.idx] < '\uffff') {
            char c2 = this.tree[this.idx];
            this.idx = this.readIndex();
            if (this.idx > 0 && c2 != c) {
                stringBuilder = new StringBuilder(charSequence);
                stringBuilder.insert(n, c2);
                this.searchSuggestions(suggestions, stringBuilder, n + 1, this.idx, n3 + 5);
            }
            this.idx = n4 += 3;
        }
        if (n < charSequence.length()) {
            c = charSequence.charAt(n);
            n4 = this.idx = n2;
            while (this.idx < this.size && this.tree[this.idx] < '\uffff') {
                if (this.isWordMatch()) {
                    charSequence2 = new StringBuilder();
                    ((StringBuilder)charSequence2).append(charSequence, 0, n);
                    ((StringBuilder)charSequence2).append(this.tree[this.idx]);
                    suggestions.add(new Suggestion(charSequence2, n3 + 5 + (charSequence.length() - ((StringBuilder)charSequence2).length()) * 5));
                }
                if (n + 1 < charSequence.length()) {
                    char c3 = this.tree[this.idx];
                    this.idx = this.readIndex();
                    if (this.idx > 0 && c3 != c) {
                        stringBuilder = new StringBuilder(charSequence);
                        stringBuilder.setCharAt(n, c3);
                        this.searchSuggestions(suggestions, stringBuilder, n + 1, this.idx, n3 + this.charDiff(c, c3));
                    }
                }
                this.idx = n4 += 3;
            }
        }
    }

    private void searchSuggestionsLonger(Suggestions suggestions, CharSequence charSequence, int n, int n2) {
        int n3 = this.idx = n;
        while (this.idx < this.size && this.tree[this.idx] < '\uffff') {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(charSequence);
            stringBuilder.append(this.tree[this.idx]);
            this.searchSuggestions(suggestions, stringBuilder, charSequence.length(), this.idx, n2);
            this.idx = n3 += 3;
        }
    }

    private boolean searchChar(char c) {
        while (this.idx < this.size && this.tree[this.idx] < c) {
            this.idx += 3;
        }
        return this.idx < this.size && this.tree[this.idx] == c;
    }

    private boolean isWordMatch() {
        return (this.tree[this.idx + 1] & 0x8000) > 0;
    }

    final int readIndex() {
        return ((this.tree[this.idx + 1] & Short.MAX_VALUE) << 16) + this.tree[this.idx + 2];
    }

    private int charDiff(char c, char c2) {
        if ((c = Character.toLowerCase(c)) == (c2 = Character.toLowerCase(c2))) {
            return 1;
        }
        if (Character.getType(c) != Character.getType(c2)) {
            return 6;
        }
        return 5;
    }
}

