/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tools;

import org.junit.Assert;
import org.junit.Test;
import org.languagetool.tools.ContextTools;

public class ContextToolsTest {
    @Test
    public void testGetContext() throws Exception {
        ContextTools contextTools = new ContextTools();
        String context = contextTools.getContext(4, 8, "Hi, this is some nice text waiting for its error markers.");
        Assert.assertEquals((Object)"Hi, <b><font bgcolor=\"#ff8b8b\">this</font></b> is some nice text waiting for its error...", (Object)context);
        String context2 = contextTools.getContext(3, 5, "xxx\n \nyyy");
        Assert.assertEquals((Object)"xxx<b><font bgcolor=\"#ff8b8b\">&nbsp;&nbsp;</font></b> yyy", (Object)context2);
    }

    @Test
    public void testPlainTextContext() throws Exception {
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(5);
        String input = "This is a test sentence. Here's another sentence with more text.";
        String result = contextTools.getPlainTextContext(8, 14, input);
        Assert.assertEquals((Object)"...s is a test sent...\n        ^^^^^^     ", (Object)result);
    }

    @Test
    public void testPlainTextContextWithLineBreaks() throws Exception {
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(5);
        String input = "One.\nThis is a test sentence.\nHere's another sentence.";
        String result = contextTools.getPlainTextContext(15, 19, input);
        Assert.assertEquals((Object)"...is a test sent...\n        ^^^^     ", (Object)result);
    }

    @Test
    public void testPlainTextContextWithDosLineBreaks() throws Exception {
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(5);
        String input = "One.\r\nThis is a test sentence.\r\nHere's another sentence.";
        String result = contextTools.getPlainTextContext(16, 20, input);
        Assert.assertEquals((Object)"...is a test sent...\n        ^^^^     ", (Object)result);
    }

    @Test
    public void testLargerContext() throws Exception {
        ContextTools contextTools = new ContextTools();
        contextTools.setContextSize(100);
        String context = contextTools.getContext(4, 8, "Hi, this is some nice text waiting for its error markers.");
        Assert.assertEquals((Object)"Hi, <b><font bgcolor=\"#ff8b8b\">this</font></b> is some nice text waiting for its error markers.", (Object)context);
    }

    @Test
    public void testHtmlEscape() throws Exception {
        ContextTools contextTools = new ContextTools();
        String context1 = contextTools.getContext(0, 2, "Hi, this is <html>.");
        Assert.assertEquals((Object)"<b><font bgcolor=\"#ff8b8b\">Hi</font></b>, this is &lt;html&gt;.", (Object)context1);
        contextTools.setEscapeHtml(false);
        String context2 = contextTools.getContext(0, 2, "Hi, this is <html>.");
        Assert.assertEquals((Object)"<b><font bgcolor=\"#ff8b8b\">Hi</font></b>, this is <html>.", (Object)context2);
    }

    @Test
    public void testMarkers() throws Exception {
        ContextTools contextTools = new ContextTools();
        contextTools.setErrorMarkerStart("<X>");
        contextTools.setErrorMarkerEnd("</X>");
        String context = contextTools.getContext(0, 2, "Hi, this is it.");
        Assert.assertEquals((Object)"<X>Hi</X>, this is it.", (Object)context);
    }
}

