/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.dialogs.changeset.query.BBoxRestrictionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.OpenAndCloseStateRestrictionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.TimeRestrictionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.UserRestrictionPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.tools.I18n;

public class AdvancedChangesetQueryPanel
extends JPanel {
    private final JCheckBox cbUserRestriction = new JCheckBox();
    private final JCheckBox cbOpenAndCloseRestrictions = new JCheckBox();
    private final JCheckBox cbTimeRestrictions = new JCheckBox();
    private final JCheckBox cbBoundingBoxRestriction = new JCheckBox();
    private final UserRestrictionPanel pnlUserRestriction = new UserRestrictionPanel();
    private final OpenAndCloseStateRestrictionPanel pnlOpenAndCloseRestriction = new OpenAndCloseStateRestrictionPanel();
    private final TimeRestrictionPanel pnlTimeRestriction = new TimeRestrictionPanel();
    private final BBoxRestrictionPanel pnlBoundingBoxRestriction = new BBoxRestrictionPanel();

    public AdvancedChangesetQueryPanel() {
        this.build();
    }

    protected JPanel buildQueryPanel() {
        RestrictionGroupStateChangeHandler restrictionGroupStateChangeHandler = new RestrictionGroupStateChangeHandler();
        VerticallyScrollablePanel verticallyScrollablePanel = new VerticallyScrollablePanel(new GridBagLayout());
        verticallyScrollablePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        verticallyScrollablePanel.add((Component)this.cbUserRestriction, gridBagConstraints);
        this.cbUserRestriction.addItemListener(restrictionGroupStateChangeHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)new JMultilineLabel(I18n.tr("Select changesets owned by specific users", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)this.pnlUserRestriction, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        verticallyScrollablePanel.add((Component)this.cbOpenAndCloseRestrictions, gridBagConstraints);
        this.cbOpenAndCloseRestrictions.addItemListener(restrictionGroupStateChangeHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)new JMultilineLabel(I18n.tr("Select changesets depending on whether they are open or closed", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)this.pnlOpenAndCloseRestriction, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        verticallyScrollablePanel.add((Component)this.cbTimeRestrictions, gridBagConstraints);
        this.cbTimeRestrictions.addItemListener(restrictionGroupStateChangeHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)new JMultilineLabel(I18n.tr("Select changesets based on the date/time they have been created or closed", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)this.pnlTimeRestriction, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        verticallyScrollablePanel.add((Component)this.cbBoundingBoxRestriction, gridBagConstraints);
        this.cbBoundingBoxRestriction.addItemListener(restrictionGroupStateChangeHandler);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)new JMultilineLabel(I18n.tr("Select only changesets related to a specific bounding box", new Object[0])), gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        verticallyScrollablePanel.add((Component)this.pnlBoundingBoxRestriction, gridBagConstraints);
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        verticallyScrollablePanel.add((Component)new JPanel(), gridBagConstraints);
        return verticallyScrollablePanel;
    }

    protected final void build() {
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = GuiHelper.embedInVerticalScrollPane(this.buildQueryPanel());
        this.add((Component)jScrollPane, "Center");
    }

    public void startUserInput() {
        this.restoreFromSettings();
        this.pnlBoundingBoxRestriction.setVisible(this.cbBoundingBoxRestriction.isSelected());
        this.pnlOpenAndCloseRestriction.setVisible(this.cbOpenAndCloseRestrictions.isSelected());
        this.pnlTimeRestriction.setVisible(this.cbTimeRestrictions.isSelected());
        this.pnlUserRestriction.setVisible(this.cbUserRestriction.isSelected());
        this.pnlOpenAndCloseRestriction.startUserInput();
        this.pnlUserRestriction.startUserInput();
        this.pnlTimeRestriction.startUserInput();
    }

    public void displayMessageIfInvalid() {
        if (this.cbUserRestriction.isSelected()) {
            if (!this.pnlUserRestriction.isValidChangesetQuery()) {
                this.pnlUserRestriction.displayMessageIfInvalid();
            }
        } else if (this.cbTimeRestrictions.isSelected()) {
            if (!this.pnlTimeRestriction.isValidChangesetQuery()) {
                this.pnlTimeRestriction.displayMessageIfInvalid();
            }
        } else if (this.cbBoundingBoxRestriction.isSelected() && !this.pnlBoundingBoxRestriction.isValidChangesetQuery()) {
            this.pnlBoundingBoxRestriction.displayMessageIfInvalid();
        }
    }

    public ChangesetQuery buildChangesetQuery() {
        ChangesetQuery changesetQuery = new ChangesetQuery();
        if (this.cbUserRestriction.isSelected()) {
            if (!this.pnlUserRestriction.isValidChangesetQuery()) {
                return null;
            }
            this.pnlUserRestriction.fillInQuery(changesetQuery);
        }
        if (this.cbOpenAndCloseRestrictions.isSelected()) {
            this.pnlOpenAndCloseRestriction.fillInQuery(changesetQuery);
        }
        if (this.cbBoundingBoxRestriction.isSelected()) {
            if (!this.pnlBoundingBoxRestriction.isValidChangesetQuery()) {
                return null;
            }
            this.pnlBoundingBoxRestriction.fillInQuery(changesetQuery);
        }
        if (this.cbTimeRestrictions.isSelected()) {
            if (!this.pnlTimeRestriction.isValidChangesetQuery()) {
                return null;
            }
            this.pnlTimeRestriction.fillInQuery(changesetQuery);
        }
        return changesetQuery;
    }

    public void rememberSettings() {
        Main.pref.put("changeset-query.advanced.user-restrictions", this.cbUserRestriction.isSelected());
        Main.pref.put("changeset-query.advanced.open-restrictions", this.cbOpenAndCloseRestrictions.isSelected());
        Main.pref.put("changeset-query.advanced.time-restrictions", this.cbTimeRestrictions.isSelected());
        Main.pref.put("changeset-query.advanced.bbox-restrictions", this.cbBoundingBoxRestriction.isSelected());
        this.pnlUserRestriction.rememberSettings();
        this.pnlOpenAndCloseRestriction.rememberSettings();
        this.pnlTimeRestriction.rememberSettings();
    }

    public void restoreFromSettings() {
        this.cbUserRestriction.setSelected(Main.pref.getBoolean("changeset-query.advanced.user-restrictions", false));
        this.cbOpenAndCloseRestrictions.setSelected(Main.pref.getBoolean("changeset-query.advanced.open-restrictions", false));
        this.cbTimeRestrictions.setSelected(Main.pref.getBoolean("changeset-query.advanced.time-restrictions", false));
        this.cbBoundingBoxRestriction.setSelected(Main.pref.getBoolean("changeset-query.advanced.bbox-restrictions", false));
    }

    class RestrictionGroupStateChangeHandler
    implements ItemListener {
        RestrictionGroupStateChangeHandler() {
        }

        protected void userRestrictionStateChanged() {
            if (AdvancedChangesetQueryPanel.this.pnlUserRestriction == null) {
                return;
            }
            AdvancedChangesetQueryPanel.this.pnlUserRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbUserRestriction.isSelected());
        }

        protected void openCloseRestrictionStateChanged() {
            if (AdvancedChangesetQueryPanel.this.pnlOpenAndCloseRestriction == null) {
                return;
            }
            AdvancedChangesetQueryPanel.this.pnlOpenAndCloseRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbOpenAndCloseRestrictions.isSelected());
        }

        protected void timeRestrictionsStateChanged() {
            if (AdvancedChangesetQueryPanel.this.pnlTimeRestriction == null) {
                return;
            }
            AdvancedChangesetQueryPanel.this.pnlTimeRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbTimeRestrictions.isSelected());
        }

        protected void boundingBoxRestrictionChanged() {
            if (AdvancedChangesetQueryPanel.this.pnlBoundingBoxRestriction == null) {
                return;
            }
            AdvancedChangesetQueryPanel.this.pnlBoundingBoxRestriction.setVisible(AdvancedChangesetQueryPanel.this.cbBoundingBoxRestriction.isSelected());
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == AdvancedChangesetQueryPanel.this.cbUserRestriction) {
                this.userRestrictionStateChanged();
            } else if (itemEvent.getSource() == AdvancedChangesetQueryPanel.this.cbOpenAndCloseRestrictions) {
                this.openCloseRestrictionStateChanged();
            } else if (itemEvent.getSource() == AdvancedChangesetQueryPanel.this.cbTimeRestrictions) {
                this.timeRestrictionsStateChanged();
            } else if (itemEvent.getSource() == AdvancedChangesetQueryPanel.this.cbBoundingBoxRestriction) {
                this.boundingBoxRestrictionChanged();
            }
            AdvancedChangesetQueryPanel.this.validate();
            AdvancedChangesetQueryPanel.this.repaint();
        }
    }
}

