/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.callback;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public interface AuthnCallback {
    public UsernameResult usernamePrompt(String var1, boolean var2);

    public UserPasswordResult userPasswordPrompt(String var1, String var2, boolean var3);

    public SSLServerTrustResult sslServerTrustPrompt(String var1, SSLServerCertFailures var2, SSLServerCertInfo var3, boolean var4);

    public SSLClientCertResult sslClientCertPrompt(String var1, boolean var2);

    public SSLClientCertPassphraseResult sslClientCertPassphrasePrompt(String var1, boolean var2);

    public boolean allowStorePlaintextPassword(String var1);

    public boolean allowStorePlaintextPassphrase(String var1);

    public static final class SSLClientCertPassphraseResult
    extends AuthnResult
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public SSLClientCertPassphraseResult(String passphrase) {
            this.secret = passphrase;
        }

        public SSLClientCertPassphraseResult(String passphrase, boolean maySave) {
            this.save = maySave;
            this.secret = passphrase;
        }
    }

    public static final class SSLClientCertResult
    extends AuthnResult
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public SSLClientCertResult(String path) {
            this.identity = path;
        }

        public SSLClientCertResult(String path, boolean maySave) {
            this.save = maySave;
            this.identity = path;
        }
    }

    public static final class SSLServerTrustResult
    extends AuthnResult
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public static SSLServerTrustResult reject() {
            return new SSLServerTrustResult(false, false);
        }

        public static SSLServerTrustResult acceptTemporarily() {
            return new SSLServerTrustResult(true, false);
        }

        public static SSLServerTrustResult acceptPermanently() {
            return new SSLServerTrustResult(true, true);
        }

        private SSLServerTrustResult(boolean accept, boolean maySave) {
            this.save = maySave;
            this.trust = accept;
        }
    }

    public static class SSLServerCertInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String subject;
        private String issuer;
        private Date validFrom;
        private Date validTo;
        private byte[] fingerprint;
        private List<String> hostnames;
        private String asciiCert;

        public String getSubject() {
            return this.subject;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public Date getValidFrom() {
            return this.validFrom;
        }

        public Date getValidTo() {
            return this.validTo;
        }

        public byte[] getFingerprint() {
            return this.fingerprint;
        }

        public List<String> getHostnames() {
            return this.hostnames;
        }

        public String getCert() {
            return this.asciiCert;
        }

        private SSLServerCertInfo(String subject, String issuer, long validFrom, long validTo, byte[] fingerprint, List<String> hostnames, String asciiCert) {
            this.subject = subject;
            this.issuer = issuer;
            this.validFrom = new Date(validFrom);
            this.validTo = new Date(validTo);
            this.fingerprint = fingerprint;
            this.hostnames = hostnames;
            this.asciiCert = asciiCert;
        }
    }

    public static class SSLServerCertFailures
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int NOT_YET_VALID = 1;
        private static final int EXPIRED = 2;
        private static final int CN_MISMATCH = 4;
        private static final int UNKNOWN_CA = 8;
        private static final int OTHER = 0x40000000;
        private static final int ALL_KNOWN = 0x4000000F;
        private int failures;

        public boolean notYetValid() {
            return (this.failures & 1) != 0;
        }

        public boolean expired() {
            return (this.failures & 2) != 0;
        }

        public boolean cnMismatch() {
            return (this.failures & 4) != 0;
        }

        public boolean unknownCA() {
            return (this.failures & 8) != 0;
        }

        public boolean other() {
            return (this.failures & 0x40000000) != 0 || (this.failures & 0xBFFFFFF0) != 0;
        }

        public int getFailures() {
            return this.failures;
        }

        private SSLServerCertFailures(int failures) {
            int missing = failures & 0xBFFFFFF0;
            if (missing != 0) {
                Logger log = Logger.getLogger("org.apache.subversion.javahl");
                log.warning(String.format("Unknown SSL certificate parsing failure flags: %1$x", missing));
            }
            this.failures = failures;
        }
    }

    public static final class UserPasswordResult
    extends AuthnResult
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public UserPasswordResult(String username, String password) {
            this.identity = username;
            this.secret = password;
        }

        public UserPasswordResult(String username, String password, boolean maySave) {
            this.save = maySave;
            this.identity = username;
            this.secret = password;
        }
    }

    public static final class UsernameResult
    extends AuthnResult
    implements Serializable {
        private static final long serialVersionUID = 1L;

        public UsernameResult(String username) {
            this.identity = username;
        }

        public UsernameResult(String username, boolean maySave) {
            this.save = maySave;
            this.identity = username;
        }
    }

    public static abstract class AuthnResult {
        protected boolean save = false;
        protected boolean trust = false;
        protected String identity = null;
        protected String secret = null;
    }
}

