/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.frames.models;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.modules.debugger.jpda.truffle.frames.models.DebuggingTruffleActionsProvider;
import org.netbeans.modules.debugger.jpda.truffle.frames.models.TruffleDVFrame;
import org.netbeans.modules.debugger.jpda.truffle.options.TruffleOptions;
import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;
import org.netbeans.modules.debugger.jpda.ui.debugging.JPDADVFrame;
import org.netbeans.modules.debugger.jpda.ui.debugging.JPDADVThread;
import org.netbeans.modules.debugger.jpda.util.WeakCacheMap;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class DebuggingTruffleTreeModel
implements TreeModelFilter {
    private static final Predicate<String> PREDICATE1 = Pattern.compile("^((com|org)\\.\\p{Alpha}*\\.truffle|(com|org)(\\.graalvm|\\.truffleruby))\\..*$").asPredicate();
    private static final String FILTER1 = "com.[A-z]*.truffle.";
    private static final String FILTER2 = "com.oracle.graal.";
    private static final String FILTER3 = "org.netbeans.modules.debugger.jpda.backend.";
    private final JPDADebugger debugger;
    private final List<ModelListener> listeners = new ArrayList<ModelListener>();
    private final PropertyChangeListener propListenerHolder;

    public DebuggingTruffleTreeModel(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.propListenerHolder = propEvent -> {
            ModelListener[] mls;
            List<ModelListener> list = this.listeners;
            synchronized (list) {
                mls = this.listeners.toArray(new ModelListener[this.listeners.size()]);
            }
            ModelEvent.TreeChanged event = new ModelEvent.TreeChanged((Object)"Root");
            for (ModelListener ml : mls) {
                ml.modelChanged((ModelEvent)event);
            }
        };
        TruffleOptions.onLanguageDeveloperModeChange(this.propListenerHolder);
        DebuggingTruffleActionsProvider.onShowAllHostFramesChange(this.propListenerHolder);
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        Object[] children = original.getChildren(parent, from, to);
        if (parent instanceof DebuggingView.DVThread && children.length > 0 && !DebuggingTruffleActionsProvider.isShowAllHostFrames((DebuggingView.DVThread)parent)) {
            JPDAThread thread = (JPDAThread)((WeakCacheMap.KeyedValue)parent).getKey();
            CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentGuestPCInfo(thread);
            boolean inGuest = DebuggingTruffleTreeModel.isInGuest(children[0]);
            boolean haveTopHostFrames = false;
            if (currentPCInfo == null) {
                currentPCInfo = inGuest ? TruffleAccess.getCurrentSuspendHereInfo(thread) : TruffleAccess.getSuspendHere(thread);
                haveTopHostFrames = true;
            }
            if (currentPCInfo != null) {
                boolean showInternalFrames = TruffleOptions.isLanguageDeveloperMode();
                TruffleStackFrame[] stackFrames = currentPCInfo.getStack().getStackFrames(showInternalFrames);
                children = inGuest && !currentPCInfo.getStack().hasJavaFrames() ? DebuggingTruffleTreeModel.filterAndAppend(children, stackFrames, currentPCInfo.getTopFrame()) : DebuggingTruffleTreeModel.mergeFrames(children, stackFrames, currentPCInfo.getTopFrame(), haveTopHostFrames);
            }
        }
        return children;
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        return Integer.MAX_VALUE;
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        if (node instanceof TruffleStackFrame) {
            return true;
        }
        return original.isLeaf(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    private static boolean isInGuest(Object child) {
        if (child instanceof CallStackFrame) {
            CallStackFrame csf = (CallStackFrame)child;
            return "org.netbeans.modules.debugger.jpda.backend.truffle.JPDATruffleAccessor".equals(csf.getClassName());
        }
        return false;
    }

    private static Object[] filterAndAppend(Object[] children, TruffleStackFrame[] stackFrames, TruffleStackFrame topFrame) {
        ArrayList<Object> newChildren = new ArrayList<Object>(children.length);
        for (Object ch : children) {
            String className;
            if (ch instanceof CallStackFrame && (PREDICATE1.test(className = ((CallStackFrame)ch).getClassName()) || className.startsWith(FILTER2) || className.startsWith(FILTER3))) continue;
            newChildren.add(ch);
        }
        int i = 0;
        newChildren.add(i++, topFrame);
        for (TruffleStackFrame tsf : stackFrames) {
            newChildren.add(i++, tsf);
        }
        return newChildren.toArray();
    }

    private static TruffleStackFrame[] join(TruffleStackFrame[] stackFrames, TruffleStackFrame topFrame) {
        TruffleStackFrame[] joined = new TruffleStackFrame[stackFrames.length + 1];
        joined[0] = topFrame;
        System.arraycopy(stackFrames, 0, joined, 1, stackFrames.length);
        return joined;
    }

    static Object[] mergeFrames(Object[] children, TruffleStackFrame[] stackFrames, TruffleStackFrame topFrame, boolean haveTopHostFrames) {
        int chi;
        ArrayList<Object> newChildren = new ArrayList<Object>(children.length);
        stackFrames = DebuggingTruffleTreeModel.join(stackFrames, topFrame);
        if (haveTopHostFrames) {
            boolean step2Java = false;
            for (chi = 0; chi < children.length; ++chi) {
                Object ch = children[chi];
                if (ch instanceof CallStackFrame) {
                    String packageName;
                    CallStackFrame csf = (CallStackFrame)ch;
                    String className = csf.getClassName();
                    if ("com.oracle.truffle.polyglot.HostMethodDesc$SingleMethod$MHBase".equals(className) && "invokeHandle".equals(csf.getMethodName())) {
                        step2Java = true;
                        break;
                    }
                    int lastDot = className.lastIndexOf(46);
                    String string = packageName = lastDot > 0 ? className.substring(0, lastDot) : "";
                    if ("org.graalvm.polyglot".equals(packageName)) break;
                }
                newChildren.add(ch);
            }
            if (!step2Java) {
                newChildren.clear();
            }
        }
        block1: for (TruffleStackFrame tframe : stackFrames) {
            if (tframe.isHost() && chi < children.length) {
                while (chi < children.length) {
                    Object ch = children[chi];
                    if (ch instanceof CallStackFrame) {
                        CallStackFrame csf = (CallStackFrame)ch;
                        String className = csf.getClassName();
                        if (!className.startsWith(FILTER3) && DebuggingTruffleTreeModel.equalFrames(csf, tframe)) {
                            newChildren.add(csf);
                            ++chi;
                            continue block1;
                        }
                    } else {
                        newChildren.add(ch);
                    }
                    ++chi;
                }
                continue;
            }
            newChildren.add(tframe);
        }
        while (chi < children.length) {
            newChildren.add(children[chi]);
            ++chi;
        }
        return newChildren.toArray();
    }

    static List<DebuggingView.DVFrame> filterAndAppend(JPDADVThread thread, List<DebuggingView.DVFrame> children, TruffleStackFrame[] stackFrames, TruffleStackFrame topFrame) {
        ArrayList<DebuggingView.DVFrame> newChildren = new ArrayList<DebuggingView.DVFrame>(children.size());
        for (DebuggingView.DVFrame ch : children) {
            String className;
            if (ch instanceof JPDADVFrame && (PREDICATE1.test(className = ((JPDADVFrame)ch).getCallStackFrame().getClassName()) || className.startsWith(FILTER2) || className.startsWith(FILTER3))) continue;
            newChildren.add(ch);
        }
        int i = 0;
        newChildren.add(i++, new TruffleDVFrame((DebuggingView.DVThread)thread, topFrame));
        for (TruffleStackFrame tsf : stackFrames) {
            newChildren.add(i++, new TruffleDVFrame((DebuggingView.DVThread)thread, tsf));
        }
        return Collections.unmodifiableList(newChildren);
    }

    static List<DebuggingView.DVFrame> mergeFrames(JPDADVThread thread, List<DebuggingView.DVFrame> children, TruffleStackFrame[] stackFrames, TruffleStackFrame topFrame, boolean haveTopHostFrames) {
        int chi;
        ArrayList<DebuggingView.DVFrame> newChildren = new ArrayList<DebuggingView.DVFrame>(children.size());
        stackFrames = DebuggingTruffleTreeModel.join(stackFrames, topFrame);
        if (haveTopHostFrames) {
            DebuggingView.DVFrame ch;
            CallStackFrame csf;
            for (chi = 0; !(chi >= children.size() || "com.oracle.truffle.polyglot.HostMethodDesc$SingleMethod$MHBase".equals((csf = ((JPDADVFrame)(ch = children.get(chi))).getCallStackFrame()).getClassName()) && "invokeHandle".equals(csf.getMethodName())); ++chi) {
                newChildren.add(ch);
            }
        }
        block1: for (TruffleStackFrame tframe : stackFrames) {
            if (tframe.isHost()) {
                while (chi < children.size()) {
                    DebuggingView.DVFrame ch = children.get(chi);
                    CallStackFrame csf = ((JPDADVFrame)ch).getCallStackFrame();
                    String className = csf.getClassName();
                    if (!className.startsWith(FILTER3) && DebuggingTruffleTreeModel.equalFrames(csf, tframe)) {
                        newChildren.add(ch);
                        ++chi;
                        continue block1;
                    }
                    ++chi;
                }
                continue;
            }
            newChildren.add(new TruffleDVFrame((DebuggingView.DVThread)thread, tframe));
        }
        while (chi < children.size()) {
            newChildren.add(children.get(chi));
            ++chi;
        }
        return Collections.unmodifiableList(newChildren);
    }

    private static boolean equalFrames(CallStackFrame csf, TruffleStackFrame tframe) {
        if (!csf.getClassName().equals(tframe.getHostClassName())) {
            return false;
        }
        if (!csf.getMethodName().equals(tframe.getHostMethodName())) {
            return false;
        }
        int linej = csf.getLineNumber(null);
        SourcePosition sourcePosition = tframe.getSourcePosition();
        if (sourcePosition == null) {
            return false;
        }
        int linet = sourcePosition.getStartLine();
        return linej == linet || linej == 0;
    }
}

