/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.commonjs;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.commonjs.CommonJSRequireBuiltin;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;

@GeneratedBy(value=CommonJSRequireBuiltin.class)
public final class CommonJSRequireBuiltinNodeGen
extends CommonJSRequireBuiltin
implements Introspection.Provider {
    @Node.Child
    private JavaScriptNode arguments0_;
    @Node.Child
    private JavaScriptNode arguments1_;
    @CompilerDirectives.CompilationFinal
    private int state_;

    private CommonJSRequireBuiltinNodeGen(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        super(context, builtin);
        this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
        this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
    }

    @Override
    public JavaScriptNode[] getArguments() {
        return new JavaScriptNode[]{this.arguments0_, this.arguments1_};
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        Object arguments0Value_ = this.arguments0_.execute(frameValue);
        Object arguments1Value_ = this.arguments1_.execute(frameValue);
        if ((state & 1) != 0 && JSTypes.isDynamicObject(arguments0Value_)) {
            DynamicObject arguments0Value__ = (DynamicObject)arguments0Value_;
            if (JSTypesGen.isImplicitString((state & 0xE) >>> 1, arguments1Value_)) {
                String arguments1Value__ = JSTypesGen.asImplicitString((state & 0xE) >>> 1, arguments1Value_);
                return this.require(arguments0Value__, arguments1Value__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arguments0Value_, arguments1Value_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    private Object executeAndSpecialize(Object arguments0Value, Object arguments1Value) {
        int state = this.state_;
        if (JSTypes.isDynamicObject(arguments0Value)) {
            DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
            int stringCast1 = JSTypesGen.specializeImplicitString(arguments1Value);
            if (stringCast1 != 0) {
                String arguments1Value_ = JSTypesGen.asImplicitString(stringCast1, arguments1Value);
                state |= stringCast1 << 1;
                this.state_ = state |= 1;
                return this.require(arguments0Value_, arguments1Value_);
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.arguments0_, this.arguments1_}, new Object[]{arguments0Value, arguments1Value});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 1) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[2];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "require";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static CommonJSRequireBuiltin create(JSContext context, JSBuiltin builtin, JavaScriptNode[] arguments) {
        return new CommonJSRequireBuiltinNodeGen(context, builtin, arguments);
    }
}

