/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class EjbsNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project p) {
        WebProject project = (WebProject)p.getLookup().lookup(WebProject.class);
        assert (project != null);
        return new EjbNodeList(project);
    }

    private static class EjbNodeList
    implements NodeList<String>,
    PropertyChangeListener {
        private static final String KEY_EJBS = "ejbKey";
        private final WebProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private Node view = null;
        private boolean isViewEmpty = true;
        private final J2eeProjectCapabilities projectCap;
        private static final RequestProcessor rp = new RequestProcessor();
        private RequestProcessor.Task checkTask = null;

        EjbNodeList(WebProject proj) {
            this.project = proj;
            this.projectCap = J2eeProjectCapabilities.forProject((Project)this.project);
        }

        public List<String> keys() {
            if (this.projectCap.isEjb31LiteSupported()) {
                this.checkView();
            }
            if (!this.isViewEmpty) {
                return Collections.singletonList(KEY_EJBS);
            }
            return Collections.emptyList();
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public Node node(String key) {
            if (KEY_EJBS.equals(key)) {
                return this.view;
            }
            return null;
        }

        public void addNotify() {
            if (this.projectCap.isEjb31LiteSupported()) {
                EjbJar ejbModule = this.project.getAPIEjbJar();
                this.view = J2eeProjectView.createEjbsView((EjbJar)ejbModule, (Project)this.project);
            }
            this.project.evaluator().addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void removeNotify() {
            this.project.evaluator().removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String p = evt.getPropertyName();
            if (p != null && (p.equals("j2ee.platform") || p.startsWith("/EnterpriseBeans/"))) {
                this.fireChange();
            }
        }

        private void fireChange() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    changeSupport.fireChange();
                }
            });
        }

        private synchronized void checkView() {
            if (this.checkTask != null) {
                this.checkTask.schedule(100);
                return;
            }
            this.checkTask = rp.post(new Runnable(){

                @Override
                public void run() {
                    Boolean isEmpty = Boolean.TRUE;
                    try {
                        Future becomesIsEmpty = project.getAPIEjbJar().getMetadataModel().runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Boolean>(){

                            public Boolean run(EjbJarMetadata metadata) {
                                EnterpriseBeans enterpriseBeans;
                                org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar = metadata.getRoot();
                                if (ejbJar != null && (enterpriseBeans = ejbJar.getEnterpriseBeans()) != null) {
                                    enterpriseBeans.removePropertyChangeListener((PropertyChangeListener)this);
                                    enterpriseBeans.addPropertyChangeListener((PropertyChangeListener)this);
                                    if (enterpriseBeans.getEjbs().length > 0) {
                                        return Boolean.FALSE;
                                    }
                                }
                                return Boolean.TRUE;
                            }
                        });
                        isEmpty = (Boolean)becomesIsEmpty.get();
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    catch (InterruptedException ie) {
                        Exceptions.printStackTrace((Throwable)ie);
                    }
                    catch (ExecutionException ee) {
                        Exceptions.printStackTrace((Throwable)ee);
                    }
                    if (isEmpty != null && isEmpty ^ isViewEmpty) {
                        isViewEmpty = isEmpty;
                        this.fireChange();
                    }
                }
            }, 100);
        }
    }
}

